package com.ejianc.business.sub.service.impl;

import com.ejianc.business.sub.bean.CertificateEntity;
import com.ejianc.business.sub.service.ICertificateService;
import com.ejianc.business.sub.utils.MessageUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@Service("certificate") 
public class CertificateBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	MessageUtil messageUtil;
	@Value("${common.env.base-host}")
	private String baseHost;
	@Autowired
	private ICertificateService service;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		CertificateEntity entity = service.selectById(billId);
//		您有项分包签证任务需要商讨，项目名称：xxx ，单据编号ES001001
		List<String> messageType = new ArrayList<>();
		List<String> receivers = new ArrayList<>();
		messageType.add("sys");
		receivers.add(entity.getCostResponsibleId().toString());
		receivers.add(entity.getBusinessResponsibleId().toString());
		receivers.add(entity.getProjectDirectorId().toString());
		receivers.add(entity.getMiddlebrowId().toString());
		String formUrl = baseHost +"ejc-sub-frontend/#/certificate/card?id="+billId;
//
		String subject = "您有项分包签证任务需要商讨,项目名称:"+(null==entity.getProjectName()?"":entity.getProjectName())+" ，单据编号【"+entity.getBillCode()+"】请及时处理";
		String content = "您有项分包签证任务需要商讨,项目名称:"+(null==entity.getProjectName()?"":entity.getProjectName())+" ，单据编号【"+entity.getBillCode()+"】请及时处理！。<a href=" + '"' + formUrl + '"' + ">立即处理</a>";
		messageUtil.sendMsg(messageType, receivers, "notice", subject, content);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
