package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.sub.vo.LabSettleVO;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sub.mapper.LabSettleMapper;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.service.ILabSettleService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 劳务结算
 * 
 * @author generator
 * 
 */
@Service("labSettleService")
public class LabSettleServiceImpl extends BaseServiceImpl<LabSettleMapper, LabSettleEntity> implements ILabSettleService{
    @Autowired
    private IPayContractApi payContractApi;
    @Override
    public JSONObject querySubSettleVOList(QueryParam param, boolean isEs) {
        Page<LabSettleVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<LabSettleVO> list = baseMapper.querySubSettleVOList(pages, wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> settleIds = list.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse<Map<Long, BigDecimal>> applyMnyHasFreeRes = payContractApi.getApplyMnyHasFree(settleIds);
            Map<Long, BigDecimal> settleApplyData = applyMnyHasFreeRes.getData();
            for (LabSettleVO subSettleVO : list) {
                BigDecimal sumApplyMnyHasFree = settleApplyData.get(subSettleVO.getId());
                subSettleVO.setSumApplyMny(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub(subSettleVO.getSettleTaxMny(), sumApplyMnyHasFree);
                subSettleVO.setSurplusApplyMny(surplusApplyMny);
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

}
