package com.ejianc.business.sub.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.business.sub.vo.SubContractorContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * TODO
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping(value = "/api/contract/")
public class ContractApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IContractService service;

	@Autowired
	private ISettleService settleService;

	@GetMapping(value = "fetchSjzcje")
	public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value = "projectId") Long projectId) {
		return CommonResponse.success(service.fetchSjzcje(projectId));
	}

	@PostMapping(value = "getContractByCondition")
	@ResponseBody
	public CommonResponse<List<ContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds) {
		LambdaUpdateWrapper<ContractEntity> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
		lambdaUpdateWrapper.in(ContractEntity::getEnquiryPriceBillId, enquiryPriceBillIds);
		lambdaUpdateWrapper.orderByDesc(ContractEntity::getSignDate);
		List<ContractEntity> list = service.list(lambdaUpdateWrapper);
		return CommonResponse.success(BeanMapper.mapList(list, ContractVO.class));
	}

	@GetMapping(value = "getSettleVO")
	public CommonResponse<SettleVO> getSettleVO(@RequestParam(value = "settleId") Long settleId) {
		return CommonResponse.success(settleService.queryDetail(settleId, true));
	}


	@GetMapping(value = "getSubContractorContractVO")
	public CommonResponse<SubContractorContractVO> getSubContractorContractVO(@RequestParam(value = "supplierId") Long supplierId) {
		SubContractorContractVO imageVO = new SubContractorContractVO();
		LambdaQueryWrapper<ContractEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(ContractEntity::getSupplierId, supplierId);
		queryWrapper.in(ContractEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		List<ContractEntity> contractList = service.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(contractList)) {
			// 本单位签约次数
			imageVO.setSignNum(contractList.size());
			// 合作项目数
			List<Long> projectList = contractList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
			imageVO.setProjectNum(projectList.size());
			// 累计签约金额
			BigDecimal signMny = contractList.stream().map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
			imageVO.setSignMny(signMny);
			// 累计已付金额
			BigDecimal payedMny = contractList.stream().map(ContractEntity::getSumPayMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
			imageVO.setPayedMny(payedMny);
		}
		return CommonResponse.success("查询数据成功！", imageVO);
	}

}
