package com.ejianc.business.sub.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.vo.SettleDetailVO;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 分包过程结算表 Mapper 接口
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Mapper
public interface SettleMapper extends BaseCrudMapper<SettleEntity> {

    List<SubSettleVO> querySubSettleVOList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<SettleDetailVO> getSumSettleNumInfo(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<SettleDetailVO> querySettleDetailHistory(SettleDetailVO settleDetailVO);

    List<SettleDetailVO> querySettleDetailList(SettleDetailVO settleDetailVO);

    String querySettleDetailSum(SettleDetailVO sd);
}
