package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ILabSettleService;
import com.ejianc.business.sub.vo.LabSettleVO;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

@Service("labSettle") 
public class LabSettleBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private PSRMRestUtil psrmRestUtil;

	@Autowired
	private ILabSettleService service;

	@Autowired
	private IContractService contractService;

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LabSettleEntity labSettleEntity = service.selectById(billId);
		ContractEntity contractEntity  = contractService.getById(labSettleEntity.getContractId());
		BigDecimal settleTaxMny = labSettleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : labSettleEntity.getSettleTaxMny();
		BigDecimal settleMny = labSettleEntity.getSettleMny() == null ? BigDecimal.ZERO : labSettleEntity.getSettleMny();
		LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(ContractEntity::getSumSettleTaxMny, settleTaxMny);
		updateWrapper.set(ContractEntity::getSumSettleMny, settleMny);
		contractService.update(contractEntity, updateWrapper, false);

		if (psrmRestUtil.isRunMode() && StringUtils.isNotBlank(contractEntity.getPsrmReturncode())) {
			PSRMResponse psrmResponse = service.saveOrUpdatePsrmObj(BeanMapper.map(labSettleEntity, LabSettleVO.class));
			logger.info("psrmResponse:{}", psrmResponse);
			if (psrmResponse.isSuccess()) {
				LambdaUpdateWrapper<LabSettleEntity> updatePsrmWrapper = Wrappers.lambdaUpdate();
				updatePsrmWrapper.eq(LabSettleEntity::getId, billId);
				updatePsrmWrapper.set(LabSettleEntity::getPsrmCode, null);
				updatePsrmWrapper.set(LabSettleEntity::getPsrmReturncode, null);
				updatePsrmWrapper.set(LabSettleEntity::getPsrmReturndata, null);
				service.update(updatePsrmWrapper);
			} else {
				return CommonResponse.error("数据中台操作失败：" + JSONObject.toJSONString(psrmResponse));
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		LabSettleEntity labSettleEntity = service.selectById(billId);
		if (psrmRestUtil.isRunMode() && StringUtils.isNotBlank(labSettleEntity.getPsrmReturncode())) {
			PSRMResponse psrmResponse = psrmRestUtil.disableOrDelObj(labSettleEntity.getPsrmCode(), "crm.purchaseinstock.del");
			logger.info("psrmResponse:{}", psrmResponse);
			if (psrmResponse.isSuccess()) {
				LambdaUpdateWrapper<ContractEntity> updateWrapper = Wrappers.lambdaUpdate();
				updateWrapper.eq(ContractEntity::getId, billId);
				updateWrapper.set(ContractEntity::getPsrmCode, null);
				updateWrapper.set(ContractEntity::getPsrmReturncode, null);
				updateWrapper.set(ContractEntity::getPsrmReturndata, null);
				contractService.update(updateWrapper);
			} else {
				return CommonResponse.error("数据中台操作失败：" + JSONObject.toJSONString(psrmResponse));
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		LabSettleEntity labSettleEntity = service.selectById(billId);
		ContractEntity contractEntity  = contractService.getById(labSettleEntity.getContractId());
		LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(ContractEntity::getSumSettleTaxMny, 0);
		updateWrapper.set(ContractEntity::getSumSettleMny, 0);
		contractService.update(contractEntity, updateWrapper, false);
		return CommonResponse.success();
	}

}
