package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.sub.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sub.mapper.LabSettleMapper;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.service.ILabSettleService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 劳务结算
 * 
 * @author generator
 * 
 */
@Service("labSettleService")
public class LabSettleServiceImpl extends BaseServiceImpl<LabSettleMapper, LabSettleEntity> implements ILabSettleService{

    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private PSRMRestUtil psrmRestUtil;

    @Override
    public JSONObject querySubSettleVOList(QueryParam param, boolean isEs) {
        Page<LabSettleVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<LabSettleVO> list = baseMapper.querySubSettleVOList(pages, wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> settleIds = list.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse<Map<Long, BigDecimal>> applyMnyHasFreeRes = payContractApi.getApplyMnyHasFree(settleIds);
            Map<Long, BigDecimal> settleApplyData = applyMnyHasFreeRes.getData();
            for (LabSettleVO subSettleVO : list) {
                BigDecimal sumApplyMnyHasFree = settleApplyData.get(subSettleVO.getId());
                subSettleVO.setSumApplyMny(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub(subSettleVO.getSettleTaxMny(), sumApplyMnyHasFree);
                subSettleVO.setSurplusApplyMny(surplusApplyMny);
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

    @Override
    public PSRMResponse saveOrUpdatePsrmObj(LabSettleVO vo) {
         /*     请求参数
f_synccode	string	单据编码（必录）
f_synccreator	string	创建人 （必录）
f_syncauditor	string	审核人 （必录）
f_status	string	单据状态 创建 S 审核 Y （必录）
f_date	datetime	业务日期（必录）
f_potype	string	采购类别（必录）
f_engineeringcode	string	工程项目编码
f_supplycode	string	供应商编码（必录）
f_postyle	string	采购方式 默认赊购：P002
f_contractcode	string	采购合同编号
f_explanation	string	摘要
f_smanagername	string	保管人名称（必录）
f_fmanagername	string	验收人名称（必录）
f_empname	string	业务员名称（必录）


*/
        String signDate = DateUtil.format(vo.getSettleDate(), DateUtil.DATE);
        JSONObject obj = new JSONObject();
        obj.put("f_synccode", vo.getBillCode());
        obj.put("f_status", "Y");
        obj.put("f_date", signDate);
        obj.put("f_potype", "05");
        try {
            if (vo.getSupplierId() != null) {
                JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getSupplierId()), "support-supplier");
                if (jArray != null && jArray.size() > 0) {
                    JSONObject json = (JSONObject) jArray.get(0);
                    obj.put("f_supplycode", json.getString("code"));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (vo.getProjectId() != null) {
            JSONArray jArray = null;
            try {
                jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getProjectId()), "market-project");
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject) jArray.get(0);
                obj.put("f_engineeringcode", json.getString("code"));
            }
        }
        obj.put("f_empname", vo.getEmployeeName());
        obj.put("f_synccreator", vo.getCreateUserName());
        UserContext userContext = sessionManager.getUserContext();
        obj.put("f_syncauditor", userContext.getUserName());
 /*
detail	array	明细
f_seq	int	行号（必录）
f_materialcode	string	物料编号（必录）
f_auxpropcode	string	辅助属性编码
f_batchno	string	批号
f_unit	string	单位
f_auxqtymust	decimal	应收数量
f_qty	decimal	实收数量（必录）
f_auxprice	decimal	单价
f_auxtaxprice	decimal	含税单价（必录）
f_amount	decimal	金额
f_cess	decimal	税率（%）
f_taxamount	decimal	税额
f_allamount	decimal	价税合计
f_note	string	备注
f_stockcode	string	收料仓库编码
f_chkpassitem	string	检验是否良品
f_projectnote	string	项目部备注
f_sourcebillno	string	K3WISE源单编号（采购订单单号）（必录）
f_sourceentryid	int	K3WISE源单行号（采购订单行号）（必录）
f_sourcetrantype	string	K3WISE源单类型 默认 采购订单（必录）
f_contractbillno	string	合同单号
f_contractentryid	string	合同分录

*/

        String contractCode = null;
        try {
            if (vo.getContractId() != null) {
                JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getContractId()), "sub-contract-register");
                if (jArray != null && jArray.size() > 0) {
                    JSONObject json = (JSONObject) jArray.get(0);
                    contractCode = json.getString("code");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        List<JSONObject> detail = new ArrayList<>();
        // 子表
        JSONObject subObj = new JSONObject();
        subObj.put("f_synentryid",vo.getId());
        subObj.put("f_materialcode", "99999995");
        subObj.put("f_qty", 1);
        subObj.put("f_auxtaxprice", vo.getSettleTaxMny());
        subObj.put("f_amount", vo.getSettleTaxMny());
        subObj.put("f_note", vo.getMemo());
        subObj.put("f_stockcode", obj.getString("f_engineeringcode"));

        subObj.put("f_sourcebillno", contractCode);
        subObj.put("f_contractsynId", vo.getContractId());
        subObj.put("f_sourcetrantype", "采购订单");
        subObj.put("f_contractbillno", contractCode);
        detail.add(subObj);
        obj.put("detail", detail);
        return psrmRestUtil.postReq(obj, getSaveMethodName());
    }

    @Override
    public String getSaveMethodName() {
        return "crm.purchaseinstock.add";
    }

    @Override
    public String getUpdateMethodName() {
        return null;
    }
}
