package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.RecordDetailEntity;
import com.ejianc.business.sub.bean.RecordEntity;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.mapper.RecordMapper;
import com.ejianc.business.sub.service.IRecordDetailService;
import com.ejianc.business.sub.service.IRecordService;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.ContractDetailVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 分包合同记录表 服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("RecordServiceImpl")
public class RecordServiceImpl extends BaseServiceImpl<RecordMapper, RecordEntity> implements IRecordService {

    @Autowired
    IRecordDetailService recordDetailService;

    @Override
    public ContractVO queryDetail(Long id, Boolean detailHasChildren) {
//        RecordEntity contractEntity = super.selectById(id);
        LambdaQueryWrapper<RecordEntity> lambda = Wrappers.<RecordEntity>lambdaQuery();
        lambda.eq(RecordEntity::getChangeId, id);
        RecordEntity contractEntity1 = super.getOne(lambda);
        RecordEntity contractEntity = super.selectById(contractEntity1.getId());
        ContractVO contractVO =  BeanMapper.map(contractEntity, ContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("recordId", new Parameter(QueryParam.EQ, contractEntity.getId()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<RecordDetailEntity> detailEntityListDb = recordDetailService.queryList(queryParam, false);
        List<RecordDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(RecordDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getContractDetailId().toString());
                cdEntity.setId(cdEntity.getContractDetailId());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<ContractDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ContractDetailVO.class);
            if(detailHasChildren){
                contractVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                contractVO.setDetailList(resultMapList);
            }
        }

        return contractVO;
    }
}
