/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.business.sub.vo.SubContractorContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contract/"})
public class ContractApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService service;
    @Autowired
    private ISettleService settleService;

    @GetMapping(value={"getById"})
    public CommonResponse<ContractVO> getRentContractById(@RequestParam(value="contractId") Long contractId) {
        ContractEntity ContractEntity2 = (ContractEntity)((Object)this.service.selectById(contractId));
        ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)ContractEntity2), ContractVO.class);
        return CommonResponse.success((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u6210\u529f", (Object)contractVO);
    }

    @GetMapping(value={"fetchSjzcje"})
    public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((Object)this.service.fetchSjzcje(projectId));
    }

    @PostMapping(value={"getContractByCondition"})
    @ResponseBody
    public CommonResponse<List<ContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds) {
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.in(ContractEntity::getEnquiryPriceBillId, enquiryPriceBillIds);
        lambdaUpdateWrapper.orderByDesc(ContractEntity::getSignDate);
        List list = this.service.list((Wrapper)lambdaUpdateWrapper);
        return CommonResponse.success((Object)BeanMapper.mapList((Iterable)list, ContractVO.class));
    }

    @GetMapping(value={"getSettleVO"})
    public CommonResponse<SettleVO> getSettleVO(@RequestParam(value="settleId") Long settleId) {
        return CommonResponse.success((Object)this.settleService.queryDetail(settleId, true));
    }

    @GetMapping(value={"getSubContractorContractVO"})
    public CommonResponse<SubContractorContractVO> getSubContractorContractVO(@RequestParam(value="supplierId") Long supplierId) {
        SubContractorContractVO imageVO = new SubContractorContractVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContractEntity::getSupplierId, (Object)supplierId);
        queryWrapper.in(ContractEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List contractList = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)contractList)) {
            imageVO.setSignNum(Integer.valueOf(contractList.size()));
            List projectList = contractList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
            imageVO.setProjectNum(Integer.valueOf(projectList.size()));
            BigDecimal signMny = contractList.stream().map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            imageVO.setSignMny(signMny);
            BigDecimal payedMny = contractList.stream().map(ContractEntity::getSumPayMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            imageVO.setPayedMny(payedMny);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)imageVO);
    }
}

