/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.mapper.LabSettleMapper;
import com.ejianc.business.sub.service.ILabSettleService;
import com.ejianc.business.sub.vo.LabSettleVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="labSettleService")
public class LabSettleServiceImpl
extends BaseServiceImpl<LabSettleMapper, LabSettleEntity>
implements ILabSettleService {
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private PSRMRestUtil psrmRestUtil;

    @Override
    public JSONObject querySubSettleVOList(QueryParam param, boolean isEs) {
        QueryWrapper wrapper;
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<LabSettleVO> list = ((LabSettleMapper)this.baseMapper).querySubSettleVOList(pages, wrapper = LabSettleServiceImpl.changeToQueryWrapper((QueryParam)param));
        if (CollectionUtils.isNotEmpty(list)) {
            List settleIds = list.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse applyMnyHasFreeRes = this.payContractApi.getApplyMnyHasFree(settleIds);
            Map settleApplyData = (Map)applyMnyHasFreeRes.getData();
            for (LabSettleVO subSettleVO : list) {
                BigDecimal sumApplyMnyHasFree = (BigDecimal)settleApplyData.get(subSettleVO.getId());
                subSettleVO.setSumApplyMny(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub((BigDecimal)subSettleVO.getSettleTaxMny(), (BigDecimal)sumApplyMnyHasFree);
                subSettleVO.setSurplusApplyMny(surplusApplyMny);
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    public PSRMResponse saveOrUpdatePsrmObj(LabSettleVO vo) {
        JSONObject json;
        JSONArray jArray;
        String signDate = DateUtil.format((Date)vo.getSettleDate(), (String)"yyyy-MM-dd");
        JSONObject obj = new JSONObject();
        obj.put("f_synccode", (Object)vo.getBillCode());
        obj.put("f_status", (Object)"Y");
        obj.put("f_date", (Object)signDate);
        obj.put("f_potype", (Object)"05");
        try {
            if (vo.getSupplierId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(vo.getSupplierId()), (String)"support-supplier")) != null && jArray.size() > 0) {
                json = (JSONObject)jArray.get(0);
                obj.put("f_supplycode", (Object)json.getString("code"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (vo.getProjectId() != null) {
            jArray = null;
            try {
                jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(vo.getProjectId()), (String)"market-project");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (jArray != null && jArray.size() > 0) {
                json = (JSONObject)jArray.get(0);
                obj.put("f_engineeringcode", (Object)json.getString("code"));
            }
        }
        obj.put("f_empname", (Object)vo.getEmployeeName());
        obj.put("f_synccreator", (Object)vo.getCreateUserName());
        UserContext userContext = this.sessionManager.getUserContext();
        obj.put("f_syncauditor", (Object)userContext.getUserName());
        String contractCode = null;
        try {
            JSONArray jArray2;
            if (vo.getContractId() != null && (jArray2 = ReferObjectUtil.getReferEntityValue((String)String.valueOf(vo.getContractId()), (String)"sub-contract-register")) != null && jArray2.size() > 0) {
                JSONObject json2 = (JSONObject)jArray2.get(0);
                contractCode = json2.getString("code");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<JSONObject> detail = new ArrayList<JSONObject>();
        JSONObject subObj = new JSONObject();
        subObj.put("f_synentryid", (Object)vo.getId());
        subObj.put("f_materialcode", (Object)"99999995");
        subObj.put("f_qty", (Object)1);
        subObj.put("f_auxtaxprice", (Object)vo.getSettleTaxMny());
        subObj.put("f_amount", (Object)vo.getSettleTaxMny());
        subObj.put("f_note", (Object)vo.getMemo());
        subObj.put("f_stockcode", (Object)obj.getString("f_engineeringcode"));
        subObj.put("f_sourcebillno", (Object)contractCode);
        subObj.put("f_contractsynId", (Object)vo.getContractId());
        subObj.put("f_sourcetrantype", (Object)"\u91c7\u8d2d\u8ba2\u5355");
        subObj.put("f_contractbillno", (Object)contractCode);
        detail.add(subObj);
        obj.put("detail", detail);
        return this.psrmRestUtil.postReq((Object)obj, this.getSaveMethodName());
    }

    public String getSaveMethodName() {
        return "crm.purchaseinstock.add";
    }

    public String getUpdateMethodName() {
        return null;
    }
}

