package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.sub.vo.CertificateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sub.mapper.CertificateMapper;
import com.ejianc.business.sub.bean.CertificateEntity;
import com.ejianc.business.sub.service.ICertificateService;

import java.util.Arrays;
import java.util.List;

/**
 * 分包签证单
 * 
 * @author generator
 * 
 */
@Service("certificateService")
public class CertificateServiceImpl extends BaseServiceImpl<CertificateMapper, CertificateEntity> implements ICertificateService{

    @Override
    public void settleFlag(List<Long> ids, Integer flag) {
        UpdateWrapper<CertificateEntity> wrapper = new UpdateWrapper();
        wrapper.in("id", ids);
        wrapper.set("settle_flag", flag);
        super.update(wrapper);
    }

    @Override
    public List<CertificateVO> getByCertificateId(Long certificateId) {
        QueryWrapper<CertificateEntity> wrapper = new QueryWrapper();
        wrapper.eq("certificate_id", certificateId);
        wrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc("create_time");
        List<CertificateEntity> list = super.list(wrapper);
        List<CertificateVO> certificateVOS = BeanMapper.mapList(list, CertificateVO.class);
        return certificateVOS;
    }
}
