/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractClauseEntity;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.ContractStageEntity;
import com.ejianc.business.sub.bean.RecordEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractClauseService;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IContractStageService;
import com.ejianc.business.sub.service.IRecordService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="change")
public class ChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractStageService contractStageService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private PSRMRestUtil psrmRestUtil;

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
        ContractEntity e = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        if (this.psrmRestUtil.isRunMode().booleanValue() && StringUtils.isNotBlank((CharSequence)e.getPsrmReturncode())) {
            PSRMResponse psrmResponse = this.psrmRestUtil.disableOrDelObj(e.getPsrmCode(), "dmp.purchaseorder.del");
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(BaseEntity::getId, (Object)e.getId());
            updateWrapper.set(ContractEntity::getPsrmReturncode, (Object)psrmResponse.getReturncode());
            updateWrapper.set(psrmResponse.isSuccess(), ContractEntity::getPsrmCode, null);
            updateWrapper.set(ContractEntity::getPsrmReturndata, (Object)JSONObject.toJSONString((Object)psrmResponse));
            this.contractService.update((Wrapper)updateWrapper);
            if (!psrmResponse.isSuccess()) {
                return CommonResponse.error((String)("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)psrmResponse)));
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List<ContractStageEntity> stageChangeList;
        List<ContractStageEntity> stageList;
        List<ContractClauseEntity> contractChangeClauseList;
        List<ContractClauseEntity> contractClauseList;
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
        ContractVO contractVO = this.contractService.queryDetail(changeEntity.getContractId(), false);
        HashMap contIdVersionMap = new HashMap();
        RecordEntity recordEntity = (RecordEntity)((Object)BeanMapper.map((Object)contractVO, RecordEntity.class));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getClauseList())) {
            recordEntity.getClauseList().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getStageList())) {
            recordEntity.getStageList().forEach(vo -> {
                vo.setContractStageId(vo.getId());
                vo.setId(null);
            });
        }
        ContractEntity contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setContractType(changeEntity.getContractType());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setTeamName(changeEntity.getTeamName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setTaxMny(changeEntity.getTaxMny());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setInvoiceType(changeEntity.getInvoiceType());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractEntity.setContractStatus(changeEntity.getContractStatus());
        contractEntity.setContractUndiscountMny(changeEntity.getContractUndiscountMny());
        contractEntity.setDiscountMny(changeEntity.getDiscountMny());
        contractEntity.setContractCategoryId(changeEntity.getContractCategoryId());
        contractEntity.setContractCategoryName(changeEntity.getContractCategoryName());
        contractEntity.setMajorId(changeEntity.getMajorId());
        contractEntity.setMajorName(changeEntity.getMajorName());
        contractEntity.setPricingModeId(changeEntity.getPricingModeId());
        contractEntity.setPricingModeName(changeEntity.getPricingModeName());
        contractEntity.setGuidePriceMny(changeEntity.getGuidePriceMny());
        contractEntity.setCompeteFactor(changeEntity.getCompeteFactor());
        contractEntity.setSignChannel(changeEntity.getSignChannel());
        if (this.psrmRestUtil.isRunMode().booleanValue()) {
            PSRMResponse resp = this.contractService.saveOrUpdatePsrmObj(BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
            if (!resp.isSuccess()) {
                LambdaUpdateWrapper psrmupdateWrapper = Wrappers.lambdaUpdate();
                psrmupdateWrapper.eq(BaseEntity::getId, (Object)contractEntity.getId());
                psrmupdateWrapper.set(ContractEntity::getPsrmReturncode, (Object)resp.getReturncode());
                psrmupdateWrapper.set(ContractEntity::getPsrmReturndata, (Object)JSONObject.toJSONString((Object)resp));
                this.contractService.update((Wrapper)psrmupdateWrapper);
                return CommonResponse.error((String)("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25" + JSONObject.toJSONString((Object)resp)));
            }
            contractEntity.setPsrmCode(resp.getPsrmCode());
            contractEntity.setPsrmReturncode(resp.getReturncode());
            contractEntity.setPsrmReturndata(JSONObject.toJSONString((Object)resp));
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getId());
        updateWrapper.set(ChangeEntity::getUsedTime, (Object)new Date());
        this.changeService.update((Object)changeEntity, (Wrapper)updateWrapper, false);
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        boolean b = this.contractService.updateById((Object)contractEntity);
        ContractEntity contractChangeEntity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), ContractEntity.class));
        List<ContractDetailEntity> contractDetailList = contractChangeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailList)) {
            contractDetailList.forEach(contractDetailEntity -> {
                contractDetailEntity.setTid(contractDetailEntity.getId().toString());
                contractDetailEntity.setTpid(contractDetailEntity.getParentId() != null && contractDetailEntity.getParentId() > 0L ? contractDetailEntity.getParentId().toString() : "");
                Long contractBid = contractDetailEntity.getSrcBid();
                contractDetailEntity.setContractId(changeEntity.getContractId());
                contractDetailEntity.setSrcBid(contractDetailEntity.getId());
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
            });
            this.contractDetailService.saveOrUpdateBatch(contractDetailList, contractDetailList.size(), false);
            HashMap idMap = new HashMap();
            contractDetailList.forEach(cdEntity -> idMap.put(cdEntity.getTid(), cdEntity.getId()));
            contractDetailList.forEach(cdEntity -> {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
            });
            this.contractDetailService.saveOrUpdateBatch(contractDetailList, contractDetailList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(contractClauseList = contractEntity.getClauseList())) {
            this.contractClauseService.removeByIds(contractClauseList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
        }
        if (CollectionUtils.isNotEmpty(contractChangeClauseList = contractChangeEntity.getClauseList())) {
            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setId(null);
                clauseEntity.setContractId(changeEntity.getContractId());
            });
            this.contractClauseService.saveOrUpdateBatch(contractChangeClauseList, contractChangeClauseList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(stageList = contractEntity.getStageList())) {
            this.contractStageService.removeByIds(stageList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
        }
        if (CollectionUtils.isNotEmpty(stageChangeList = contractChangeEntity.getStageList())) {
            stageChangeList.forEach(stageEntity -> {
                stageEntity.setId(null);
                stageEntity.setContractId(changeEntity.getContractId());
            });
            this.contractStageService.saveOrUpdateBatch(stageChangeList, stageChangeList.size(), false);
        }
        this.attachmentApi.copyFiles(String.valueOf(billId), "BT200610000000003", "subContractBill", String.valueOf(contractEntity.getId()), "BT200529000000001", "subContractBill", true);
        if (b) {
            this.contractService.countContractNumAndMnyByEnquiry(contractEntity.getEnquiryPriceBillId());
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5408\u540c\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }
}

