package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 分包变更表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_change")
public class ChangeEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 变更前合同名称
     */
    @TableField("before_contract_name")
    private String beforeContractName;

    /**
     * 分包类型
     */
    @TableField("contract_type")
    private Long contractType;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private String contractStatus;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 总包企业ID
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 总包企业名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 分包企业ID
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 分包企业名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 签约日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 变更日期
     */
    @TableField("change_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 初始版本金额（含税）
     */
    @TableField("base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 变更前金额（含税）
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    @TableField("pay_scale")
    private BigDecimal payScale;

    /**
     * 是否项目
     */
    @TableField("purchase_type")
    private String purchaseType;

    /**
     * 分包内容
     */
    @TableField("memo")
    private String memo;

    /**
     * 变更原因
     */
    @TableField("change_reason")
    private String changeReason;

    /**
     * 生效时间
     */
    @TableField("used_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date usedTime;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 变更明细集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="ChangeDetailServiceImpl",pidName = "changeId")
    private List<ChangeDetailEntity> detailList;

    /**
     * 变更条款集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="ChangeClauseServiceImpl",pidName = "changeId")
    private List<ChangeClauseEntity> clauseList;

    @TableField(exist=false)
    @SubEntity(serviceName="changeStageService",pidName = "changeId")
    private List<ChangeStageEntity> stageList; // 分包变更阶段实体

    @TableField("purchase_type_name")
    private String purchaseTypeName;

    @TableField("invoice_type")
    private Long invoiceType; // 发票类型

    @TableField("invoice_type_name")
    private String invoiceTypeName;


    /**
     *优惠前金额
     */
    @TableField("contract_undiscount_mny")
    private BigDecimal contractUndiscountMny;


    /**
     *优惠金额
     */
    @TableField("discount_mny")
    private BigDecimal discountMny;
    /**
     * 定标结果单id
     */
    @TableField(value = "enquiry_price_bill_id")
    private Long enquiryPriceBillId;

    /**
     * 定标结果单主题
     */
    @TableField(value = "enquiry_price_bill_name")
    private String enquiryPriceBillName;

    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别   自定义档案：sub-contract-category	分包合同类型
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value="major_id")
    private Long majorId; // 专业  自定义档案：sub-major	分包专业
    @TableField(value="major_name")
    private String majorName; // 专业名称
    @TableField(value="pricing_mode_id")
    private Long pricingModeId; // 计价方式 自定义档案：contract-valuation-type	合同计价方式
    @TableField(value="pricing_mode_name")
    private String pricingModeName; // 计价方式名称
    @TableField(value="guide_price_mny")
    private BigDecimal guidePriceMny; // 指导价金额(无税)
    @TableField(value="compete_factor")
    private BigDecimal competeFactor; // 竞聘系数

    /**
     * 合同文件id
     */
    @TableField(value = "contract_file_id")
    private String contractFileId;

    /**
     * 合同pdfid
     */
    @TableField(value = "contract_pdf_id")
    private Long contractPdfId;

    /**
     * 合同模板id
     */
    @TableField(value = "contract_template_id")
    private Long contractTemplateId;

    /**
     * 归档状态,1:已归档
     */
    @TableField(value = "file_state")
    private String fileState;

    /**
     * 起草方式online线上upload上传
     */
    @TableField(value = "draft_method")
    private String draftMethod;


    /**
     * 文档类型
     */
    @TableField(value = "doc_category_id")
    private Long docCategoryId;

    @TableField(value="sign_channel")
    private Long signChannel; // 合同签订渠道

    @TableField(value="team_name")
    private String teamName; // 班组名称


    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public Long getSignChannel() {
        return signChannel;
    }

    public void setSignChannel(Long signChannel) {
        this.signChannel = signChannel;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public String getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(String contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractPdfId() {
        return contractPdfId;
    }

    public void setContractPdfId(Long contractPdfId) {
        this.contractPdfId = contractPdfId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getFileState() {
        return fileState;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    public String getDraftMethod() {
        return draftMethod;
    }

    public void setDraftMethod(String draftMethod) {
        this.draftMethod = draftMethod;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public Long getMajorId() {
        return majorId;
    }

    public void setMajorId(Long majorId) {
        this.majorId = majorId;
    }

    public String getMajorName() {
        return majorName;
    }

    public void setMajorName(String majorName) {
        this.majorName = majorName;
    }

    public Long getPricingModeId() {
        return pricingModeId;
    }

    public void setPricingModeId(Long pricingModeId) {
        this.pricingModeId = pricingModeId;
    }

    public String getPricingModeName() {
        return pricingModeName;
    }

    public void setPricingModeName(String pricingModeName) {
        this.pricingModeName = pricingModeName;
    }

    public BigDecimal getGuidePriceMny() {
        return guidePriceMny;
    }

    public void setGuidePriceMny(BigDecimal guidePriceMny) {
        this.guidePriceMny = guidePriceMny;
    }

    public BigDecimal getCompeteFactor() {
        return competeFactor;
    }

    public void setCompeteFactor(BigDecimal competeFactor) {
        this.competeFactor = competeFactor;
    }

    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }

    public BigDecimal getContractUndiscountMny() {
        return contractUndiscountMny;
    }

    public void setContractUndiscountMny(BigDecimal contractUndiscountMny) {
        this.contractUndiscountMny = contractUndiscountMny;
    }

    public BigDecimal getDiscountMny() {
        return discountMny;
    }

    public void setDiscountMny(BigDecimal discountMny) {
        this.discountMny = discountMny;
    }

    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }


    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public List<ChangeDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ChangeDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<ChangeClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ChangeClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public List<ChangeStageEntity> getStageList() {
        return stageList;
    }

    public void setStageList(List<ChangeStageEntity> stageList) {
        this.stageList = stageList;
    }
}
