package com.ejianc.business.sub.controller;

import com.ejianc.business.sub.service.IContractService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.Map;

/**
 * @description: SubStatisticController
 * @author songlx
 * @date 2024/11/11
 * @version 1.0
 */
@Controller
@RequestMapping("subStatistic")
public class SubStatisticController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IContractService contractService;

    /**
     * @Description 本年合同数量、本年结算数量
     */
    @RequestMapping(value = "/contractSettleCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> contractSettleCount() {
        return CommonResponse.success("查询本年合同数量、本年结算数量！", contractService.contractSettleCount());
    }


    /**
     * @Description 金额统计
     */
    @RequestMapping(value = "/moneySum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> moneySum() {
        return CommonResponse.success("查询金额（万元）统计！", contractService.moneySum());
    }



}
