package com.ejianc.business.sub.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.vo.FinishOddjobVO;
import com.ejianc.business.sub.vo.OddjobRecordVO;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.business.sub.vo.SettleOddjobVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 分包零星用工表 服务类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public interface IOddjobService extends IBaseService<OddjobEntity> {

    OddjobVO insertOrUpdate(OddjobVO oddjobVO);

    OddjobVO queryDetail(Long id);

    CommonResponse<IPage<OddjobVO>> queryListVOs(QueryParam param);

    CommonResponse<String> deleteByIds(List<OddjobVO> vos);

    OddjobVO queryDetailAdd(Long contractId);

    OddjobRecordVO queryDetailRecord(Long id);

    void updateSettleByPks(List<Long> pks, Boolean flag);
    void updateSettleMnyByPks(List<SettleOddjobVO> list, Boolean flag);
    void updateSettleMny(List<FinishOddjobVO> list, Boolean flag);

    void excelExport(QueryParam param, HttpServletResponse response);

    OddjobVO querySumOddjobMny(Long contractId);

    OddjobVO queryCheckParamSumOddjobMny(Long contractId,Long id);

    ParamsCheckVO checkAllParams(OddjobVO vo);
}
