/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ILabSettleService;
import com.ejianc.business.sub.vo.LabSettleVO;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="labSettle")
public class LabSettleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PSRMRestUtil psrmRestUtil;
    @Autowired
    private ILabSettleService service;
    @Autowired
    private IContractService contractService;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        LabSettleEntity labSettleEntity = (LabSettleEntity)((Object)this.service.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(labSettleEntity.getContractId()));
        BigDecimal settleTaxMny = labSettleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : labSettleEntity.getSettleTaxMny();
        BigDecimal settleMny = labSettleEntity.getSettleMny() == null ? BigDecimal.ZERO : labSettleEntity.getSettleMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, (Object)settleTaxMny);
        updateWrapper.set(ContractEntity::getSumSettleMny, (Object)settleMny);
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        if (this.psrmRestUtil.isRunMode().booleanValue()) {
            if (StringUtils.isNotBlank((CharSequence)contractEntity.getPsrmCode())) {
                PSRMResponse resp = this.service.saveOrUpdatePsrmObj(BeanMapper.map((Object)((Object)labSettleEntity), LabSettleVO.class));
                LambdaUpdateWrapper updatepsrmWrapper = Wrappers.lambdaUpdate();
                updatepsrmWrapper.eq(BaseEntity::getId, (Object)billId);
                updatepsrmWrapper.set(LabSettleEntity::getPsrmCode, (Object)resp.getPsrmCode());
                updatepsrmWrapper.set(LabSettleEntity::getPsrmReturncode, (Object)resp.getReturncode());
                updatepsrmWrapper.set(LabSettleEntity::getPsrmReturndata, (Object)JSONObject.toJSONString((Object)resp));
                this.service.update((Wrapper)updatepsrmWrapper);
                if (!resp.isSuccess()) {
                    return CommonResponse.error((String)("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25" + JSONObject.toJSONString((Object)resp)));
                }
            } else {
                this.logger.info("\u5408\u540c{}\u672a\u63a8\u9001\u4e2d\u53f0\uff0c{}\u65e0\u9700\u63a8\u9001------", (Object)contractEntity.getBillCode(), (Object)labSettleEntity.getBillCode());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LabSettleEntity labSettleEntity = (LabSettleEntity)((Object)this.service.selectById(billId));
        if (this.psrmRestUtil.isRunMode().booleanValue() && StringUtils.isNotBlank((CharSequence)labSettleEntity.getPsrmReturncode())) {
            PSRMResponse resp = this.psrmRestUtil.disableOrDelObj(labSettleEntity.getPsrmCode(), "crm.purchaseinstock.del");
            this.logger.info("{} psrmResponse:{}", (Object)this.getClass().getName(), (Object)resp);
            LambdaUpdateWrapper updatepsrmWrapper = Wrappers.lambdaUpdate();
            updatepsrmWrapper.eq(BaseEntity::getId, (Object)billId);
            updatepsrmWrapper.set(LabSettleEntity::getPsrmReturncode, (Object)resp.getReturncode());
            updatepsrmWrapper.set(resp.isSuccess(), LabSettleEntity::getPsrmCode, null);
            updatepsrmWrapper.set(LabSettleEntity::getPsrmReturndata, (Object)JSONObject.toJSONString((Object)resp));
            this.service.update((Wrapper)updatepsrmWrapper);
            if (!resp.isSuccess()) {
                return CommonResponse.error((String)("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)resp)));
            }
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(labSettleEntity.getContractId()));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, (Object)0);
        updateWrapper.set(ContractEntity::getSumSettleMny, (Object)0);
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        return CommonResponse.success();
    }
}

