package com.ejianc.business.sub.controller.api;

import com.ejianc.business.sub.service.ICertificateService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.vo.CertificateVO;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/api/certificate")
public class CertificateApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICertificateService service;

    @RequestMapping(value = "/getByCertificateId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CertificateVO>> getByCertificateId(@RequestParam(value = "certificateId") Long certificateId) {
        return CommonResponse.success("查询数据成功！", service.getByCertificateId(certificateId));
    }


}
