/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.SettleDetailEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.mapper.SettleMapper;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleDetailService;
import com.ejianc.business.sub.service.ISettleOddjobService;
import com.ejianc.business.sub.service.ISettleOtherService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.ContractDetailVO;
import com.ejianc.business.sub.vo.SettleDetailVO;
import com.ejianc.business.sub.vo.SettleOddjobVO;
import com.ejianc.business.sub.vo.SettleRecordDetailVO;
import com.ejianc.business.sub.vo.SettleRecordVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="SettleServiceImpl")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    private static final String SUB_SETTLE_BILL_CODE = "SUB_SETTLE";
    private static final String SUB_SETTLE = "SUB_SETTLE";
    private static final String SUB_SETTLE_DETAIL = "SUB_SETTLE_DETAIL";
    private static final String SUB_SETTLE_ODDJOB = "SUB_SETTLE_ODDJOB";
    private static final String SUB_SETTLE_OTHER = "SUB_SETTLE_OTHER";
    private static final String CHECK_PARAM_CODE = "P-A9232233";
    private static final String CHECK_PARAM_CODE_NUM = "P-2IJ8Cs27";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISettleDetailService settleDetailService;
    @Autowired
    private ISettleOddjobService settleOddjobService;
    @Autowired
    private ISettleOtherService settleOtherService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInvoiceApi invoiceApi;
    private static final String PREPAY_PARAM = "P-zu6b9071";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettleVO insertOrUpdate(SettleVO settleVO) {
        BigDecimal syMny;
        block25: {
            if (this.checkFinishContract(settleVO).booleanValue()) {
                throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
            }
            if (settleVO.getContractVersion() != null && settleVO.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(settleVO.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (!version.equals(conVersion = settleVO.getContractVersion())) {
                            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        }
                        break block25;
                    }
                    throw new BusinessException("\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(settleVO.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.checkSameContract(settleVO).booleanValue()) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97\u5355");
        }
        if (StringUtils.isEmpty((CharSequence)settleVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("SUB_SETTLE", InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                settleVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (this.checkSameBillCode(settleVO).booleanValue()) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        settleVO.setRelationFlag("0");
        settleVO.setProportionFlag("0");
        SettleEntity settleEntity = (SettleEntity)((Object)BeanMapper.map((Object)settleVO, SettleEntity.class));
        List<SettleDetailEntity> beforeDetails = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == settleEntity.getId()) {
            for (SettleDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(SettleEntity::getContractId, (Object)settleVO.getContractId());
        lambdachange2.eq(SettleEntity::getOrgId, (Object)settleVO.getOrgId());
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambdachange2.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        lambdachange2.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdachange2.gt(SettleEntity::getSettleDate, (Object)settleVO.getSettleDate());
        int num2 = super.count((Wrapper)lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u5bf9\u5e94\u6700\u65b0\u7ed3\u7b97\u65e5\u671f!");
        }
        BigDecimal settlementTaxMny = settleVO.getSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSettleTaxMny();
        BigDecimal offsetMny = settleVO.getOffsetMny() == null ? BigDecimal.ZERO : settleVO.getOffsetMny();
        BigDecimal bigDecimal = syMny = settleVO.getSymny() == null ? BigDecimal.ZERO : settleVO.getSymny();
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u53ef\u51b2\u62b5\u91d1\u989d!");
        }
        if (settlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && offsetMny.compareTo(settlementTaxMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u672c\u671f\u7ed3\u7b97\u91d1\u989d");
        }
        CommonResponse invoiceReceiceMnyRes = this.invoiceApi.getInvoiceReceiceMny(settleEntity.getContractId(), settleEntity.getOrgId());
        if (invoiceReceiceMnyRes.isSuccess()) {
            settleEntity.setSumInvoiceTaxMny(ComputeUtil.nullToZero((BigDecimal)((BigDecimal)invoiceReceiceMnyRes.getData())));
        }
        super.saveOrUpdate((Object)settleEntity, false);
        List<SettleDetailEntity> settleDetailEntities = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(settleDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SettleDetailEntity cdEntity : settleDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SettleDetailEntity cdEntity : settleDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.settleDetailService.saveOrUpdateBatch(settleDetailEntities, settleDetailEntities.size(), false);
        }
        return this.queryDetail(settleEntity.getId(), true);
    }

    private Boolean checkSameBillCode(SettleVO settleVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getBillCode, (Object)settleVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkSameContract(SettleVO settleVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)settleVO.getContractId());
        lambda.eq(SettleEntity::getOrgId, (Object)settleVO.getOrgId());
        lambda.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public SettleVO queryDetail(Long id, Boolean detailHasChildren) {
        CommonResponse SumPayMnyVO2;
        BigDecimal settleTaxMny;
        SettleEntity settleEntity = (SettleEntity)((Object)super.selectById((Serializable)id));
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class);
        List settleOddjobList = settleVO.getSettleOddjobList();
        if (settleOddjobList != null && settleOddjobList.size() > 0) {
            for (SettleOddjobVO settleOddjobVO : settleOddjobList) {
                settleOddjobVO.setRowState("edit");
            }
            settleVO.setSettleOddjobList(settleOddjobList);
        }
        BigDecimal c = settleVO.getContractTaxMny() == null ? BigDecimal.ZERO : settleVO.getContractTaxMny();
        settleVO.setContractTaxMny(c);
        BigDecimal cc = settleVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSumSettleTaxMny();
        settleVO.setSumSettleTaxMny(cc);
        if (c.compareTo(BigDecimal.ZERO) != 0 && cc.compareTo(BigDecimal.ZERO) != 0) {
            settleVO.setSumSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(cc, c)));
        }
        BigDecimal bigDecimal = settleTaxMny = settleVO.getSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) != 0 && settleTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            settleVO.setSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(settleTaxMny, c)));
        }
        BigDecimal sumPrePayMny = settleEntity.getSumPrepayMny() == null ? BigDecimal.ZERO : settleEntity.getSumPrepayMny();
        BigDecimal sumOffsetMny = settleEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getSumOffsetMny();
        settleVO.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.settleDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (SettleDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, SettleDetailVO.class);
            if (detailHasChildren.booleanValue()) {
                settleVO.setSettleDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                settleVO.setSettleDetailList(resultMapList);
            }
        }
        if (!(SumPayMnyVO2 = this.payContractApi.getSumPayMny(settleVO.getContractId(), settleVO.getOrgId())).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5df2\u4ed8\u91d1\u989d\u5931\u8d25");
        }
        settleVO.setSumTotalPay(((SumPayMnyVO)SumPayMnyVO2.getData()).getSumPayMny());
        settleVO.setSumPayMnyScale(ComputeUtil.safeDiv((BigDecimal)settleVO.getSumTotalPay(), (BigDecimal)settleVO.getContractTaxMny()));
        return settleVO;
    }

    @Override
    public CommonResponse<IPage<SettleVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage page = this.queryPage(param, false);
        List settleVOList = BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class);
        Page settleVOIPage = new Page();
        settleVOIPage.setCurrent(page.getCurrent());
        settleVOIPage.setRecords(settleVOList);
        settleVOIPage.setSize(page.getSize());
        settleVOIPage.setTotal(page.getTotal());
        settleVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)settleVOIPage);
    }

    @Override
    public CommonResponse<String> deleteByIds(List<SettleVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        SettleRecordVO settleRecordVO = new SettleRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        settleRecordVO.setContractId(id);
        settleRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        settleRecordVO.setContractStatus(Integer.valueOf(contractEntity.getContractStatus()));
        settleRecordVO.setContractTaxMny(contractTaxMny);
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SettleEntity::getContractId, (Object)id);
        lambda.in(SettleEntity::getOrgId, commonOrgIds);
        List entitiesAllState = super.list((Wrapper)lambda);
        lambda.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List settleRecordDetailVOList = BeanMapper.mapList((Iterable)entities, SettleRecordDetailVO.class);
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4)};
            settleRecordDetailVOList.forEach(entity -> {
                settlementMoney[0] = settlementMoney[0].add(entity.getSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSettleTaxMny());
                BigDecimal dSumSettleTaxMny = entity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSumSettleTaxMny();
                BigDecimal scale = BigDecimalUtils.safeDiv(dSumSettleTaxMny, contractTaxMny).multiply(new BigDecimal(100));
                entity.setSumScale(scale);
            });
            settleRecordVO.setSumSettleTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = settleRecordVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleRecordVO.getSumSettleTaxMny();
            settleRecordVO.setSumScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(sumSettlementTaxMny, contractTaxMny)));
        }
        settleRecordVO.setDetailList(BeanMapper.mapList((Iterable)entitiesAllState, SettleRecordDetailVO.class));
        return settleRecordVO;
    }

    @Override
    public SettleVO queryDetailAdd(Long contractId) {
        BigDecimal cc;
        BigDecimal sumOffsetMnys;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)contractEntity), SettleVO.class);
        settleVO.setBillCode(null);
        settleVO.setEmployeeId(null);
        settleVO.setEmployeeName(null);
        settleVO.setContractId(contractEntity.getId());
        settleVO.setBillState(null);
        settleVO.setCreateUserCode(null);
        settleVO.setCreateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setId(null);
        settleVO.setVersion(null);
        settleVO.setTaxMny(null);
        settleVO.setSumInvoiceTaxMny(null);
        CommonResponse sumPayMnyVO = this.payContractApi.getSumPayMny(contractId, contractEntity.getOrgId());
        if (!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPayMny();
        BigDecimal sumPrePayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPrePayMny();
        settleVO.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        settleVO.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(SettleEntity::getContractId, (Object)contractId);
        lambdachange.eq(SettleEntity::getOrgId, (Object)contractEntity.getOrgId());
        lambdachange.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettleTaxMny() == null ? BigDecimal.ZERO : e.getSettleTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            settleVO.setSumSettleTaxMny(settlementMoney[0]);
            settleVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal bigDecimal = sumOffsetMnys = settleVO.getSumOffsetMny() == null ? BigDecimal.ZERO : settleVO.getSumOffsetMny();
        if (settleVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            settleVO.setSymny(settleVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        BigDecimal c = settleVO.getContractTaxMny() == null ? BigDecimal.ZERO : settleVO.getContractTaxMny();
        BigDecimal bigDecimal2 = cc = settleVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSumSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            settleVO.setSumSettleScale(new BigDecimal(100).multiply(BigDecimalUtils.safeDiv(cc, c)));
        }
        return settleVO;
    }

    @Override
    public JSONObject querySubSettleVOList(QueryParam param, boolean isEs) {
        QueryWrapper wrapper;
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<SubSettleVO> list = ((SettleMapper)this.baseMapper).querySubSettleVOList(pages, wrapper = SettleServiceImpl.changeToQueryWrapper((QueryParam)param));
        if (CollectionUtils.isNotEmpty(list)) {
            List settleIds = list.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse applyMnyHasFreeRes = this.payContractApi.getApplyMnyHasFree(settleIds);
            Map settleApplyData = (Map)applyMnyHasFreeRes.getData();
            for (SubSettleVO subSettleVO : list) {
                BigDecimal sumApplyMnyHasFree = (BigDecimal)settleApplyData.get(subSettleVO.getId());
                subSettleVO.setSumApplyMny(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub((BigDecimal)subSettleVO.getSettleTaxMny(), (BigDecimal[])new BigDecimal[]{subSettleVO.getOffsetMny(), sumApplyMnyHasFree});
                subSettleVO.setSurplusApplyMny(surplusApplyMny);
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public SettleVO getSumSettleNumInfo(SettleVO settleVO) {
        List settleDetailList = settleVO.getSettleDetailList();
        if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
            List cids = settleDetailList.stream().map(SettleDetailVO::getContractDetailId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("contractDetailId", new Parameter("in", cids));
            QueryWrapper wrapper = SettleServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<SettleDetailVO> list = ((SettleMapper)this.baseMapper).getSumSettleNumInfo(wrapper);
            Map<Long, SettleDetailVO> voMap = list.stream().collect(Collectors.toMap(SettleDetailVO::getContractDetailId, a -> a, (k1, k2) -> k1));
            if (voMap != null && voMap.size() > 0) {
                settleDetailList.forEach(t -> {
                    if (t.getLeafFlag().booleanValue()) {
                        Long contractDetailId = t.getContractDetailId();
                        SettleDetailVO settleDetailVO = (SettleDetailVO)voMap.get(contractDetailId);
                        t.setSumSettleNum(settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                        t.setSumSettleNumEndthis(settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                    }
                });
            }
        }
        return settleVO;
    }

    @Override
    public List<ContractDetailVO> getSumSettleNum(List<ContractDetailVO> contractDetailVOS) {
        if (CollectionUtils.isNotEmpty(contractDetailVOS)) {
            List cids = contractDetailVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("contractDetailId", new Parameter("in", cids));
            QueryWrapper wrapper = SettleServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<SettleDetailVO> list = ((SettleMapper)this.baseMapper).getSumSettleNumInfo(wrapper);
            Map<Long, SettleDetailVO> voMap = list.stream().collect(Collectors.toMap(SettleDetailVO::getContractDetailId, a -> a, (k1, k2) -> k1));
            if (voMap != null && voMap.size() > 0) {
                contractDetailVOS.forEach(t -> {
                    if (t.getLeafFlag().booleanValue()) {
                        Long contractDetailId = t.getId();
                        SettleDetailVO settleDetailVO = (SettleDetailVO)voMap.get(contractDetailId);
                        t.setSumSettleNum(settleDetailVO != null && settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                        t.setSumSettleNumEndthis(settleDetailVO != null && settleDetailVO.getSumSettleNum() != null ? settleDetailVO.getSumSettleNum() : BigDecimal.ZERO);
                    }
                });
            }
        }
        return contractDetailVOS;
    }

    private Boolean checkFinishContract(SettleVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)finishVO.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(ContractEntity::getFinishFlag, (Object)true);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public JSONObject querySettleDetailHistory(SettleDetailVO settleDetailVO) {
        QueryParam queryParam = new QueryParam();
        BigDecimal sumSettleNumEndthis = new BigDecimal(0);
        if (StringUtils.isNotBlank((CharSequence)settleDetailVO.getCode()) && StringUtils.isNotBlank((CharSequence)settleDetailVO.getName())) {
            settleDetailVO.setSourceType(Integer.valueOf(2));
            List<SettleDetailVO> settleDetailList = ((SettleMapper)this.baseMapper).querySettleDetailHistory(settleDetailVO);
            if (CollectionUtils.isNotEmpty(settleDetailList)) {
                for (SettleDetailVO settleDetailVO1 : settleDetailList) {
                    sumSettleNumEndthis = BigDecimalUtils.safeAdd(sumSettleNumEndthis, settleDetailVO1.getSettleNum());
                }
            }
        }
        JSONObject jo = new JSONObject();
        jo.put("sumSettleNumEndthis", (Object)sumSettleNumEndthis);
        System.out.print(sumSettleNumEndthis.toString());
        return jo;
    }

    @Override
    public void updateSettleDetailHistory() {
        SettleDetailVO settleDetailVO = new SettleDetailVO();
        List<SettleDetailVO> settleDetailList = ((SettleMapper)this.baseMapper).querySettleDetailList(settleDetailVO);
        for (SettleDetailVO sd : settleDetailList) {
            SettleDetailVO sd_tmp = new SettleDetailVO();
            sd_tmp.setContractDetailId(sd.getContractDetailId());
            sd_tmp.setCreateTime(sd.getSettleCreateTime());
            String settleNumSum = ((SettleMapper)this.baseMapper).querySettleDetailSum(sd_tmp);
            if (StringUtils.isEmpty((CharSequence)settleNumSum)) {
                settleNumSum = "0";
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(SettleDetailEntity::getSumSettleNumEndthis, (Object)BigDecimalUtils.safeAdd(new BigDecimal(settleNumSum), sd.getSettleNum()));
            updateWrapper.set(SettleDetailEntity::getSumSettleNum, (Object)settleNumSum);
            updateWrapper.eq(BaseEntity::getId, (Object)sd.getId());
            boolean update = this.settleDetailService.update((Wrapper)updateWrapper);
            System.out.println("update:id=" + sd.getId() + ",settleNumSumEndthis=" + BigDecimalUtils.safeAdd(new BigDecimal(settleNumSum), sd.getSettleNum()) + ",settleNumSum=" + settleNumSum);
        }
    }

    @Override
    public SettleVO queryProjectAndLaborMny(Long projectId, String settleDate) {
        SettleVO settleVO = new SettleVO();
        BigDecimal total = BigDecimal.ZERO;
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        stateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        stateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getProjectId, (Object)projectId);
        queryWrapper.in(SettleEntity::getBillState, stateList);
        List settleEntities = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleEntities)) {
            for (SettleEntity settleEntity : settleEntities) {
                total = BigDecimalUtils.safeAdd(total, settleEntity.getSettleTaxMny());
            }
        }
        settleVO.setProjectSumMny(total);
        return settleVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<SettleDetailVO> detailVoList = new ArrayList<SettleDetailVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SettleDetailVO vo = new SettleDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setTreeIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                vo.setCode((String)datas.get(1));
                vo.setName((String)datas.get(2));
                vo.setSpec((String)datas.get(3));
                vo.setUnit((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setSettleNum(null);
                    warnType = warnType + "\u672c\u671f\u7ed3\u7b97\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setSettleNum(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setSettleNum(null);
                        warnType = warnType + "\u672c\u671f\u7ed3\u7b97\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                try {
                    vo.setPrice(new BigDecimal((String)datas.get(6)));
                }
                catch (Exception e) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                    flag = true;
                }
                if (!flag) {
                    vo.setSettleMny(ComputeUtil.safeMultiply((BigDecimal)vo.getSettleNum(), (BigDecimal)vo.getPrice()));
                }
                vo.setMemo((String)datas.get(7));
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setSourceType(Integer.valueOf(2));
                detailVoList.add(vo);
            }
            for (SettleDetailVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

