package com.ejianc.business.sub.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.ParamUtil;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleRecordVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包过程结算表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("settle")
public class SettleController implements Serializable {

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IContractService contractService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @param settleVO
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO settleVO) {
        SettleVO vo = settleService.insertOrUpdate(settleVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询变更记录详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleVO vo = settleService.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<SettleEntity> pageData= settleService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), SettleVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        return   settleService.deleteByIds(vos);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailRecord 查询记录
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleRecordVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleRecordVO> queryDetailRecord(Long id) {
        SettleRecordVO vo = settleService.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增查询合同转化为过程结算
     * @param contractId
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/queryDetailAdd", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetailAdd(Long contractId) {
        SettleVO vo = settleService.queryDetailAdd(contractId);
        return CommonResponse.success("新增查询合同转化为过程结算成功！",vo);
    }
    /**
     * 根据主键ID,orgId查询累计结算金额，累计冲抵金额,累计付款，累计预付款金额
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/querySumSettlementTaxMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> querySumSettlementTaxMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        SettleVO vo = new SettleVO();
        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(contractId,orgId);
        if(!sumPayMnyVO.isSuccess()) {
            return CommonResponse.success("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        vo.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        LambdaQueryWrapper<SettleEntity> lambdachange = Wrappers.<SettleEntity>lambdaQuery();
        lambdachange.eq(SettleEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(SettleEntity::getContractId,contractId);
        lambdachange.eq(SettleEntity::getOrgId,orgId);
        lambdachange.in(SettleEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettleEntity> list = settleService.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] alreadySettleMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                alreadySettleMoney[0] = alreadySettleMoney[0].add(e.getSettleTaxMny()==null? BigDecimal.ZERO:e.getSettleTaxMny());
                alreadySettleMoney[1] = alreadySettleMoney[1].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
            });
            //累计结算金额
            vo.setSumSettleTaxMny(alreadySettleMoney[0]);
            //累计冲抵金额
            vo.setSumOffsetMny(alreadySettleMoney[1]);
        }
        BigDecimal sumOffsetMnys = vo.getSumOffsetMny()==null?BigDecimal.ZERO:vo.getSumOffsetMny();
        if(vo.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        ContractVO contractVO = contractService.queryDetail(contractId, true);
        vo.setStageList(contractVO.getStageList());
        return CommonResponse.success(vo);
    }

    /**
     * @Author yqls
     * @Date 2020/7/9 分包结算参照
     * @Description purchaseSettlementRef
     * @Param [pageNumber, pageSize, condition, searchText]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.material.vo.PurchaseSettlementVO>>
     */
    @RequestMapping(value = "/subSettlementRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> subSettlementRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null == conditionMap.get("type") || !"settleReport".equals(conditionMap.get("type"))) {
                /** 剩余可申请金额不等于0  */
                ComplexParam c4 = ParamUtil.getOrParam("surplusApplyMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
                queryParam.getComplexParams().add(c4);
            }
        }

//        ComplexParam c5 = ParamUtil.getOrParam("shouldPayTaxMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
//        queryParam.getComplexParams().add(c5);
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        if(StringUtils.isNotBlank(condition)){
            JSONObject con = JSONObject.parseObject(condition);
            if(condition.contains("contractId")){
                queryParam.getParams().put("contractId",new Parameter(QueryParam.EQ,con.getLong("contractId")));
            }
            if(condition.contains("orgId")){
                queryParam.getParams().put("orgId",new Parameter(QueryParam.EQ,con.getLong("orgId")));
            }
            if(condition.contains("supplierId")){
                queryParam.getParams().put("supplierId",new Parameter(QueryParam.EQ,con.getLong("supplierId")));
            }
        }
        JSONObject page = settleService.querySubSettleVOList(queryParam,false);
        return CommonResponse.success("参照查询成功！", page);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<SettleEntity> pageData= settleService.queryPage(param,false);
        List<SettleVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), SettleVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    /**
     * @Author zhangwx
     * @Date 2020/12/24
     * @Description pushCost关联保存
     * @param settleVO
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO settleVO) {
        return settleService.pushCost(settleVO);
    }

    /*
     *
     * @description: 参数校验
     * @author: 曹鹏辉
     * @date: 2021/5/19 15:51
     * @param: purchaseType 采购类型
     * @param: contractTaxMny 分包合同金额
     * @param: sumSettleMentTaxMny 累计含本期结算金额 (合同已生效的结算金额+当前结算单金额)
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.ParamsCheckVO>
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType
            , @RequestParam(value = "sumSettleMentTaxMny") BigDecimal sumSettleMentTaxMny
            , @RequestParam(value = "contractTaxMny") BigDecimal contractTaxMny) {

        return CommonResponse.success("参数校验成功！", settleService.checkParams(purchaseType, sumSettleMentTaxMny, contractTaxMny));
    }

}
