package com.ejianc.business.sub.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.vo.SettleDetailResultVO;
import com.ejianc.business.sub.vo.SettleRecordVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 分包过程结算表 服务类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public interface ISettleService extends IBaseService<SettleEntity> {

    SettleVO insertOrUpdate(SettleVO settleVO);

    SettleVO queryDetail(Long id, Boolean detailHasChildren);

    CommonResponse<IPage<SettleVO>> queryListVOs(QueryParam param);

    CommonResponse<String> deleteByIds(List<SettleVO> vos);

    SettleRecordVO queryDetailRecord(Long id);

    SettleVO queryDetailAdd(Long contractId);

    JSONObject querySubSettleVOList(QueryParam param, boolean isEs);

    CommonResponse<SettleVO> pushCost(SettleVO settleVO);

    void costPush(SettleEntity settleEntity);

    void pullCost(Long id);

    ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny);

    List<SettleDetailResultVO> querySettleDetail(Long contractId);
}
