package com.ejianc.business.sub.service.impl;

import com.ejianc.business.sub.bean.*;
import com.ejianc.business.sub.service.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("supplement")
public class SupplementBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISupplementService supplementService;

	@Autowired
	private IContractService contractService;

	@Autowired
	private IContractDetailService contractDetailService;

	@Autowired
	private IContractClauseService contractClauseService;

	@Autowired
	private IContractStageService contractStageService;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SupplementEntity supplementEntity = supplementService.selectById(billId);
		ContractEntity contractEntity  = contractService.selectById(supplementEntity.getMainContractId());
		contractEntity.setContractMny(contractEntity.getContractMny().add(supplementEntity.getContractMny()));
		contractEntity.setContractTaxMny(contractEntity.getContractTaxMny().add(supplementEntity.getContractTaxMny()));
		contractEntity.setTaxMny(contractEntity.getContractTaxMny().subtract(contractEntity.getContractMny()));
		contractService.updateById(contractEntity);

		dealDetailData(supplementEntity, contractEntity);

//		dealClauseData(supplementEntity, contractEntity);

//		dealStageData(supplementEntity, contractEntity);

		return CommonResponse.success();
	}

	private void dealStageData(SupplementEntity supplementEntity, ContractEntity contractEntity) {
		List<ContractStageEntity> stageList = contractEntity.getStageList();
		if(CollectionUtils.isNotEmpty(supplementEntity.getStageList())){
			for(SupplementStageEntity stageEntity : supplementEntity.getStageList()){
				ContractStageEntity contractStageEntity = BeanMapper.map(stageEntity, ContractStageEntity.class);
				contractStageEntity.setContractId(contractEntity.getId());
				contractStageEntity.setId(null);
				contractStageEntity.setSrcSupplementDetailId(stageEntity.getId());
				contractStageEntity.setSrcSupplementFlag(1);
				contractStageEntity.setSrcSupplementId(supplementEntity.getId());
				stageList.add(contractStageEntity);
			}
			contractStageService.saveOrUpdateBatch(stageList, stageList.size(), false);
		}
	}

	private void dealClauseData(SupplementEntity supplementEntity, ContractEntity contractEntity) {
		List<ContractClauseEntity> clauseList = contractEntity.getClauseList();
		if(CollectionUtils.isNotEmpty(supplementEntity.getClauseList())){
			for(SupplementClauseEntity clauseEntity : supplementEntity.getClauseList()){
				ContractClauseEntity contractClauseEntity = BeanMapper.map(clauseEntity, ContractClauseEntity.class);
				contractClauseEntity.setContractId(contractEntity.getId());
				contractClauseEntity.setId(null);
				contractClauseEntity.setSrcSupplementDetailId(clauseEntity.getId());
				contractClauseEntity.setSrcSupplementFlag(1);
				contractClauseEntity.setSrcSupplementId(supplementEntity.getId());
				clauseList.add(contractClauseEntity);
			}
			contractClauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
		}
	}

	private void dealDetailData(SupplementEntity supplementEntity, ContractEntity contractEntity){
		List<ContractDetailEntity> detailList = contractEntity.getDetailList();
		if(CollectionUtils.isNotEmpty(supplementEntity.getDetailList())){
			for(SupplementDetailEntity detailEntity : supplementEntity.getDetailList()){
				ContractDetailEntity contractDetailEntity = BeanMapper.map(detailEntity, ContractDetailEntity.class);
				contractDetailEntity.setTid(contractDetailEntity.getId().toString());
				contractDetailEntity.setTpid(contractDetailEntity.getParentId()!= null&&contractDetailEntity.getParentId()>0?contractDetailEntity.getParentId().toString():"");
				contractDetailEntity.setId(null);
				contractDetailEntity.setTreeIndex(null);
				contractDetailEntity.setContractId(contractEntity.getId());
				contractDetailEntity.setSrcSupplementDetailId(detailEntity.getId());
				contractDetailEntity.setSrcSupplementFlag(1);
				contractDetailEntity.setSrcSupplementId(supplementEntity.getId());
				detailList.add(contractDetailEntity);
			}

			contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);

			//根据更新后数据维护树形关系
			Map<String,Long> idMap=new HashMap<>();
			detailList.forEach(cdEntity ->{
				idMap.put(cdEntity.getTid(),cdEntity.getId());
			});

			detailList.forEach(cdEntity ->{
				if(StringUtils.isNotEmpty(cdEntity.getTpid())){
					cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
				}
			});

			// 生成结构码、内码、逻辑内码
			List<Map> resultMapList = BeanMapper.mapList(detailList, Map.class);
			List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
			List<Map<String, Object>> ListCodeDate = creatCode(treeData, null, null);
			List<ContractDetailEntity> entities = new ArrayList<>();
			treeToList(ListCodeDate, entities);
			contractDetailService.saveOrUpdateBatch(entities, entities.size(), false);
		}
	}

	/**
	 * 生成内码、序号
	 *
	 * @param list
	 * @param innerCode
	 * @return
	 */
	private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String innerCode, String detailIndex) {
		for (int i = 0; i < list.size(); i++) {
			Map<String, Object> ypd = list.get(i);
			//树形编码
			if (null == ypd.get("treeIndex")) {
				ypd.put("treeIndex", StringUtils.isNotEmpty(detailIndex) ?  detailIndex + "." + (i + 1) : (i + 1));
			}
			// 生成内码
			if (StringUtils.isNotEmpty(innerCode)) {
				ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
			} else {
				ypd.put("innerCode", ypd.get("id"));
			}

			if (ypd.get("children") != null) {
				List<Map<String, Object>> child = creatCode((List) ypd.get("children"),	 ypd.get("innerCode").toString(), ypd.get("treeIndex").toString());
				ypd.put("children", child);
				ypd.put("leafFlag", false);
			}else {
				ypd.put("leafFlag", true);
			}
		}
		return list;
	}

	private void treeToList(List<Map<String, Object>> list, List<ContractDetailEntity> entities){
		for (Map<String, Object> ypd : list) {
			if (ypd.get("children") != null) {
				treeToList((List) ypd.get("children"), entities);
			}
			entities.add(BeanMapper.map(ypd, ContractDetailEntity.class));
		}
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("补充协议暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
