/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sub.utils.NCUtil;
import com.ejianc.business.sub.utils.NCVoucherAssidVO;
import com.ejianc.business.sub.utils.NCVoucherDetailVO;
import com.ejianc.business.sub.utils.NCVoucherVO;
import com.ejianc.business.sub.vo.nc.NCUtilVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ncUtil"})
public class NCUtilController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private NCUtil ncUtil;

    @RequestMapping(value={"/viewVoucher"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<NCVoucherVO>> viewVoucher(@RequestParam(value="sourceId", required=false) String sourceId) {
        String[] split;
        ArrayList<NCVoucherVO> list = new ArrayList<NCVoucherVO>();
        if (StringUtils.isEmpty((CharSequence)sourceId)) {
            list.add(new NCVoucherVO());
            return CommonResponse.success(list);
        }
        for (String pk_bill : split = sourceId.split(",")) {
            JSONObject param = new JSONObject();
            param.put("busitype", (Object)"queryVoucher");
            param.put("pk_bill", (Object)pk_bill);
            JSONObject jsonObject = this.ncUtil.postByJson2(param.toJSONString());
            NCVoucherVO vo = (NCVoucherVO)BeanMapper.map((Object)jsonObject, NCVoucherVO.class);
            if (CollectionUtils.isNotEmpty(vo.getDetail())) {
                List<NCVoucherDetailVO> detail = vo.getDetail();
                for (NCVoucherDetailVO data : detail) {
                    if (!CollectionUtils.isNotEmpty(data.getAssid())) continue;
                    StringBuffer checkValue = new StringBuffer();
                    for (NCVoucherAssidVO assid : data.getAssid()) {
                        if (checkValue.length() > 0) {
                            checkValue.append("\uff0c");
                        }
                        checkValue.append(assid.getChecktype() + "\uff1a" + assid.getCheckvalue());
                    }
                    data.setCheckvalue(String.valueOf(checkValue));
                }
            }
            list.add(vo);
        }
        return CommonResponse.success(list);
    }

    @RequestMapping(value={"/notice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> notice(@RequestBody List<NCUtilVO> vos) {
        this.logger.info("--->> NC\u64a4\u56de\u63a8\u9001\u6d88\u606f{}" + JSONObject.toJSONString(vos));
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        for (NCUtilVO vo : vos) {
            if (StringUtils.isEmpty((CharSequence)vo.getDef12()) || StringUtils.isEmpty((CharSequence)vo.getDef21())) continue;
            JSONObject json = this.ncUtil.queryBillDetail(vo.getDef12(), vo.getDef21());
            String createUserId = null;
            if (json.containsKey((Object)"createUserCode")) {
                createUserId = this.ncUtil.getCreateUserId(json.getString("createUserCode"));
            }
            if (StringUtils.isEmpty(createUserId)) continue;
            List<String> sender = Arrays.asList(createUserId);
            String billTypeName = this.ncUtil.getBillTypeName(vo.getDef21());
            StringBuffer str = new StringBuffer();
            str.append("\u60a8\u7684\u5355\u636e\u3010");
            str.append(billTypeName);
            str.append("_");
            str.append(json.getString("billCode"));
            str.append("\u3011\u5df2\u4ece\u8d22\u52a1\u64a4\u56de\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f03\u5ba1\u3002");
            String subject = str.toString();
            String content = StringUtils.isNotEmpty((CharSequence)vo.getDef20()) ? subject + "<a href=" + '\"' + vo.getDef20() + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>" : null;
            this.ncUtil.sendMsg(messageType, sender, "notice", subject, content, null);
        }
        return CommonResponse.success((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f");
    }
}

