/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller.api;

import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/blocKanBan/"})
public class SubBlocKanBanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IContractService contractService;

    @GetMapping(value={"queryExternalSupplierAndMny"})
    @ResponseBody
    public CommonResponse<Map<Long, ContractVO>> queryExternalSupplierAndMny(@RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="yearFlag") Integer yearFlag) {
        if (orgId == null) {
            Long tenantid = InvocationInfoProxy.getTenantid();
            CommonResponse orgByTenantId = this.orgApi.findOrgByTenantId(tenantid);
            orgId = ((OrgVO)orgByTenantId.getData()).getId();
        }
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        List<ContractVO> contractVOS = this.contractService.queryExternalSupplierAndMny(orgIds, yearFlag);
        List supplierIdList = contractVOS.stream().map(ContractVO::getSupplierId).collect(Collectors.toList());
        CommonResponse response = this.supplierApi.querySupplierByIds(supplierIdList);
        List data = (List)response.getData();
        List ids = data.stream().filter(vo -> vo.getInsideOrgId() == null).map(BaseVO::getId).collect(Collectors.toList());
        Map map = contractVOS.stream().filter(vo -> ids.contains(vo.getSupplierId())).collect(Collectors.toMap(ContractVO::getSupplierId, Function.identity()));
        return CommonResponse.success((String)"\u67e5\u8be2\u96c6\u56e2\u770b\u677f\u5206\u5305\u5408\u540c\u603b\u91d1\u989d", map);
    }
}

