/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.utils.NCUtil;
import com.ejianc.business.sub.vo.FinishVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="finish")
public class FinishBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IFinishService finishService;
    @Autowired
    private IOddjobService oddjobService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private NCUtil ncUtil;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        FinishVO finishEntity = this.finishService.queryDetail(billId);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(finishEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, (Object)sumSettleMny.add(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, (Object)sumOtherMny.add(otherMny));
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        if (CollectionUtils.isNotEmpty((Collection)finishEntity.getFinishOddjobList())) {
            this.oddjobService.updateSettleMny(finishEntity.getFinishOddjobList(), Boolean.TRUE);
        }
        this.finishService.costPush((FinishEntity)((Object)BeanMapper.map((Object)finishEntity, FinishEntity.class)));
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(finishEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())) {
            this.pushToNC((FinishEntity)((Object)BeanMapper.map((Object)finishEntity, FinishEntity.class)));
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    private void pushToNC(FinishEntity entity) {
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ApBillVO vo = this.transferToNCVO(entity, project);
        List<Long> orgIds = this.ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            vo.setPk_org(this.ncUtil.queryOrgById(orgId).getCode());
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            sourceIds = sourceIds + sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(FinishEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.finishService.update((Wrapper)wrapper);
    }

    private ApBillVO transferToNCVO(FinishEntity entity, ProjectRegisterVO project) {
        this.logger.info("----\u5206\u5305\u5b8c\u5de5\u7ed3\u7b97\u4f20\u5e94\u4ed8\u5355\u51ed\u8bc1\u5f00\u59cb:");
        ApBillVO vo = new ApBillVO();
        vo.setBusitype("apbill");
        vo.setTradetype("F1-Cxx-003");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setDef19(entity.getBillCode());
        vo.setDef1(Boolean.valueOf(false));
        vo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        vo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        if (StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setDef5(project.getAreaCode());
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));
        SupplierVO supplierVO = this.ncUtil.querySupplierById(entity.getSupplierId());
        vo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
        vo.setDef7(this.ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        vo.setDef13(project.getExcuteConstructState());
        vo.setDef16(entity.getSettlementStatus());
        vo.setDef20(this.ncUtil.getWebSite("ejc-sub-frontend/#/finish/card?id=" + entity.getId()));
        vo.setDef21("BT200630000000002");
        ArrayList<ApBillDetailVO> detailVOS = new ArrayList<ApBillDetailVO>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getSettleMny());
        detailVO.setLocal_mny(entity.getSettleTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        FinishVO finishEntity = this.finishService.queryDetail(billId);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(finishEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, (Object)sumSettleMny.subtract(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, (Object)sumOtherMny.subtract(otherMny));
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        if (CollectionUtils.isNotEmpty((Collection)finishEntity.getFinishOddjobList())) {
            this.oddjobService.updateSettleMny(finishEntity.getFinishOddjobList(), Boolean.FALSE);
        }
        this.finishService.pullCost(billId);
        if (StringUtils.isNotEmpty((CharSequence)finishEntity.getSourceId())) {
            String[] split;
            String sourceId = finishEntity.getSourceId();
            for (String pk_bill : split = sourceId.split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deleteapbill");
                json.put("pk_bill", (Object)pk_bill);
                this.ncUtil.postByJson(json.toJSONString());
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(FinishEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.finishService.update((Wrapper)wrapper);
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }
}

