/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.NCUtil;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settle")
public class SettleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IOddjobService oddjobService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private NCUtil ncUtil;

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BigDecimal sumOffsetMnys;
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        SettleEntity settlementEntity = (SettleEntity)((Object)this.settleService.selectById(billId));
        BigDecimal offsetMny = settlementEntity.getOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getOffsetMny();
        BigDecimal sumPayMnys = settlementEntity.getSumPrepayMny() == null ? BigDecimal.ZERO : settlementEntity.getSumPrepayMny();
        BigDecimal bigDecimal = sumOffsetMnys = settlementEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getSumOffsetMny();
        if (offsetMny.compareTo(sumPayMnys.subtract(sumOffsetMnys)) > 0) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u51b2\u62b5\u91d1\u989d\u5df2\u8d85\u51fa\u9884\u4ed8\u6b3e\u91d1\u989d!");
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleVO settleEntity = this.settleService.queryDetail(billId, true);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(settleEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = settleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settleEntity.getSettleTaxMny();
        BigDecimal settleMny = settleEntity.getSettleMny() == null ? BigDecimal.ZERO : settleEntity.getSettleMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = settleEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobTaxMny();
        BigDecimal jobMny = settleEntity.getOddjobMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = settleEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOtherTaxMny();
        BigDecimal otherMny = settleEntity.getOtherMny() == null ? BigDecimal.ZERO : settleEntity.getOtherMny();
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getSumOffsetMny();
        BigDecimal offsetMny = settleEntity.getOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getOffsetMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, (Object)sumSettleMny.add(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, (Object)sumOtherMny.add(otherMny));
        updateWrapper.set(ContractEntity::getSumOffsetMny, (Object)sumOffsetMny.add(offsetMny));
        updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        if (CollectionUtils.isNotEmpty((Collection)settleEntity.getSettleOddjobList())) {
            this.oddjobService.updateSettleMnyByPks(settleEntity.getSettleOddjobList(), Boolean.TRUE);
        }
        this.settleService.costPush((SettleEntity)((Object)BeanMapper.map((Object)settleEntity, SettleEntity.class)));
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(settleEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())) {
            this.pushToNC((SettleEntity)((Object)BeanMapper.map((Object)settleEntity, SettleEntity.class)));
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    private void pushToNC(SettleEntity entity) {
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ApBillVO vo = this.transferToNCVO(entity, project);
        List<Long> orgIds = this.ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            vo.setPk_org(this.ncUtil.queryOrgById(orgId).getCode());
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            sourceIds = sourceIds + sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(SettleEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.settleService.update((Wrapper)wrapper);
    }

    private ApBillVO transferToNCVO(SettleEntity entity, ProjectRegisterVO project) {
        this.logger.info("----\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97\u4f20\u5e94\u4ed8\u5355\u51ed\u8bc1\u5f00\u59cb:");
        ApBillVO vo = new ApBillVO();
        vo.setBusitype("apbill");
        vo.setTradetype("F1-Cxx-002");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setDef19(entity.getBillCode());
        vo.setDef1(Boolean.valueOf(false));
        vo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        vo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        if (StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setDef5(project.getAreaCode());
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));
        SupplierVO supplierVO = this.ncUtil.querySupplierById(entity.getSupplierId());
        vo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
        vo.setDef7(this.ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        vo.setDef13(project.getExcuteConstructState());
        vo.setDef16(entity.getSettlementStatus());
        vo.setDef20(this.ncUtil.getWebSite("ejc-sub-frontend/#/settle/card?id=" + entity.getId()));
        vo.setDef21("BT200630000000001");
        ArrayList<ApBillDetailVO> detailVOS = new ArrayList<ApBillDetailVO>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getSettleMny());
        detailVO.setLocal_mny(entity.getSettleTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settlementEntity = (SettleEntity)((Object)this.settleService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(settlementEntity.getContractId()));
        if (contractEntity.getFinishFlag().booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5b8c\u5de5\u7ed3\u7b97\uff0c\u4e0d\u80fd\u56de\u9000!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(SettleEntity::getContractId, (Object)settlementEntity.getContractId());
            lambdachange.eq(SettleEntity::getOrgId, (Object)settlementEntity.getOrgId());
            lambdachange.gt(BaseEntity::getCreateTime, (Object)settlementEntity.getCreateTime());
            lambdachange.ne(BaseEntity::getId, (Object)billId);
            lambdachange.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            int num = this.settleService.count((Wrapper)lambdachange);
            if (num > 0) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u4e0d\u662f\u6700\u65b0\u7684\u7ed3\u7b97\u65e5\u671f\uff0c\u4e0d\u80fd\u56de\u9000!");
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleVO settleEntity = this.settleService.queryDetail(billId, true);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(settleEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = settleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settleEntity.getSettleTaxMny();
        BigDecimal settleMny = settleEntity.getSettleMny() == null ? BigDecimal.ZERO : settleEntity.getSettleMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = settleEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobTaxMny();
        BigDecimal jobMny = settleEntity.getOddjobMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = settleEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOtherTaxMny();
        BigDecimal otherMny = settleEntity.getOtherMny() == null ? BigDecimal.ZERO : settleEntity.getOtherMny();
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal offsetMny = settleEntity.getOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getOffsetMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, (Object)sumSettleMny.subtract(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, (Object)sumOtherMny.subtract(otherMny));
        updateWrapper.set(ContractEntity::getSumOffsetMny, (Object)sumOffsetMny.subtract(offsetMny));
        updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        if (CollectionUtils.isNotEmpty((Collection)settleEntity.getSettleOddjobList())) {
            this.oddjobService.updateSettleMnyByPks(settleEntity.getSettleOddjobList(), Boolean.FALSE);
        }
        this.settleService.pullCost(billId);
        if (StringUtils.isNotEmpty((CharSequence)settleEntity.getSourceId())) {
            String[] split;
            String sourceId = settleEntity.getSourceId();
            for (String pk_bill : split = sourceId.split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deleteapbill");
                json.put("pk_bill", (Object)pk_bill);
                this.ncUtil.postByJson(json.toJSONString());
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(SettleEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.settleService.update((Wrapper)wrapper);
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }
}

