/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.pub.utils.HttpTookit;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class NCUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ISupplierWebApi supplierWebApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${nc.ncArUrl}")
    private String ncArUrl;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    private static final Map<Integer, String> invoiceMainMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> taxWayMap;

    public String getInvoiceMainDefCode(Integer key) {
        if (key == null) {
            throw new BusinessException("\u9879\u76ee-\u5f00\u7968\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invoiceMainMap.containsKey(key)) {
            return invoiceMainMap.get(key);
        }
        return null;
    }

    public String getTaxWayDefCode(Integer key) {
        if (key == null) {
            throw new BusinessException("\u9879\u76ee-\u8ba1\u7a0e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (taxWayMap.containsKey(key)) {
            return taxWayMap.get(key);
        }
        return null;
    }

    public String getTaxRateDefCode(BigDecimal taxRate) {
        String tax;
        if (taxRate == null) {
            throw new BusinessException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DefdocDetailVO> defList = this.getDefDocListById(515260415240835083L);
        Map<String, String> defMap = defList.stream().collect(Collectors.toMap(x -> x.getName(), DefdocDetailVO::getCode));
        if (defMap.containsKey(tax = taxRate.stripTrailingZeros().toPlainString() + "%")) {
            return defMap.get(tax);
        }
        throw new BusinessException("\u5f55\u5165\u7a0e\u7387\u201c" + tax + "\u201d\u548c\u8d22\u52a1\u7a0e\u7387\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\uff01");
    }

    public List<DefdocDetailVO> getDefDocListById(Long id) {
        CommonResponse resp = this.defdocApi.getDefDocByDefId(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    public DefdocDetailVO getDefDocById(Long id) {
        if (id == null) {
            return new DefdocDetailVO();
        }
        CommonResponse resp = this.defdocApi.getDefDocById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (DefdocDetailVO)resp.getData();
    }

    public OrgVO queryOrgById(Long id) {
        CommonResponse resp = this.orgApi.detailById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (OrgVO)resp.getData();
    }

    public List<ProjectRegisterVO> queryProjectByIds(List<Long> ids) {
        CommonResponse resp = this.projectApi.queryProjectByIds(ids);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    public SupplierVO querySupplierById(Long id) {
        CommonResponse resp = this.supplierApi.queryById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (SupplierVO)resp.getData();
    }

    public CustomerVO queryCustomerById(Long id) {
        CommonResponse resp = this.customerApi.detailById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (CustomerVO)resp.getData();
    }

    public BankAccountVO queryDefaultBankAccountById(Long id, String type) {
        CommonResponse resp = this.supplierWebApi.queryDefaultBankAccountById(id, type);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (BankAccountVO)resp.getData();
    }

    public List<Long> validateDaoQiaoOrg(Long orgId, Integer invoiceMain) {
        Long daoQiaoId = 1406795679766782028L;
        OrgVO orgVO = this.queryOrgById(orgId);
        if (orgVO.getInnerCode().contains(String.valueOf(daoQiaoId))) {
            if (new Integer(0).equals(invoiceMain) || daoQiaoId.equals(orgId)) {
                return Arrays.asList(daoQiaoId);
            }
            if (new Integer(1).equals(invoiceMain)) {
                return Arrays.asList(orgId, daoQiaoId);
            }
        }
        return Arrays.asList(orgId);
    }

    public String postByJson(String param) {
        HashMap headers = new HashMap();
        this.logger.info("-\u4f20NC\u51ed\u8bc1\u5165\u53c2:" + param);
        String back = null;
        try {
            back = HttpTookit.postByJson((String)this.ncArUrl, (String)param, headers);
        }
        catch (Exception e) {
            try {
                back = HttpTookit.postByJson((String)this.ncArUrl, (String)param, headers);
            }
            catch (Exception e1) {
                throw new BusinessException("\u63a8\u9001NC\u63a5\u53e3\u5f02\u5e38!");
            }
        }
        this.logger.info("-\u4f20NC\u51ed\u8bc1\u56de\u53c2:" + back);
        JSONObject json = JSONObject.parseObject((String)back);
        if (!"200".equals(json.getString("code"))) {
            throw new BusinessException(json.getString("msg"));
        }
        return json.getString("result");
    }

    public JSONObject postByJson2(String param) {
        HashMap headers = new HashMap();
        this.logger.info("--\u8054\u67e5NC\u51ed\u8bc1\u5165\u53c2:" + param);
        String back = null;
        try {
            back = HttpTookit.postByJson((String)this.ncArUrl, (String)param, headers);
        }
        catch (Exception e) {
            try {
                back = HttpTookit.postByJson((String)this.ncArUrl, (String)param, headers);
            }
            catch (Exception e1) {
                throw new BusinessException("\u63a8\u9001NC\u63a5\u53e3\u5f02\u5e38!");
            }
        }
        this.logger.info("--\u8054\u67e5NC\u51ed\u8bc1\u56de\u53c2:" + back);
        JSONObject json = JSONObject.parseObject((String)back);
        if (json.containsKey((Object)"code") && !"200".equals(json.getString("code"))) {
            throw new BusinessException(json.getString("msg"));
        }
        return json;
    }

    public JSONObject queryBillDetail(String businessKey, String billTypeCode) {
        JSONObject json = this.commenQueryFieldsService.queryBillDetail(businessKey, billTypeCode);
        if (json.getInteger("code") != 0) {
            throw new BusinessException(json.getString("msg"));
        }
        return json.getJSONObject("data");
    }

    public String getWebSite(String url) {
        Long userid = InvocationInfoProxy.getUserid();
        String targeturl = this.BASE_HOST + url;
        this.logger.info("--->> targeturl: " + targeturl);
        try {
            targeturl = URLEncoder.encode(targeturl, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String webSite = this.BASE_HOST + "portal/sso/index?userid=" + userid + "&targeturl=" + targeturl;
        this.logger.info("--->> \u751f\u6210\u5916\u90e8\u8df3\u8f6c\u5730\u5740: " + webSite);
        return webSite;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
            weixineeParams.put("description", (Object)subject);
            weixineeParams.put("url", (Object)mobileUrl);
            weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.info("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.info("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    public String getCreateUserId(String userCode) {
        block8: {
            try {
                MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
                if (!StringUtils.isNotBlank((CharSequence)userCode) || !StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost())) break block8;
                String cacheKey = "refer_cache_key:idm-employee:" + userCode;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject((String)cacheValue.toString());
                } else {
                    String referData = NCUtil.getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject((String)referData);
                    String referUrl = json.get((Object)"projectName").toString();
                    Map<String, String> reflist = new HashMap();
                    reflist = (Map)json.get((Object)"refMapList");
                    reflist.put("userCode", userCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;
                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader((String)url, reflist);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonbackstr)) {
                        jsonObject = JSON.parseObject((String)jsonbackstr);
                        redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 5L, TimeUnit.DAYS);
                    }
                }
                if (jsonObject != null) {
                    return jsonObject.getString("id");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userCode;
    }

    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader((String)(urlconstants.getMetaDataBaseUrl() + referCode), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject((String)jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException((String)("\u53c2\u7167\u7f16\u7801" + referCode + "\u7684\u5b9e\u4f53\u6ca1\u6709\u53d1\u5e03\u5143\u6570\u636e!"));
        }
        return data;
    }

    public BillTypeVO getBillTypeByCode(String code) {
        CommonResponse resp = this.billTypeApi.getByCode(code);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (BillTypeVO)resp.getData();
    }

    public String getBillTypeName(String code) {
        BillTypeVO vo = this.getBillTypeByCode(code);
        return StringUtils.isNotEmpty((CharSequence)vo.getBillName()) ? vo.getBillName() : "";
    }

    static {
        invoiceMainMap.put(0, "PMDA06001");
        invoiceMainMap.put(1, "PMDA06002");
        taxWayMap = new HashMap<Integer, String>();
        taxWayMap.put(0, "01");
        taxWayMap.put(1, "02");
        taxWayMap.put(2, "03");
    }
}

