package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 完工结算明细表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_finish_detail")
public class FinishDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 结算ID
     */
    @TableField("finish_id")
    private Long finishId;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同明细ID
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 序号
     */
    @TableField("tree_index")
    private String treeIndex;

    /**
     * 清单编码
     */
    @TableField("code")
    private String code;

    /**
     * 清单名称
     */
    @TableField("name")
    private String name;

    /**
     * 计量单位
     */
    @TableField("unit")
    private String unit;

    /**
     * 工程量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 综合单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 完工结算工程量
     */
    @TableField("finish_num")
    private BigDecimal finishNum;

    /**
     * 完工结算金额
     */
    @TableField("finish_mny")
    private BigDecimal finishMny;

    /**
     * 税率
     */
    @TableField("detail_tax_rate")
    private BigDecimal detailTaxRate;

    /**
     * 含税单价
     */
    @TableField("tax_price")
    private BigDecimal taxPrice;

    /**
     * 税额
     */
    @TableField("detail_tax")
    private BigDecimal detailTax;

    /**
     * 完工结算金额(含税)
     */
    @TableField("finish_tax_mny")
    private BigDecimal finishTaxMny;

    /**
     * 来源类型(1:合同内，2:合同外)
     */
    @TableField("source_type")
    private Integer sourceType;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 父ID
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 是否末级
     */
    @TableField("leaf_flag")
    private Boolean leafFlag;

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    /**
     * 合同金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 累计完成工程量
     */
    @TableField("sum_finish_num")
    private BigDecimal sumFinishNum;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;

    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;


    /**
     * 核算对象主键
     */
    @TableField(value="accounting_id")
    private java.lang.Long accountingId; // 核算对象主键

    /**
     * 核算对象名称
     */
    @TableField(value="accounting_name")
    private java.lang.String accountingName; // 核算对象名称

    /**
     * 集团成本科目主键
     */
    @TableField(value="org_subject_id")
    private java.lang.Long orgSubjectId;

    /**
     * 集团核算对象主键
     */
    @TableField(value="org_accounting_id")
    private java.lang.Long orgAccountingId;

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public BigDecimal getFinishTaxMny() {
        return finishTaxMny;
    }

    public void setFinishTaxMny(BigDecimal finishTaxMny) {
        this.finishTaxMny = finishTaxMny;
    }

    public BigDecimal getSumFinishNum() {
        return sumFinishNum;
    }

    public void setSumFinishNum(BigDecimal sumFinishNum) {
        this.sumFinishNum = sumFinishNum;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getFinishId() {
        return finishId;
    }

    public void setFinishId(Long finishId) {
        this.finishId = finishId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }

    public BigDecimal getFinishMny() {
        return finishMny;
    }

    public void setFinishMny(BigDecimal finishMny) {
        this.finishMny = finishMny;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    /**
     * 成本科目主键
     */
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目主键
     */
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    /**
     * 核算对象主键
     */
    public Long getAccountingId() {
        return accountingId;
    }

    /**
     * 核算对象主键
     */
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    /**
     * 核算对象名称
     */
    public String getAccountingName() {
        return accountingName;
    }

    /**
     * 核算对象名称
     */
    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    /**
     * 集团成本科目主键
     */
    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    /**
     * 集团成本科目主键
     */
    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    /**
     * 集团核算对象主键
     */
    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    /**
     * 集团核算对象主键
     */
    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }

}
