package com.ejianc.business.sub.service;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @version 1.0
 * @description: TODO
 * @date 2021/7/8
 */
@Service
public class CommonBillCodeService {


    @Autowired
    private IOrgApi orgApi;


    @Autowired
    private IBillCodeApi billCodeApi;


    private final String REGEX = "\\{(.*?)}";


    /***
     * @description: 根据额外属性生成编号
     *
     * @param codeRule 规则编码
     * @param valMap 额外的值，非实体属性中的值
     * @param vo 实体
     * @return: java.lang.String
     * @author songlx
     * @date: 2021/7/8
     */
    public String getCode(String codeRule, Map<String, String> valMap, BaseVO vo) {
        CommonResponse<String> resp = billCodeApi.getCodeBatchByRuleCode(codeRule, InvocationInfoProxy.getTenantid());
        if (!resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(resp.getMsg()) ? resp.getMsg() : "调用Rpc服务失败");
        }
        Map<String, Object> resultMap = new HashMap<>();
        String code = resp.getData();

        if (vo != null) {
            String jsonString1 = JSON.toJSONString(vo);
            Map<String, Object> map = JSON.parseObject(jsonString1, Map.class);
            resultMap.putAll(map);
        }
        if (valMap != null && valMap.size() > 0) {
            resultMap.putAll(valMap);
        }
        if (resultMap != null && resultMap.size() > 0) {


            Pattern pattern = Pattern.compile(REGEX);
            Matcher matcher = pattern.matcher(code);

            while (matcher.find()) {
                String key = matcher.group(1);
                String _key = "{" + key + "}";
                if (resultMap.get(key) != null) {
                    code = code.replace(_key, resultMap.get(key) != null ? String.valueOf(resultMap.get(key)) : _key);
                }
            }

        }

        return code;


    }

    /**
     * @param orgId    组织类型（1：集团 ， 2：分（子）公司，3：经理部，4：虚拟组织，5：项目部）
     * @param codeRule
     * @param vo
     * @description:
     * @return: java.lang.String
     * @author songlx
     * @date: 2021/7/8
     */
    public String getCodeByOrgId(Long orgId, String codeRule, BaseVO vo) {
        String orgCode = "";
        Map<String, String> valMap = new HashMap<>();
        if (null != orgId) {
            CommonResponse<List<OrgVO>> parents = orgApi.findParentsByOrgId(orgId);
            if (parents != null && parents.getData() != null && CollectionUtils.isNotEmpty(parents.getData())) {
                List<OrgVO> orgs = parents.getData();
                Collections.sort(orgs, Comparator.comparing(OrgVO::getOrgType));
                Map<Integer, String> map = orgs.stream().collect(Collectors.toMap(OrgVO::getOrgType, OrgVO::getCode, (key1, key2) -> key2));
                String fCode = map.get(2);
                if (StringUtils.isNotEmpty(fCode)) {
                    orgCode = fCode;
                } else {
                    if (orgs.size() > 1) {
                        orgCode = orgs.get(orgs.size() - 2).getCode();
                    } else {
                        orgCode = orgs.get(0).getCode();
                    }
                }
                valMap.put("orgCode", orgCode);

            }
        }
        return this.getCode(codeRule, valMap, vo);
    }

    public String getCodeByOrgId(Long orgId, String codeRule,Map<String, String> valMap, BaseVO vo) {
        String orgCode = "";
        if (null != orgId) {
            CommonResponse<List<OrgVO>> parents = orgApi.findParentsByOrgId(orgId);
            if (parents != null && parents.getData() != null && CollectionUtils.isNotEmpty(parents.getData())) {
                List<OrgVO> orgs = parents.getData();
                Collections.sort(orgs, Comparator.comparing(OrgVO::getOrgType));
                Map<Integer, String> map = orgs.stream().collect(Collectors.toMap(OrgVO::getOrgType, OrgVO::getCode, (key1, key2) -> key2));
                String fCode = map.get(2);
                if (StringUtils.isNotEmpty(fCode)) {
                    orgCode = fCode;
                } else {
                    if (orgs.size() > 1) {
                        orgCode = orgs.get(orgs.size() - 2).getCode();
                    } else {
                        orgCode = orgs.get(0).getCode();
                    }
                }
                valMap.put("orgCode", orgCode);

            }
        }
        return this.getCode(codeRule, valMap, vo);
    }


}
