package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.utils.NCUtil;
import com.ejianc.business.sub.vo.FinishVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 分包零星用工表 审批流服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("finish")
public class FinishBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IFinishService finishService;

    @Autowired
    private IOddjobService oddjobService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private NCUtil ncUtil;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        FinishVO finishEntity = finishService.queryDetail(billId);
        ContractEntity contractEntity  = contractService.getById(finishEntity.getContractId());

        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();

        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();

        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();

        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
//        updateWrapper.set(ContractEntity::getFinishFlag, Boolean.TRUE);
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, sumSettleMny.add(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, sumOtherMny.add(otherMny));
        updateWrapper.eq(ContractEntity::getId, finishEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);

//        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
//            oddjobService.updateSettleByPks(finishEntity.getFinishOddjobList().stream().map(FinishOddjobVO::getOddjobId).collect(Collectors.toList()), Boolean.TRUE);
//        }
        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
            oddjobService.updateSettleMny(finishEntity.getFinishOddjobList(), Boolean.TRUE);
        }

        finishService.costPush(BeanMapper.map(finishEntity, FinishEntity.class));

        // 推送NC传应付单凭证
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(finishEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())){
            this.pushToNC(BeanMapper.map(finishEntity, FinishEntity.class));
        }

        return CommonResponse.success("审批回调合同成功！");
    }

    /**
     * 推送NC传应付单凭证
     * @param entity
     */
    private void pushToNC(FinishEntity entity) {
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);

        ApBillVO vo = this.transferToNCVO(entity, project);// 转换成NCVO

        // 道桥分公司开票主体区分
        List<Long> orgIds = ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            vo.setPk_org(ncUtil.queryOrgById(orgId).getCode());// 财务组织编码
            String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString()); // 调用NC传凭证接口
            sourceIds += sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);

        LambdaUpdateWrapper<FinishEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(FinishEntity::getSourceId, sourceIds);// 保存来源主键
        wrapper.eq(FinishEntity::getId, entity.getId());
        finishService.update(wrapper);
    }

    /**
     * 转换成NCVO
     * @param entity
     * @return
     */
    private ApBillVO transferToNCVO(FinishEntity entity, ProjectRegisterVO project){
        logger.info("----分包完工结算传应付单凭证开始:");
        ApBillVO vo = new ApBillVO();
        vo.setBusitype("apbill");// 业务标识(默认apbill)
        vo.setTradetype("F1-Cxx-003");// 交易类型
        vo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
        vo.setPk_dept(String.valueOf(entity.getDeptId()));// 部门主键
        vo.setDef12(String.valueOf(entity.getId()));// PM单据主键
        vo.setDef19(entity.getBillCode());// PM单据编码
        vo.setDef1(false);// 是否有计量证书，必输，默认false
        vo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));// 开票主体分类 0-PMDA06001,1-PMDA06002
        vo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay()));// 计税方式 0-01,1-02
        if(StringUtils.isEmpty(project.getAreaCode())){
            throw new BusinessException("项目-区域不能为空");
        }
        vo.setDef5(project.getAreaCode());// 区域编码
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));// 供应商主键
        SupplierVO supplierVO = ncUtil.querySupplierById(entity.getSupplierId());
        vo.setDef6(supplierVO.getInsideOrgId() != null);// 是否内部单位 true/false
        vo.setDef7(ncUtil.getTaxRateDefCode(entity.getTaxRate()));// 税率
        vo.setDef13(project.getExcuteConstructState());// 是否执行建造合同 0-否，1-是
        vo.setDef16(entity.getSettlementStatus());// 结算状态 0-未结算，1-已结算
        vo.setDef20(ncUtil.getWebSite("ejc-sub-frontend/#/finish/card?id=" + entity.getId()));// 外部访问url
        vo.setDef21("BT200630000000002");// 单据类型

        List<ApBillDetailVO> detailVOS = new ArrayList<>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getSettleMny());
        detailVO.setLocal_mny(entity.getSettleTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);

        vo.setDetail(detailVOS);
        return  vo;
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        FinishVO finishEntity = finishService.queryDetail(billId);
        ContractEntity contractEntity  = contractService.getById(finishEntity.getContractId());

        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();

        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();

        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();

        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
//        updateWrapper.set(ContractEntity::getFinishFlag, Boolean.FALSE);
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, sumSettleMny.subtract(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, sumOtherMny.subtract(otherMny));
        updateWrapper.eq(ContractEntity::getId, finishEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);

//        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
//            oddjobService.updateSettleByPks(finishEntity.getFinishOddjobList().stream().map(FinishOddjobVO::getOddjobId).collect(Collectors.toList()), Boolean.FALSE);
//        }
        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
            oddjobService.updateSettleMny(finishEntity.getFinishOddjobList(), Boolean.FALSE);
        }

        finishService.pullCost(billId);

        // 删除NC传应付单凭证
        if(StringUtils.isNotEmpty(finishEntity.getSourceId())){
            String sourceId = finishEntity.getSourceId();
            String[] split = sourceId.split(",");
            for (String pk_bill : split) {
                JSONObject json = new JSONObject();
                json.put("busitype", "deleteapbill");
                json.put("pk_bill", pk_bill);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }

            LambdaUpdateWrapper<FinishEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(FinishEntity::getSourceId, null);// 清空来源主键
            wrapper.eq(FinishEntity::getId, billId);
            finishService.update(wrapper);
        }

        return CommonResponse.success("审批回调合同成功！");
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

}
