package com.ejianc.business.sub.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SupplementEntity;
import com.ejianc.business.sub.service.ISupplementService;
import com.ejianc.business.sub.vo.SupplementRecordVO;
import com.ejianc.business.sub.vo.SupplementVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 分包补充协议实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("supplement")
public class SupplementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplementService supplementService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplementVO> saveOrUpdate(@RequestBody SupplementVO supplementVO) {
    	SupplementVO vo = supplementService.insertOrUpdate(supplementVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Description  新增根据合同主键查询转换
     * @param contractId
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementVO> addConvertByConId(Long contractId) {
        SupplementVO vo = supplementService.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementRecordVO> queryDetailRecord(Long id) {
        SupplementRecordVO vo = supplementService.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementVO> queryDetail(Long id) {
    	SupplementVO vo = supplementService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplementVO> vos) {
        supplementService.removeByIds(vos.stream().map(SupplementVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SupplementEntity> page = supplementService.queryPage(param,false);
        IPage<SupplementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
