package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * <p>
 * 分包零星用工表 审批流服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("oddjob")
public class OddjobBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IOddjobService oddjobService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        if(res.isSuccess()) {//单据未被下游单据引用
            OddjobEntity entity = oddjobService.selectById(billId);
            ContractEntity contractEntity = contractService.selectById(entity.getContractId());
            if(contractEntity.getFinishFlag()){
                return CommonResponse.error("分包合同已完工结算,零星用工不允许撤回和弃审");
            }else{
                return CommonResponse.success();
            }
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OddjobEntity oddjobEntity = oddjobService.getById(billId);
        ContractEntity contractEntity  = contractService.getById(oddjobEntity.getContractId());
        BigDecimal sumOddjobTaxMny = contractEntity.getSumOddjobTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobTaxMny();
        BigDecimal sumOddjobMny = contractEntity.getSumOddjobMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobMny();
        BigDecimal jobTaxMny = oddjobEntity.getJobTaxMny() == null ? BigDecimal.ZERO : oddjobEntity.getJobTaxMny();
        BigDecimal jobMny = oddjobEntity.getJobMny() == null ? BigDecimal.ZERO : oddjobEntity.getJobMny();
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getSumOddjobTaxMny, sumOddjobTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobMny, sumOddjobMny.add(jobMny));
        updateWrapper.eq(ContractEntity::getId, oddjobEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);
        return CommonResponse.success("审批回调合同成功！");
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        OddjobEntity oddjobEntity = oddjobService.getById(billId);
        ContractEntity contractEntity  = contractService.getById(oddjobEntity.getContractId());
        BigDecimal sumOddjobTaxMny = contractEntity.getSumOddjobTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobTaxMny();
        BigDecimal sumOddjobMny = contractEntity.getSumOddjobMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobMny();
        BigDecimal jobTaxMny = oddjobEntity.getJobTaxMny() == null ? BigDecimal.ZERO : oddjobEntity.getJobTaxMny();
        BigDecimal jobMny = oddjobEntity.getJobMny() == null ? BigDecimal.ZERO : oddjobEntity.getJobMny();
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getSumOddjobTaxMny, sumOddjobTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobMny, sumOddjobMny.subtract(jobMny));
        updateWrapper.eq(ContractEntity::getId, oddjobEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);
        return CommonResponse.success("撤回回调合同成功！");
    }

}
