/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishDetailEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.FinishOddjobEntity;
import com.ejianc.business.sub.bean.FinishOtherEntity;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.bean.SupplementEntity;
import com.ejianc.business.sub.mapper.FinishMapper;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishCostService;
import com.ejianc.business.sub.service.IFinishDetailService;
import com.ejianc.business.sub.service.IFinishOddjobService;
import com.ejianc.business.sub.service.IFinishOtherService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.service.ISupplementService;
import com.ejianc.business.sub.utils.NCUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.FinishDetailVO;
import com.ejianc.business.sub.vo.FinishRecordDetailVO;
import com.ejianc.business.sub.vo.FinishRecordVO;
import com.ejianc.business.sub.vo.FinishVO;
import com.ejianc.business.sub.vo.comparator.FinishDetailComparatorVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="FinishServiceImpl")
public class FinishServiceImpl
extends BaseServiceImpl<FinishMapper, FinishEntity>
implements IFinishService {
    private static final String SUB_FINISH_BILL_CODE = "SUB_FINISH";
    private static final String SUB_FINISH = "SUB_FINISH";
    private static final String SUB_FINISH_DETAIL = "SUB_FINISH_DETAIL";
    private static final String SUB_FINISH_ODDJOB = "SUB_FINISH_ODDJOB";
    private static final String SUB_FINISH_OTHER = "SUB_FINISH_OTHER";
    private static final String SUB_FINISH_COST = "SUB_FINISH_COST";
    private static final String CHECK_PARAM_CODE = "P-2452lK17";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IFinishDetailService finishDetailService;
    @Autowired
    private IFinishOddjobService finishOddjobService;
    @Autowired
    private IFinishOtherService finishOtherService;
    @Autowired
    private IFinishCostService finishCostService;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IOddjobService oddJobService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private ISupplementService supplementService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public FinishVO insertOrUpdate(FinishVO finishVO) {
        if (this.checkSameContract(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u505a\u8fc7\u5b8c\u5de5\u7ed3\u7b97\uff01");
        }
        if (this.checkUnEffectChange(finishVO)) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0e\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if (this.checkUnEffectSupplement(finishVO)) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0e\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if (this.checkUnEffectSettle(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0e\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u8fc7\u7a0b\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if (this.checkUnEffectOddjob(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0e\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u96f6\u661f\u7528\u5de5\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if ((finishVO.getId() == null || finishVO.getId() <= 0L) && this.checkFinishContract(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(finishVO.getContractId()), (String)BillTypeCodeEnum.\u5206\u5305\u5408\u540c.getBillTypeCode(), (Integer)finishVO.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)finishVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("SUB_FINISH", InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                finishVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (this.checkSameBillCode(finishVO).booleanValue()) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        finishVO.setRelationFlag("0");
        finishVO.setProportionFlag("0");
        FinishEntity finishEntity = (FinishEntity)((Object)BeanMapper.map((Object)finishVO, FinishEntity.class));
        List<FinishDetailEntity> beforeDetails = finishEntity.getFinishDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == finishEntity.getId()) {
            for (FinishDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate((Object)finishEntity, false);
        List<FinishDetailEntity> finishDetailEntities = finishEntity.getFinishDetailList();
        if (CollectionUtils.isNotEmpty(finishDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (FinishDetailEntity cdEntity : finishDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (FinishDetailEntity cdEntity : finishDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.finishDetailService.saveOrUpdateBatch(finishDetailEntities, finishDetailEntities.size(), false);
        }
        this.writeBackContractFinsishFlag(finishEntity, Boolean.TRUE);
        return this.queryDetail(finishEntity.getId());
    }

    private boolean checkUnEffectSupplement(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SupplementEntity::getMainContractId, (Object)finishVO.getContractId());
        lambda.eq(SupplementEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.notIn(SupplementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.supplementService.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkSameBillCode(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(FinishEntity::getBillCode, (Object)finishVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != finishVO.getId() && finishVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)finishVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkSameContract(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(FinishEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(FinishEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != finishVO.getId() && finishVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)finishVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private boolean checkUnEffectChange(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangeEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(ChangeEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.changeService.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkUnEffectSettle(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(SettleEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.settleService.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkUnEffectOddjob(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(OddjobEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(OddjobEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.notIn(OddjobEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.oddJobService.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkFinishContract(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)finishVO.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(ContractEntity::getFinishFlag, (Object)true);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public FinishVO queryDetail(Long id) {
        FinishEntity finishEntity = (FinishEntity)((Object)super.selectById((Serializable)id));
        FinishVO finishVO = (FinishVO)BeanMapper.map((Object)((Object)finishEntity), FinishVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("finishId", new Parameter("eq", (Object)id));
        List detailEntityList = this.finishDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (FinishDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, FinishDetailVO.class);
            Collections.sort(resultMapList, new FinishDetailComparatorVo());
            finishVO.setFinishDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
        }
        return finishVO;
    }

    @Override
    public CommonResponse<IPage<FinishVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        NCUtil.voucherParam(param);
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.queryPage(param, false);
        List finishVOList = BeanMapper.mapList((Iterable)page.getRecords(), FinishVO.class);
        Page finishVOIPage = new Page();
        finishVOIPage.setCurrent(page.getCurrent());
        finishVOIPage.setRecords(finishVOList);
        finishVOIPage.setSize(page.getSize());
        finishVOIPage.setTotal(page.getTotal());
        finishVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)finishVOIPage);
    }

    @Override
    public CommonResponse<String> deleteByIds(List<FinishVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List entityList = BeanMapper.mapList((Iterable)super.listByIds(ids), FinishEntity.class);
        for (FinishEntity finishEntity : entityList) {
            this.writeBackContractFinsishFlag(finishEntity, Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(ids, false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public FinishRecordVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        FinishRecordVO finishRecordVO = new FinishRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null || contractEntity.getFinishFlag() == false ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumScale = contractTaxMny == BigDecimal.ZERO ? BigDecimal.ZERO : sumSettleTaxMny.divide(contractTaxMny, 4).multiply(new BigDecimal(100));
        finishRecordVO.setContractId(id);
        finishRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        finishRecordVO.setPurchaseType(Integer.valueOf(contractEntity.getPurchaseType()));
        finishRecordVO.setContractName(contractEntity.getContractName());
        finishRecordVO.setSupplierName(contractEntity.getSupplierName());
        finishRecordVO.setContractTaxMny(contractTaxMny);
        finishRecordVO.setSumSettleTaxMny(sumSettleTaxMny);
        finishRecordVO.setSumScale(sumScale);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(FinishEntity::getContractId, (Object)id);
        lambda.in(FinishEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        List finishRecordDetailVOList = BeanMapper.mapList((Iterable)entities, FinishRecordDetailVO.class);
        if (CollectionUtils.isNotEmpty((Collection)finishRecordDetailVOList)) {
            finishRecordDetailVOList.forEach(entity -> {
                BigDecimal settleTaxMny = entity.getSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSettleTaxMny();
                BigDecimal scale = contractTaxMny == BigDecimal.ZERO ? BigDecimal.ZERO : settleTaxMny.divide(contractTaxMny, 4).multiply(new BigDecimal(100));
                entity.setSumScale(scale);
            });
        }
        finishRecordVO.setDetailList(finishRecordDetailVOList);
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(SettleEntity::getContractId, (Object)id);
        lambda2.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List settleList = this.settleService.list((Wrapper)lambda2);
        BigDecimal settleTaxMny = new BigDecimal(0);
        for (SettleEntity settle : settleList) {
            settleTaxMny = settleTaxMny.add(settle.getSettleTaxMny() == null ? BigDecimal.ZERO : settle.getSettleTaxMny());
        }
        finishRecordVO.setSettleTaxMny(settleTaxMny);
        finishRecordVO.setSettleBalanceMny(sumSettleTaxMny.subtract(settleTaxMny));
        return finishRecordVO;
    }

    @Override
    public FinishVO queryDetailAdd(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        FinishVO finishVO = (FinishVO)BeanMapper.map((Object)((Object)contractEntity), FinishVO.class);
        finishVO.setBillCode(null);
        finishVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        finishVO.setEmployeeName(null);
        finishVO.setContractId(contractEntity.getId());
        finishVO.setBillState(null);
        finishVO.setCreateUserCode(null);
        finishVO.setCreateTime(null);
        finishVO.setUpdateUserCode(null);
        finishVO.setUpdateTime(null);
        finishVO.setId(null);
        finishVO.setVersion(null);
        finishVO.setTaxMny(null);
        finishVO.setContractVersion(contractEntity.getVersion());
        return finishVO;
    }

    @Override
    public List<FinishVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = ((IPage)this.queryListVOs(param).getData()).getRecords();
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                FinishVO vo = (FinishVO)resVos.get(i);
                if (vo.getContractType() != null) {
                    if (vo.getContractType().equals(Long.valueOf("1270328729526124545"))) {
                        vo.setContractTypeName("\u52b3\u52a1\u5206\u5305");
                    } else if (vo.getContractType().equals(Long.valueOf("1270328674299723778"))) {
                        vo.setContractTypeName("\u4e13\u4e1a\u5206\u5305");
                    }
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public CommonResponse<FinishVO> pushCost(FinishVO finishVO) {
        FinishEntity finishEntity = (FinishEntity)((Object)((FinishMapper)this.baseMapper).selectById(finishVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)finishVO.getFinishDetailList())) {
            List detailEntities = BeanMapper.mapList((Iterable)finishVO.getFinishDetailList(), FinishDetailEntity.class);
            finishEntity.setFinishDetailList(detailEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)finishVO.getFinishOddjobList())) {
            List oddjobEntities = BeanMapper.mapList((Iterable)finishVO.getFinishOddjobList(), FinishOddjobEntity.class);
            finishEntity.setFinishOddjobList(oddjobEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)finishVO.getFinishDetailList())) {
            List otherEntities = BeanMapper.mapList((Iterable)finishVO.getFinishDetailList(), FinishOtherEntity.class);
            finishEntity.setFinishOtherList(otherEntities);
        }
        super.saveOrUpdate((Object)finishEntity, false);
        if (finishEntity.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || finishEntity.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
            this.costPush(finishEntity);
        }
        return CommonResponse.success((Object)this.queryDetail(finishVO.getId()));
    }

    @Override
    public void costPush(FinishEntity finishEntity) {
        Boolean isPush = true;
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(FinishDetailEntity::getFinishId, (Object)finishEntity.getId());
        List detailEntities = this.finishDetailService.list((Wrapper)detailWrapper);
        LambdaQueryWrapper oddjobWrapper = new LambdaQueryWrapper();
        oddjobWrapper.eq(FinishOddjobEntity::getFinishId, (Object)finishEntity.getId());
        List oddjobEntities = this.finishOddjobService.list((Wrapper)oddjobWrapper);
        LambdaQueryWrapper othWrapper = new LambdaQueryWrapper();
        othWrapper.eq(FinishOtherEntity::getFinishId, (Object)finishEntity.getId());
        List otherEntities = this.finishOtherService.list((Wrapper)othWrapper);
        if (CollectionUtils.isEmpty((Collection)detailEntities) && CollectionUtils.isEmpty((Collection)oddjobEntities) && CollectionUtils.isEmpty((Collection)otherEntities)) {
            isPush = false;
        } else if (CollectionUtils.isNotEmpty((Collection)detailEntities) && isPush.booleanValue()) {
            for (FinishDetailEntity detailEntity : detailEntities) {
                if (!detailEntity.getLeafFlag().booleanValue() || null != detailEntity.getSubjectId() || null != detailEntity.getAccountingId()) continue;
                isPush = false;
                break;
            }
        } else if (CollectionUtils.isNotEmpty((Collection)oddjobEntities) && isPush.booleanValue()) {
            for (FinishOddjobEntity oddjobEntity : oddjobEntities) {
                if (null != oddjobEntity.getSubjectId() || null != oddjobEntity.getAccountingId()) continue;
                isPush = false;
                break;
            }
        } else if (CollectionUtils.isNotEmpty((Collection)otherEntities) && isPush.booleanValue()) {
            for (FinishOtherEntity otherEntity : otherEntities) {
                if (null != otherEntity.getSubjectId() || null != otherEntity.getAccountingId()) continue;
                isPush = false;
                break;
            }
        }
        finishEntity.setFinishDetailList(detailEntities);
        finishEntity.setFinishOddjobList(oddjobEntities);
        finishEntity.setFinishOtherList(otherEntities);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getId());
        updateWrapper.set(FinishEntity::getRelationFlag, (Object)(isPush != false ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = finishEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (isPush.booleanValue()) {
                this.saveCost(finishEntity);
            }
            if (!isPush.booleanValue()) {
                this.costDetailApi.deleteSubject(finishEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && isPush.booleanValue()) {
            this.saveCost(finishEntity);
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(FinishEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal settleTaxMny, BigDecimal contractTaxMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, 4));
            if (2 == purchaseType) {
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (settleTaxMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny.toString()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(settleTaxMny.subtract(comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }

    private void saveCost(FinishEntity finishEntity) {
        CommonResponse commonResponse;
        List<FinishOtherEntity> list;
        List<FinishOddjobEntity> oddjobList;
        BigDecimal taxRate = finishEntity.getTaxRate().divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<FinishDetailEntity> detailEntities = finishEntity.getFinishDetailList();
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            for (FinishDetailEntity finishDetailEntity : detailEntities) {
                if (!finishDetailEntity.getLeafFlag().booleanValue() || finishDetailEntity.getSubjectId() == null || finishDetailEntity.getAccountingId() == null) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(finishDetailEntity.getSubjectId());
                costDetailVO.setSourceId(finishDetailEntity.getFinishId());
                costDetailVO.setSourceDetailId(finishDetailEntity.getId());
                costDetailVO.setHappenTaxMny(finishDetailEntity.getFinishTaxMny());
                costDetailVO.setHappenMny(finishDetailEntity.getFinishMny());
                costDetailVO.setHappenDate(finishEntity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("SUB_FINISH");
                costDetailVO.setSourceTabType(SUB_FINISH_DETAIL);
                costDetailVO.setProjectId(finishEntity.getProjectId());
                costDetailVO.setAccountingId(finishDetailEntity.getAccountingId());
                costDetailVO.setOrgSubjectId(finishDetailEntity.getOrgSubjectId());
                costDetailVO.setOrgAccountingId(finishDetailEntity.getOrgAccountingId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(oddjobList = finishEntity.getFinishOddjobList())) {
            for (FinishOddjobEntity finishOddjobEntity : oddjobList) {
                if (finishOddjobEntity.getSubjectId() == null || finishOddjobEntity.getAccountingId() == null) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(finishOddjobEntity.getSubjectId());
                costDetailVO.setSourceId(finishOddjobEntity.getFinishId());
                costDetailVO.setSourceDetailId(finishOddjobEntity.getId());
                costDetailVO.setHappenTaxMny(finishOddjobEntity.getSettleTaxMny());
                costDetailVO.setHappenMny(finishOddjobEntity.getSettleMny());
                costDetailVO.setHappenDate(finishEntity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("SUB_FINISH");
                costDetailVO.setSourceTabType(SUB_FINISH_ODDJOB);
                costDetailVO.setProjectId(finishEntity.getProjectId());
                costDetailVO.setAccountingId(finishOddjobEntity.getAccountingId());
                costDetailVO.setOrgSubjectId(finishOddjobEntity.getOrgSubjectId());
                costDetailVO.setOrgAccountingId(finishOddjobEntity.getOrgAccountingId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(list = finishEntity.getFinishOtherList())) {
            for (FinishOtherEntity otherEntity : list) {
                if (otherEntity.getSubjectId() == null || otherEntity.getAccountingId() == null) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherEntity.getSubjectId());
                costDetailVO.setSourceId(otherEntity.getFinishId());
                costDetailVO.setSourceDetailId(otherEntity.getId());
                costDetailVO.setHappenTaxMny(otherEntity.getTaxMoney());
                costDetailVO.setHappenMny(otherEntity.getMoney());
                costDetailVO.setHappenDate(finishEntity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("SUB_FINISH");
                costDetailVO.setSourceTabType(SUB_FINISH_OTHER);
                costDetailVO.setProjectId(finishEntity.getProjectId());
                costDetailVO.setAccountingId(otherEntity.getAccountingId());
                costDetailVO.setOrgSubjectId(otherEntity.getOrgSubjectId());
                costDetailVO.setOrgAccountingId(otherEntity.getOrgAccountingId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList) && !(commonResponse = this.costDetailApi.saveSubject(costDetailVOList)).isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
    }

    private void writeBackContractFinsishFlag(FinishEntity finishEntity, Boolean finishFlag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getFinishFlag, (Object)finishFlag);
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getContractId());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(finishEntity.getContractId()));
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
    }
}

