/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.ParamUtil;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.NCUtil;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleDetailVO;
import com.ejianc.business.sub.vo.SettleRecordVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"settle"})
public class SettleController
implements Serializable {
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO settleVO) {
        SettleVO vo = this.settleService.insertOrUpdate(settleVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleVO vo = this.settleService.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        NCUtil.voucherParam(param);
        IPage pageData = this.settleService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), SettleVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        return this.settleService.deleteByIds(vos);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleRecordVO> queryDetailRecord(Long id) {
        SettleRecordVO vo = this.settleService.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailAdd"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryDetailAdd(Long contractId) {
        SettleVO vo = this.settleService.queryDetailAdd(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u67e5\u8be2\u5408\u540c\u8f6c\u5316\u4e3a\u8fc7\u7a0b\u7ed3\u7b97\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/querySumSettlementTaxMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> querySumSettlementTaxMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        BigDecimal sumOffsetMnys;
        SettleVO vo = new SettleVO();
        CommonResponse sumPayMnyVO = this.payContractApi.getSumPayMny(contractId, orgId);
        if (!sumPayMnyVO.isSuccess()) {
            return CommonResponse.success((String)"\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPayMny();
        BigDecimal sumPrePayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPrePayMny();
        vo.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(SettleEntity::getContractId, (Object)contractId);
        lambdachange.eq(SettleEntity::getOrgId, (Object)orgId);
        lambdachange.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.settleService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] alreadySettleMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                alreadySettleMoney[0] = alreadySettleMoney[0].add(e.getSettleTaxMny() == null ? BigDecimal.ZERO : e.getSettleTaxMny());
                alreadySettleMoney[1] = alreadySettleMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            vo.setSumSettleTaxMny(alreadySettleMoney[0]);
            vo.setSumOffsetMny(alreadySettleMoney[1]);
        }
        BigDecimal bigDecimal = sumOffsetMnys = vo.getSumOffsetMny() == null ? BigDecimal.ZERO : vo.getSumOffsetMny();
        if (vo.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        ContractVO contractVO = this.contractService.queryDetail(contractId, true);
        vo.setStageList(contractVO.getStageList());
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/subSettlementRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> subSettlementRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        if (StringUtils.isNotBlank((CharSequence)condition) && (null == (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("type") || !"settleReport".equals(conditionMap.get("type")))) {
            ComplexParam c4 = ParamUtil.getOrParam((String)"surplusApplyMny", (Parameter)new Parameter("ne", (Object)0), (Parameter)new Parameter("eq", null));
            queryParam.getComplexParams().add(c4);
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("create_time", "desc");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject con = JSONObject.parseObject((String)condition);
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)con.getLong("contractId")));
            }
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)con.getLong("orgId")));
            }
            if (condition.contains("supplierId")) {
                queryParam.getParams().put("supplierId", new Parameter("eq", (Object)con.getLong("supplierId")));
            }
        }
        JSONObject page = this.settleService.querySubSettleVOList(queryParam, false);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        NCUtil.voucherParam(param);
        param.setPageIndex(1);
        param.setPageSize(-1);
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.settleService.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), SettleVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO settleVO) {
        return this.settleService.pushCost(settleVO);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType, @RequestParam(value="sumSettleMentTaxMny") BigDecimal sumSettleMentTaxMny, @RequestParam(value="contractTaxMny") BigDecimal contractTaxMny) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.settleService.checkParams(purchaseType, sumSettleMentTaxMny, contractTaxMny));
    }

    @PostMapping(value={"/excelDownload"})
    public void excelDownload(HttpServletResponse response, @RequestBody SettleDetailVO vo) {
        HashMap<String, List<SettleDetailVO>> beans = new HashMap<String, List<SettleDetailVO>>();
        List<SettleDetailVO> list = this.settleService.excelDownload(vo);
        beans.put("records", list);
        ExcelExport.getInstance().export("settle-detail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadDescription"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadDescription(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subject-description.xlsx", (String)"\u6210\u672c\u79d1\u76ee\u6302\u63a5\u8bf4\u660e");
    }
}

