/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.SettleDetailEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.bean.SettleOddjobEntity;
import com.ejianc.business.sub.bean.SettleOtherEntity;
import com.ejianc.business.sub.mapper.SettleMapper;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleDetailService;
import com.ejianc.business.sub.service.ISettleOddjobService;
import com.ejianc.business.sub.service.ISettleOtherService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.SettleDetailResultVO;
import com.ejianc.business.sub.vo.SettleDetailVO;
import com.ejianc.business.sub.vo.SettleOddjobVO;
import com.ejianc.business.sub.vo.SettleRecordDetailVO;
import com.ejianc.business.sub.vo.SettleRecordVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.business.sub.vo.comparator.SettleDetailComparatorVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="SettleServiceImpl")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    private static final String SUB_SETTLE_BILL_CODE = "SUB_SETTLE";
    private static final String SUB_SETTLE = "SUB_SETTLE";
    private static final String SUB_SETTLE_DETAIL = "SUB_SETTLE_DETAIL";
    private static final String SUB_SETTLE_ODDJOB = "SUB_SETTLE_ODDJOB";
    private static final String SUB_SETTLE_OTHER = "SUB_SETTLE_OTHER";
    private static final String CHECK_PARAM_CODE = "P-2452lK17";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISettleDetailService settleDetailService;
    @Autowired
    private ISettleOddjobService settleOddjobService;
    @Autowired
    private ISettleOtherService settleOtherService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettleVO insertOrUpdate(SettleVO settleVO) {
        BigDecimal syMny;
        block24: {
            if (this.checkFinishContract(settleVO).booleanValue()) {
                throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
            }
            if (settleVO.getContractVersion() != null && settleVO.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(settleVO.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (!version.equals(conVersion = settleVO.getContractVersion())) {
                            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        }
                        break block24;
                    }
                    throw new BusinessException("\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(settleVO.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.checkSameContract(settleVO).booleanValue()) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97\u5355");
        }
        if (StringUtils.isEmpty((CharSequence)settleVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("SUB_SETTLE", InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                settleVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (this.checkSameBillCode(settleVO).booleanValue()) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        settleVO.setRelationFlag("0");
        settleVO.setProportionFlag("0");
        SettleEntity settleEntity = (SettleEntity)((Object)BeanMapper.map((Object)settleVO, SettleEntity.class));
        List<SettleDetailEntity> beforeDetails = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == settleEntity.getId()) {
            for (SettleDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(SettleEntity::getContractId, (Object)settleVO.getContractId());
        lambdachange2.eq(SettleEntity::getOrgId, (Object)settleVO.getOrgId());
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambdachange2.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        lambdachange2.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdachange2.gt(SettleEntity::getSettleDate, (Object)settleVO.getSettleDate());
        int num2 = super.count((Wrapper)lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u5bf9\u5e94\u6700\u65b0\u7ed3\u7b97\u65e5\u671f!");
        }
        BigDecimal settlementTaxMny = settleVO.getSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSettleTaxMny();
        BigDecimal offsetMny = settleVO.getOffsetMny() == null ? BigDecimal.ZERO : settleVO.getOffsetMny();
        BigDecimal bigDecimal = syMny = settleVO.getSymny() == null ? BigDecimal.ZERO : settleVO.getSymny();
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u53ef\u51b2\u62b5\u91d1\u989d!");
        }
        if (settlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && offsetMny.compareTo(settlementTaxMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u672c\u671f\u7ed3\u7b97\u91d1\u989d");
        }
        super.saveOrUpdate((Object)settleEntity, false);
        List<SettleDetailEntity> settleDetailEntities = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(settleDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SettleDetailEntity cdEntity : settleDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SettleDetailEntity cdEntity : settleDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.settleDetailService.saveOrUpdateBatch(settleDetailEntities, settleDetailEntities.size(), false);
        }
        return this.queryDetail(settleEntity.getId(), true);
    }

    private Boolean checkSameBillCode(SettleVO settleVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getBillCode, (Object)settleVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkSameContract(SettleVO settleVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)settleVO.getContractId());
        lambda.eq(SettleEntity::getOrgId, (Object)settleVO.getOrgId());
        lambda.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != settleVO.getId() && settleVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)settleVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public SettleVO queryDetail(Long id, Boolean detailHasChildren) {
        BigDecimal settleTaxMny;
        BigDecimal cc;
        SettleEntity settleEntity = (SettleEntity)((Object)super.selectById((Serializable)id));
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class);
        List settleOddjobList = settleVO.getSettleOddjobList();
        if (settleOddjobList != null && settleOddjobList.size() > 0) {
            for (SettleOddjobVO settleOddjobVO : settleOddjobList) {
                settleOddjobVO.setRowState("edit");
            }
            settleVO.setSettleOddjobList(settleOddjobList);
        }
        BigDecimal c = settleVO.getContractTaxMny() == null ? BigDecimal.ZERO : settleVO.getContractTaxMny();
        BigDecimal bigDecimal = cc = settleVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSumSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) != 0 && cc.compareTo(BigDecimal.ZERO) != 0) {
            settleVO.setSumSettleScale(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        BigDecimal bigDecimal2 = settleTaxMny = settleVO.getSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) != 0 && settleTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            settleVO.setSettleScale(new BigDecimal(100).multiply(settleTaxMny.divide(c, 8, 5)));
        }
        BigDecimal sumPrePayMny = settleEntity.getSumPrepayMny() == null ? BigDecimal.ZERO : settleEntity.getSumPrepayMny();
        BigDecimal sumOffsetMny = settleEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getSumOffsetMny();
        settleVO.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter("eq", (Object)id));
        List detailEntityList = this.settleDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (SettleDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, SettleDetailVO.class);
            Collections.sort(resultMapList, new SettleDetailComparatorVo());
            if (detailHasChildren.booleanValue()) {
                settleVO.setSettleDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                settleVO.setSettleDetailList(resultMapList);
            }
        }
        return settleVO;
    }

    @Override
    public CommonResponse<IPage<SettleVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage page = this.queryPage(param, false);
        List settleVOList = BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class);
        Page settleVOIPage = new Page();
        settleVOIPage.setCurrent(page.getCurrent());
        settleVOIPage.setRecords(settleVOList);
        settleVOIPage.setSize(page.getSize());
        settleVOIPage.setTotal(page.getTotal());
        settleVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)settleVOIPage);
    }

    @Override
    public CommonResponse<String> deleteByIds(List<SettleVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        SettleRecordVO settleRecordVO = new SettleRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        settleRecordVO.setContractId(id);
        settleRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        settleRecordVO.setContractTaxMny(contractTaxMny);
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SettleEntity::getContractId, (Object)id);
        lambda.in(SettleEntity::getOrgId, commonOrgIds);
        lambda.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List settleRecordDetailVOList = BeanMapper.mapList((Iterable)entities, SettleRecordDetailVO.class);
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4)};
            settleRecordDetailVOList.forEach(entity -> {
                settlementMoney[0] = settlementMoney[0].add(entity.getSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSettleTaxMny());
                BigDecimal dSumSettleTaxMny = entity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSumSettleTaxMny();
                BigDecimal scale = contractTaxMny == BigDecimal.ZERO ? BigDecimal.ZERO : dSumSettleTaxMny.divide(contractTaxMny, 4).multiply(new BigDecimal(100));
                entity.setSumScale(scale);
            });
            settleRecordVO.setSumSettleTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = settleRecordVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleRecordVO.getSumSettleTaxMny();
            settleRecordVO.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny, 8, 5)));
            settleRecordVO.setDetailList(settleRecordDetailVOList);
        }
        return settleRecordVO;
    }

    @Override
    public SettleVO queryDetailAdd(Long contractId) {
        BigDecimal cc;
        BigDecimal sumOffsetMnys;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)contractEntity), SettleVO.class);
        settleVO.setBillCode(null);
        settleVO.setEmployeeId(null);
        settleVO.setEmployeeName(null);
        settleVO.setContractId(contractEntity.getId());
        settleVO.setBillState(null);
        settleVO.setCreateUserCode(null);
        settleVO.setCreateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setId(null);
        settleVO.setVersion(null);
        settleVO.setTaxMny(null);
        CommonResponse sumPayMnyVO = this.payContractApi.getSumPayMny(contractId, contractEntity.getOrgId());
        if (!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPayMny();
        BigDecimal sumPrePayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPrePayMny();
        settleVO.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        settleVO.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(SettleEntity::getContractId, (Object)contractId);
        lambdachange.eq(SettleEntity::getOrgId, (Object)contractEntity.getOrgId());
        lambdachange.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettleTaxMny() == null ? BigDecimal.ZERO : e.getSettleTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            settleVO.setSumSettleTaxMny(settlementMoney[0]);
            settleVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal bigDecimal = sumOffsetMnys = settleVO.getSumOffsetMny() == null ? BigDecimal.ZERO : settleVO.getSumOffsetMny();
        if (settleVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            settleVO.setSymny(settleVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        BigDecimal c = settleVO.getContractTaxMny() == null ? BigDecimal.ZERO : settleVO.getContractTaxMny();
        BigDecimal bigDecimal2 = cc = settleVO.getSumSettleTaxMny() == null ? BigDecimal.ZERO : settleVO.getSumSettleTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            settleVO.setSumSettleScale(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        return settleVO;
    }

    @Override
    public JSONObject querySubSettleVOList(QueryParam param, boolean isEs) {
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = SettleServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<SubSettleVO> list = ((SettleMapper)this.baseMapper).querySubSettleVOList(pages, wrapper);
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO settleVO) {
        SettleEntity settleEntity = (SettleEntity)((Object)((SettleMapper)this.baseMapper).selectById(settleVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleDetailList())) {
            List detailEntities = BeanMapper.mapList((Iterable)settleVO.getSettleDetailList(), SettleDetailEntity.class);
            settleEntity.setSettleDetailList(detailEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleOddjobList())) {
            List oddjobEntities = BeanMapper.mapList((Iterable)settleVO.getSettleOddjobList(), SettleOddjobEntity.class);
            settleEntity.setSettleOddjobList(oddjobEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleOtherList())) {
            List otherEntities = BeanMapper.mapList((Iterable)settleVO.getSettleOtherList(), SettleOtherEntity.class);
            settleEntity.setSettleOtherList(otherEntities);
        }
        super.saveOrUpdate((Object)settleEntity, false);
        if (settleEntity.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || settleEntity.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
            this.costPush(settleEntity);
        }
        return CommonResponse.success((Object)this.queryDetail(settleVO.getId(), true));
    }

    @Override
    public void costPush(SettleEntity settleEntity) {
        Boolean isPush = true;
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(SettleDetailEntity::getSettleId, (Object)settleEntity.getId());
        List detailEntities = this.settleDetailService.list((Wrapper)detailWrapper);
        LambdaQueryWrapper oddjobWrapper = new LambdaQueryWrapper();
        oddjobWrapper.eq(SettleOddjobEntity::getSettleId, (Object)settleEntity.getId());
        List oddjobEntities = this.settleOddjobService.list((Wrapper)oddjobWrapper);
        LambdaQueryWrapper othWrapper = new LambdaQueryWrapper();
        othWrapper.eq(SettleOtherEntity::getSettleId, (Object)settleEntity.getId());
        List otherEntities = this.settleOtherService.list((Wrapper)othWrapper);
        if (CollectionUtils.isEmpty((Collection)detailEntities) && CollectionUtils.isEmpty((Collection)oddjobEntities) && CollectionUtils.isEmpty((Collection)otherEntities)) {
            isPush = false;
        } else if (CollectionUtils.isNotEmpty((Collection)detailEntities) && isPush.booleanValue()) {
            for (SettleDetailEntity detailEntity : detailEntities) {
                if (!detailEntity.getLeafFlag().booleanValue() || null != detailEntity.getSubjectId() || null != detailEntity.getAccountingId()) continue;
                isPush = false;
                break;
            }
        } else if (CollectionUtils.isNotEmpty((Collection)oddjobEntities) && isPush.booleanValue()) {
            for (SettleOddjobEntity oddjobEntity : oddjobEntities) {
                if (null != oddjobEntity.getSubjectId() || null != oddjobEntity.getAccountingId()) continue;
                isPush = false;
                break;
            }
        } else if (CollectionUtils.isNotEmpty((Collection)otherEntities) && isPush.booleanValue()) {
            for (SettleOtherEntity otherEntity : otherEntities) {
                if (null != otherEntity.getSubjectId() || null != otherEntity.getAccountingId()) continue;
                isPush = false;
                break;
            }
        }
        settleEntity.setSettleDetailList(detailEntities);
        settleEntity.setSettleOddjobList(oddjobEntities);
        settleEntity.setSettleOtherList(otherEntities);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)(isPush != false ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = settleEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (isPush.booleanValue()) {
                this.saveCost(settleEntity);
            }
            if (!isPush.booleanValue()) {
                this.costDetailApi.deleteSubject(settleEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && isPush.booleanValue()) {
            this.saveCost(settleEntity);
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, 4));
            if (2 == purchaseType) {
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (sumSettleMentTaxMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(sumSettleMentTaxMny.toString()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumSettleMentTaxMny.subtract(comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }

    @Override
    public List<SettleDetailResultVO> querySettleDetail(Long contractId) {
        return ((SettleMapper)this.baseMapper).querySettleDetail(contractId);
    }

    @Override
    public List<SettleDetailVO> excelDownload(SettleDetailVO vo) {
        List<Object> list = new ArrayList<SettleDetailVO>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter("eq", (Object)vo.getSettleId()));
        List entityList = this.settleDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (SettleDetailEntity settleDetailEntity : entityList) {
                settleDetailEntity.setTid(settleDetailEntity.getId().toString());
                settleDetailEntity.setTpid(settleDetailEntity.getParentId() != null && settleDetailEntity.getParentId() > 0L ? settleDetailEntity.getParentId().toString() : "");
                settleDetailEntity.setRowState("edit");
            }
            list = BeanMapper.mapList((Iterable)entityList, SettleDetailVO.class);
            Collections.sort(list, new SettleDetailComparatorVo());
            for (SettleDetailVO settleDetailVO : list) {
                if (Objects.equals(settleDetailVO.getSourceType(), 1)) {
                    settleDetailVO.setSourceTypeName("\u5408\u540c\u5185");
                }
                if (Objects.equals(settleDetailVO.getSourceType(), 2)) {
                    settleDetailVO.setSourceTypeName("\u5408\u540c\u5916");
                }
                if (!Objects.equals(settleDetailVO.getSourceType(), null)) continue;
                settleDetailVO.setSourceTypeName(null);
            }
        }
        return list;
    }

    private void saveCost(SettleEntity settleEntity) {
        CommonResponse commonResponse;
        List<SettleOtherEntity> list;
        List<SettleOddjobEntity> oddjobList;
        BigDecimal taxRate = settleEntity.getTaxRate().divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<SettleDetailEntity> detailEntities = settleEntity.getSettleDetailList();
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            for (SettleDetailEntity settleDetailEntity : detailEntities) {
                if (!settleDetailEntity.getLeafFlag().booleanValue() || settleDetailEntity.getSubjectId() == null || settleDetailEntity.getAccountingId() == null) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(settleDetailEntity.getSubjectId());
                costDetailVO.setSourceId(settleDetailEntity.getSettleId());
                costDetailVO.setSourceDetailId(settleDetailEntity.getId());
                costDetailVO.setHappenMny(settleDetailEntity.getSettleMny());
                costDetailVO.setHappenTaxMny(settleDetailEntity.getSettleTaxMny());
                costDetailVO.setHappenDate(settleEntity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("SUB_SETTLE");
                costDetailVO.setSourceTabType(SUB_SETTLE_DETAIL);
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVO.setAccountingId(settleDetailEntity.getAccountingId());
                costDetailVO.setOrgSubjectId(settleDetailEntity.getOrgSubjectId());
                costDetailVO.setOrgAccountingId(settleDetailEntity.getOrgAccountingId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(oddjobList = settleEntity.getSettleOddjobList())) {
            for (SettleOddjobEntity settleOddjobEntity : oddjobList) {
                if (settleOddjobEntity.getSubjectId() == null || settleOddjobEntity.getAccountingId() == null) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(settleOddjobEntity.getSubjectId());
                costDetailVO.setSourceId(settleOddjobEntity.getSettleId());
                costDetailVO.setSourceDetailId(settleOddjobEntity.getId());
                costDetailVO.setHappenTaxMny(settleOddjobEntity.getSettleTaxMny());
                costDetailVO.setHappenMny(settleOddjobEntity.getSettleMny());
                costDetailVO.setHappenDate(settleEntity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("SUB_SETTLE");
                costDetailVO.setSourceTabType(SUB_SETTLE_ODDJOB);
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVO.setAccountingId(settleOddjobEntity.getAccountingId());
                costDetailVO.setOrgSubjectId(settleOddjobEntity.getOrgSubjectId());
                costDetailVO.setOrgAccountingId(settleOddjobEntity.getOrgAccountingId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(list = settleEntity.getSettleOtherList())) {
            for (SettleOtherEntity otherEntity : list) {
                if (otherEntity.getSubjectId() == null || otherEntity.getAccountingId() == null) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherEntity.getSubjectId());
                costDetailVO.setSourceId(otherEntity.getSettleId());
                costDetailVO.setSourceDetailId(otherEntity.getId());
                costDetailVO.setHappenTaxMny(otherEntity.getTaxMoney());
                costDetailVO.setHappenMny(otherEntity.getMoney());
                costDetailVO.setHappenDate(settleEntity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("SUB_SETTLE");
                costDetailVO.setSourceTabType(SUB_SETTLE_OTHER);
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVO.setAccountingId(otherEntity.getAccountingId());
                costDetailVO.setOrgSubjectId(otherEntity.getOrgSubjectId());
                costDetailVO.setOrgAccountingId(otherEntity.getOrgAccountingId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList) && !(commonResponse = this.costDetailApi.saveSubject(costDetailVOList)).isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
    }

    private Boolean checkFinishContract(SettleVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)finishVO.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(ContractEntity::getFinishFlag, (Object)true);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }
}

