/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.sub.bean.ContractClauseEntity;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.ContractStageEntity;
import com.ejianc.business.sub.bean.SupplementClauseEntity;
import com.ejianc.business.sub.bean.SupplementDetailEntity;
import com.ejianc.business.sub.bean.SupplementEntity;
import com.ejianc.business.sub.bean.SupplementStageEntity;
import com.ejianc.business.sub.service.IContractClauseService;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IContractStageService;
import com.ejianc.business.sub.service.ISupplementService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplement")
public class SupplementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ISupplementService supplementService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractStageService contractStageService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SupplementEntity supplementEntity = (SupplementEntity)((Object)this.supplementService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(supplementEntity.getMainContractId()));
        contractEntity.setContractMny(MathUtil.safeAdd((BigDecimal)contractEntity.getContractMny(), (BigDecimal)supplementEntity.getContractMny()));
        contractEntity.setContractTaxMny(MathUtil.safeAdd((BigDecimal)contractEntity.getContractTaxMny(), (BigDecimal)supplementEntity.getContractTaxMny()));
        contractEntity.setTaxMny(MathUtil.safeSub((BigDecimal)contractEntity.getContractTaxMny(), (BigDecimal)contractEntity.getContractMny()));
        this.contractService.updateById((Object)contractEntity);
        this.dealDetailData(supplementEntity, contractEntity);
        return CommonResponse.success();
    }

    private void dealStageData(SupplementEntity supplementEntity, ContractEntity contractEntity) {
        List<ContractStageEntity> stageList = contractEntity.getStageList();
        if (CollectionUtils.isNotEmpty(supplementEntity.getStageList())) {
            for (SupplementStageEntity stageEntity : supplementEntity.getStageList()) {
                ContractStageEntity contractStageEntity = (ContractStageEntity)((Object)BeanMapper.map((Object)((Object)stageEntity), ContractStageEntity.class));
                contractStageEntity.setContractId(contractEntity.getId());
                contractStageEntity.setId(null);
                contractStageEntity.setSrcSupplementDetailId(stageEntity.getId());
                contractStageEntity.setSrcSupplementFlag(1);
                contractStageEntity.setSrcSupplementId(supplementEntity.getId());
                stageList.add(contractStageEntity);
            }
            this.contractStageService.saveOrUpdateBatch(stageList, stageList.size(), false);
        }
    }

    private void dealClauseData(SupplementEntity supplementEntity, ContractEntity contractEntity) {
        List<ContractClauseEntity> clauseList = contractEntity.getClauseList();
        if (CollectionUtils.isNotEmpty(supplementEntity.getClauseList())) {
            for (SupplementClauseEntity clauseEntity : supplementEntity.getClauseList()) {
                ContractClauseEntity contractClauseEntity = (ContractClauseEntity)((Object)BeanMapper.map((Object)((Object)clauseEntity), ContractClauseEntity.class));
                contractClauseEntity.setContractId(contractEntity.getId());
                contractClauseEntity.setId(null);
                contractClauseEntity.setSrcSupplementDetailId(clauseEntity.getId());
                contractClauseEntity.setSrcSupplementFlag(1);
                contractClauseEntity.setSrcSupplementId(supplementEntity.getId());
                clauseList.add(contractClauseEntity);
            }
            this.contractClauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
    }

    private void dealDetailData(SupplementEntity supplementEntity, ContractEntity contractEntity) {
        List<ContractDetailEntity> detailList = contractEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(supplementEntity.getDetailList())) {
            for (SupplementDetailEntity detailEntity : supplementEntity.getDetailList()) {
                ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)BeanMapper.map((Object)((Object)detailEntity), ContractDetailEntity.class));
                contractDetailEntity.setTid(contractDetailEntity.getId().toString());
                contractDetailEntity.setTpid(contractDetailEntity.getParentId() != null && contractDetailEntity.getParentId() > 0L ? contractDetailEntity.getParentId().toString() : "");
                contractDetailEntity.setId(null);
                contractDetailEntity.setTreeIndex(null);
                contractDetailEntity.setContractId(contractEntity.getId());
                contractDetailEntity.setSrcSupplementDetailId(detailEntity.getId());
                contractDetailEntity.setSrcSupplementFlag(1);
                contractDetailEntity.setSrcSupplementId(supplementEntity.getId());
                detailList.add(contractDetailEntity);
            }
            this.contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
            HashMap idMap = new HashMap();
            detailList.forEach(cdEntity -> idMap.put(cdEntity.getTid(), cdEntity.getId()));
            detailList.forEach(cdEntity -> {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
            });
            List resultMapList = BeanMapper.mapList(detailList, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            List<Map<String, Object>> ListCodeDate = this.creatCode(treeData, null, null);
            ArrayList<ContractDetailEntity> entities = new ArrayList<ContractDetailEntity>();
            this.treeToList(ListCodeDate, entities);
            this.contractDetailService.saveOrUpdateBatch(entities, entities.size(), false);
        }
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String innerCode, String detailIndex) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (null == ypd.get("treeIndex")) {
                ypd.put("treeIndex", StringUtils.isNotEmpty((CharSequence)detailIndex) ? detailIndex + "." + (i + 1) : Integer.valueOf(i + 1));
            }
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), ypd.get("innerCode").toString(), ypd.get("treeIndex").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<ContractDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((ContractDetailEntity)((Object)BeanMapper.map(ypd, ContractDetailEntity.class)));
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8865\u5145\u534f\u8bae\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

