/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.vo.OddjobRecordVO;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"oddjob"})
public class OddjobController
implements Serializable {
    @Autowired
    IOddjobService oddjobService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OddjobVO> saveOrUpdate(@RequestBody OddjobVO oddjobVO) {
        OddjobVO vo = this.oddjobService.insertOrUpdate(oddjobVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddjobVO> queryDetail(Long id) {
        OddjobVO vo = this.oddjobService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OddjobVO>> queryList(@RequestBody QueryParam param) {
        return this.oddjobService.queryListVOs(param);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddjobVO> vos) {
        return this.oddjobService.deleteByIds(vos);
    }

    @RequestMapping(value={"/oddjobRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OddjobVO>> oddjobRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("bill_code");
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.setSearchText(searchText);
        }
        Long contractId = null;
        Long orgId = null;
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                contractId = Long.valueOf(conditionMap.get("contractId").toString());
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }
        }
        if (null != orgId) {
            queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (null == contractId) {
            return CommonResponse.success((String)"\u67e5\u8be2\u96f6\u5de5\u5217\u8868\u5931\u8d25\uff0c\u5408\u540c\u4e3b\u952e\u4e3a\u5fc5\u4f20\u53c2\u6570\uff01", null);
        }
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        if (projectId != null) {
            queryParam.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        }
        queryParam.getParams().put("settle_flag", new Parameter("eq", (Object)Boolean.FALSE));
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.oddjobService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), OddjobVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/queryDetailAdd"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddjobVO> queryDetailAdd(Long contractId) {
        OddjobVO vo = this.oddjobService.queryDetailAdd(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u67e5\u8be2\u5408\u540c\u8f6c\u5316\u4e3a\u96f6\u5de5\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddjobRecordVO> queryDetailRecord(Long id) {
        OddjobRecordVO vo = this.oddjobService.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8bb0\u5f55\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.oddjobService.excelExport(param, response);
    }
}

