/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SupplementEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISupplementService;
import com.ejianc.business.sub.vo.SupplementRecordVO;
import com.ejianc.business.sub.vo.SupplementVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplement"})
public class SupplementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplementService supplementService;
    @Autowired
    private IContractService contractService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplementVO> saveOrUpdate(@RequestBody SupplementVO supplementVO) {
        SupplementVO vo = this.supplementService.insertOrUpdate(supplementVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplementVO> addConvertByConId(Long contractId) {
        SupplementVO vo = this.supplementService.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplementRecordVO> queryDetailRecord(Long id) {
        SupplementRecordVO vo = this.supplementService.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplementVO> queryDetail(Long id) {
        SupplementVO vo = this.supplementService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplementVO> vos) {
        int i;
        Long[] ids = new Long[vos.size()];
        for (i = 0; i < ids.length; ++i) {
            SupplementEntity entity = (SupplementEntity)((Object)this.supplementService.getById(vos.get(i).getId()));
            ids[i] = entity.getMainContractId();
        }
        this.supplementService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        for (i = 0; i < ids.length; ++i) {
            this.contractService.updateContractIsSupplementFlag(ids[i]);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.supplementService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

