/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleReportService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.ContractDetailVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleOddjobVO;
import com.ejianc.business.sub.vo.SettleOtherVO;
import com.ejianc.business.sub.vo.SettleReportDetailVO;
import com.ejianc.business.sub.vo.SettleReportOddjobVO;
import com.ejianc.business.sub.vo.SettleReportOtherVO;
import com.ejianc.business.sub.vo.SettleReportVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SettleReportServiceImpl")
public class SettleReportServiceImpl
implements ISettleReportService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IPayContractApi payContractApi;

    @Override
    public CommonResponse<SettleReportVO> queryReport(Long contractId, Long settleId, Integer showSum, Integer showThis, Boolean detailHasChildren) {
        if (null == contractId) {
            throw new BusinessException("\u5408\u540c\u4e3b\u952e\u4e3a\u7a7a");
        }
        return CommonResponse.success((Object)this.fullData(contractId, settleId, showSum, showThis, detailHasChildren));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SettleReportVO fullData(Long contractId, Long settleId, Integer showSum, Integer showThis, Boolean detailHasChildren) {
        PubContractSubQueryVO queryVO = new PubContractSubQueryVO();
        SettleReportVO settleReportVO = null;
        SettleVO settleVO = null;
        if (null == settleId) {
            LambdaQueryWrapper settleWrapper = new LambdaQueryWrapper();
            settleWrapper.eq(SettleEntity::getContractId, (Object)contractId);
            settleWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            settleWrapper.orderByDesc(SettleEntity::getSettleDate);
            List settleEntities = this.settleService.list((Wrapper)settleWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)settleEntities)) throw new BusinessException("\u8be5\u5408\u540c\u6ca1\u6709\u65e0\u5bf9\u5e94\u8fc7\u7a0b\u7ed3\u7b97");
            settleVO = this.settleService.queryDetail(((SettleEntity)((Object)settleEntities.get(0))).getId(), false);
        } else {
            settleVO = this.settleService.queryDetail(settleId, false);
        }
        queryVO.setContractId(settleVO.getContractId());
        queryVO.setProjectId(settleVO.getProjectId());
        queryVO.setSettleId(settleVO.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        queryVO.setSettleDate(sdf.format(settleVO.getSettleDate()) + " 23:59:59");
        settleReportVO = (SettleReportVO)BeanMapper.map((Object)settleVO, SettleReportVO.class);
        ContractVO contractVO = this.contractService.queryDetail(contractId, false);
        Map<Long, SettleReportDetailVO> reportDetailVOMap = this.changeToReportVO(settleReportVO, contractVO, settleVO);
        this.dealBeforeSettle(queryVO, settleReportVO, reportDetailVOMap, settleVO);
        this.dealShowSettle(settleReportVO, showSum, showThis, detailHasChildren);
        return settleReportVO;
    }

    private Map<Long, SettleReportDetailVO> changeToReportVO(SettleReportVO settleReportVO, ContractVO contractVO, SettleVO settleVO) {
        LinkedHashMap<Long, SettleReportDetailVO> reportDetailVOMap = new LinkedHashMap<Long, SettleReportDetailVO>();
        settleReportVO.setSettleId(settleVO.getId());
        settleReportVO.setBillCode(settleVO.getBillCode());
        settleReportVO.setSumSettleTaxMny(settleReportVO.getSettleTaxMny().add(settleReportVO.getSumSettleTaxMny()));
        settleReportVO.setSettleDetailList(null);
        settleReportVO.setSettleOddjobList(null);
        settleReportVO.setSettleOtherList(null);
        if (CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            for (ContractDetailVO contractDetailVO : contractVO.getDetailList()) {
                SettleReportDetailVO reportDetailVO = (SettleReportDetailVO)BeanMapper.map((Object)contractDetailVO, SettleReportDetailVO.class);
                reportDetailVO.setContractDetailId(contractDetailVO.getId());
                reportDetailVO.setSourceType(Integer.valueOf(1));
                reportDetailVOMap.put(contractDetailVO.getId(), reportDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleDetailList())) {
            for (Object settleDetailVO : settleVO.getSettleDetailList()) {
                SettleReportDetailVO settleReportDetailVO;
                if (1 == settleDetailVO.getSourceType() && reportDetailVOMap.containsKey(settleDetailVO.getContractDetailId())) {
                    settleReportDetailVO = (SettleReportDetailVO)reportDetailVOMap.get(settleDetailVO.getContractDetailId());
                    settleReportDetailVO.setSettleNum(settleDetailVO.getSettleNum());
                    settleReportDetailVO.setSettleMny(settleDetailVO.getSettleMny());
                    settleReportDetailVO.setSettlePrice(settleReportDetailVO.getPrice());
                    settleReportDetailVO.setSumSettleNum(MathUtil.safeAdd((BigDecimal)settleReportDetailVO.getSumSettleNum(), (BigDecimal)settleDetailVO.getSettleNum()));
                    settleReportDetailVO.setSumSettleMny(MathUtil.safeAdd((BigDecimal)settleReportDetailVO.getSumSettleMny(), (BigDecimal)settleDetailVO.getSettleMny()));
                    settleReportDetailVO.setSourceType(settleDetailVO.getSourceType());
                    continue;
                }
                settleReportDetailVO = (SettleReportDetailVO)BeanMapper.map((Object)settleDetailVO, SettleReportDetailVO.class);
                settleReportDetailVO.setSettlePrice(settleReportDetailVO.getPrice());
                settleReportDetailVO.setSumSettleNum(MathUtil.safeAdd((BigDecimal)settleReportDetailVO.getSumSettleNum(), (BigDecimal)settleDetailVO.getSettleNum()));
                settleReportDetailVO.setSumSettleMny(MathUtil.safeAdd((BigDecimal)settleReportDetailVO.getSumSettleMny(), (BigDecimal)settleDetailVO.getSettleMny()));
                reportDetailVOMap.put(settleDetailVO.getId(), settleReportDetailVO);
            }
        }
        ArrayList<SettleReportOddjobVO> oddjobVOList = new ArrayList<SettleReportOddjobVO>();
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleOddjobList())) {
            for (SettleOddjobVO oddjobVO : settleVO.getSettleOddjobList()) {
                SettleReportOddjobVO reportOddjobVO = (SettleReportOddjobVO)BeanMapper.map((Object)oddjobVO, SettleReportOddjobVO.class);
                reportOddjobVO.setSettleBillCode(settleVO.getBillCode());
                reportOddjobVO.setSettleDate(settleVO.getSettleDate());
                oddjobVOList.add(reportOddjobVO);
            }
        }
        ArrayList<SettleReportOtherVO> otherVOList = new ArrayList<SettleReportOtherVO>();
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleOtherList())) {
            for (SettleOtherVO otherVO : settleVO.getSettleOtherList()) {
                SettleReportOtherVO reportOtherVO = (SettleReportOtherVO)BeanMapper.map((Object)otherVO, SettleReportOtherVO.class);
                reportOtherVO.setSettleBillCode(settleVO.getBillCode());
                reportOtherVO.setSettleDate(settleVO.getSettleDate());
                otherVOList.add(reportOtherVO);
            }
        }
        settleReportVO.setSettleDetailList(reportDetailVOMap.entrySet().stream().map(et -> (SettleReportDetailVO)et.getValue()).collect(Collectors.toList()));
        settleReportVO.setSettleOddjobList(oddjobVOList);
        settleReportVO.setSettleOtherList(otherVOList);
        return reportDetailVOMap;
    }

    private void dealBeforeSettle(PubContractSubQueryVO queryVO, SettleReportVO settleReportVO, Map<Long, SettleReportDetailVO> reportDetailVOMap, SettleVO settleVO) {
        LambdaQueryWrapper settleWrapper = new LambdaQueryWrapper();
        settleWrapper.eq(SettleEntity::getContractId, (Object)settleVO.getContractId());
        settleWrapper.ne(BaseEntity::getId, (Object)settleVO.getId());
        settleWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        settleWrapper.between(SettleEntity::getSettleDate, (Object)"1990-12-31 00:00:00", (Object)settleVO.getSettleDate());
        List settleEntities = this.settleService.list((Wrapper)settleWrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleEntities)) {
            ArrayList<Long> settlePkList = new ArrayList<Long>();
            settlePkList.add(settleVO.getId());
            for (SettleEntity settleEntity : settleEntities) {
                settlePkList.add(settleEntity.getId());
                SettleVO beforeSettleVO = this.settleService.queryDetail(settleEntity.getId(), false);
                if (CollectionUtils.isNotEmpty((Collection)beforeSettleVO.getSettleDetailList())) {
                    for (Object settleDetailVO : beforeSettleVO.getSettleDetailList()) {
                        SettleReportDetailVO settleReportDetailVO;
                        if (1 == settleDetailVO.getSourceType() && reportDetailVOMap.containsKey(settleDetailVO.getContractDetailId())) {
                            settleReportDetailVO = reportDetailVOMap.get(settleDetailVO.getContractDetailId());
                            settleReportDetailVO.setSourceType(settleDetailVO.getSourceType());
                            settleReportDetailVO.setSumSettleNum(MathUtil.safeAdd((BigDecimal)settleReportDetailVO.getSumSettleNum(), (BigDecimal)settleDetailVO.getSettleNum()));
                            settleReportDetailVO.setSumSettleMny(MathUtil.safeAdd((BigDecimal)settleReportDetailVO.getSumSettleMny(), (BigDecimal)settleDetailVO.getSettleMny()));
                            continue;
                        }
                        settleReportDetailVO = (SettleReportDetailVO)BeanMapper.map((Object)settleDetailVO, SettleReportDetailVO.class);
                        settleReportDetailVO.setSettleNum(null);
                        settleReportDetailVO.setSettleMny(null);
                        settleReportDetailVO.setSumSettleNum(MathUtil.safeAdd((BigDecimal)settleReportDetailVO.getSumSettleNum(), (BigDecimal)settleDetailVO.getSettleNum()));
                        settleReportDetailVO.setSumSettleMny(MathUtil.safeAdd((BigDecimal)settleReportDetailVO.getSumSettleMny(), (BigDecimal)settleDetailVO.getSettleMny()));
                        reportDetailVOMap.put(settleDetailVO.getId(), settleReportDetailVO);
                    }
                }
                List oddjobVOList = settleReportVO.getSettleOddjobList();
                if (CollectionUtils.isNotEmpty((Collection)beforeSettleVO.getSettleOddjobList())) {
                    Object settleDetailVO;
                    settleDetailVO = beforeSettleVO.getSettleOddjobList().iterator();
                    while (settleDetailVO.hasNext()) {
                        SettleOddjobVO oddjobVO = (SettleOddjobVO)settleDetailVO.next();
                        SettleReportOddjobVO reportOddjobVO = (SettleReportOddjobVO)BeanMapper.map((Object)oddjobVO, SettleReportOddjobVO.class);
                        reportOddjobVO.setSettleBillCode(beforeSettleVO.getBillCode());
                        reportOddjobVO.setSettleDate(beforeSettleVO.getSettleDate());
                        oddjobVOList.add(reportOddjobVO);
                    }
                }
                Collections.sort(oddjobVOList, new Comparator<SettleReportOddjobVO>(){

                    @Override
                    public int compare(SettleReportOddjobVO u1, SettleReportOddjobVO u2) {
                        if (u1.getSettleDate().compareTo(u2.getSettleDate()) < 0) {
                            return 1;
                        }
                        if (u1.getSettleDate().compareTo(u2.getSettleDate()) > 0) {
                            return -1;
                        }
                        return 0;
                    }
                });
                settleReportVO.setSettleOddjobList(oddjobVOList);
                List otherVOList = settleReportVO.getSettleOtherList();
                if (CollectionUtils.isNotEmpty((Collection)beforeSettleVO.getSettleOtherList())) {
                    for (SettleOtherVO otherVO : beforeSettleVO.getSettleOtherList()) {
                        SettleReportOtherVO reportOtherVO = (SettleReportOtherVO)BeanMapper.map((Object)otherVO, SettleReportOtherVO.class);
                        reportOtherVO.setSettleBillCode(beforeSettleVO.getBillCode());
                        reportOtherVO.setSettleDate(beforeSettleVO.getSettleDate());
                        otherVOList.add(reportOtherVO);
                    }
                }
                Collections.sort(otherVOList, new Comparator<SettleReportOtherVO>(){

                    @Override
                    public int compare(SettleReportOtherVO u1, SettleReportOtherVO u2) {
                        if (u1.getSettleDate().compareTo(u2.getSettleDate()) < 0) {
                            return 1;
                        }
                        if (u1.getSettleDate().compareTo(u2.getSettleDate()) > 0) {
                            return -1;
                        }
                        return 0;
                    }
                });
                settleReportVO.setSettleOtherList(otherVOList);
                settleReportVO.setSettleDetailList(reportDetailVOMap.entrySet().stream().map(et -> (SettleReportDetailVO)et.getValue()).collect(Collectors.toList()));
            }
            queryVO.setSettleIdList(settlePkList);
            CommonResponse payResponse = this.payContractApi.getSubSettlePay(queryVO);
            if (payResponse.isSuccess() && !((Map)payResponse.getData()).isEmpty()) {
                settleReportVO.setPayMny((BigDecimal)((Map)payResponse.getData()).get("thisMny"));
                settleReportVO.setSumPayMny((BigDecimal)((Map)payResponse.getData()).get("sumMny"));
            }
        }
    }

    private void dealShowSettle(SettleReportVO settleReportVO, Integer showSum, Integer showThis, Boolean detailHasChildren) {
        List detailVOList = settleReportVO.getSettleDetailList();
        ArrayList<SettleReportDetailVO> detailVOListCopy = new ArrayList<SettleReportDetailVO>();
        LinkedHashMap<String, SettleReportDetailVO> map = new LinkedHashMap<String, SettleReportDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailVOList)) {
            for (SettleReportDetailVO detailVO : detailVOList) {
                if (0 == showSum && 0 == showThis) {
                    detailVOListCopy.add(detailVO);
                    map.put(detailVO.getTid(), detailVO);
                    continue;
                }
                if (0 == showSum && 1 == showThis) {
                    if (null == detailVO.getSettleMny() || BigDecimal.ZERO.compareTo(detailVO.getSettleMny()) == 0) continue;
                    detailVOListCopy.add(detailVO);
                    map.put(detailVO.getTid(), detailVO);
                    continue;
                }
                if (1 == showSum && 0 == showThis) {
                    if (null == detailVO.getSumSettleMny() || BigDecimal.ZERO.compareTo(detailVO.getSumSettleMny()) == 0) continue;
                    detailVOListCopy.add(detailVO);
                    map.put(detailVO.getTid(), detailVO);
                    continue;
                }
                if (1 != showSum || 1 != showThis || null == detailVO.getSumSettleMny() || BigDecimal.ZERO.compareTo(detailVO.getSumSettleMny()) == 0 || null == detailVO.getSettleMny() || BigDecimal.ZERO.compareTo(detailVO.getSettleMny()) == 0) continue;
                detailVOListCopy.add(detailVO);
                map.put(detailVO.getTid(), detailVO);
            }
        }
        for (SettleReportDetailVO detailVO : detailVOListCopy) {
            this.sumNumToParent(map, detailVO);
        }
        List detailVOS = map.entrySet().stream().map(et -> (SettleReportDetailVO)et.getValue()).collect(Collectors.toList());
        if (detailHasChildren.booleanValue()) {
            settleReportVO.setSettleDetailList(TreeNodeBUtil.buildTree(detailVOS));
        } else {
            settleReportVO.setSettleDetailList(detailVOS);
        }
    }

    private void sumNumToParent(Map<String, SettleReportDetailVO> map, SettleReportDetailVO detailVO) {
        if (StringUtils.isNotBlank((CharSequence)detailVO.getTpid()) && map.containsKey(detailVO.getTpid())) {
            SettleReportDetailVO parentVO = map.get(detailVO.getTpid());
            parentVO.setSumSettleNum(MathUtil.safeAdd((BigDecimal)parentVO.getSumSettleNum(), (BigDecimal)detailVO.getSumSettleNum()));
            this.sumNumToParent(map, parentVO);
        }
    }
}

