/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.SupplementDetailEntity;
import com.ejianc.business.sub.bean.SupplementEntity;
import com.ejianc.business.sub.mapper.SupplementMapper;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISupplementDetailService;
import com.ejianc.business.sub.service.ISupplementService;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SupplementDetailVO;
import com.ejianc.business.sub.vo.SupplementRecordVO;
import com.ejianc.business.sub.vo.SupplementVO;
import com.ejianc.business.sub.vo.comparator.SupplementDetailComparatorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplementService")
public class SupplementServiceImpl
extends BaseServiceImpl<SupplementMapper, SupplementEntity>
implements ISupplementService {
    private static final String SUB_SUPPLEMENT_BILL_CODE = "SUB_SUPPLEMENT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private ISupplementDetailService supplementDetailService;

    @Override
    public SupplementVO addConvertByConId(Long contractId) {
        ContractVO contractVO = this.contractService.queryDetail(contractId, false);
        SupplementVO supplementVO = new SupplementVO();
        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setTaxRate(contractVO.getTaxRate());
        supplementVO.setSupplementFlag(Integer.valueOf(1));
        supplementVO.setContractStatus("2");
        supplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        supplementVO.setMainContractId(contractVO.getId());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setPurchaseOrgId(contractVO.getPurchaseOrgId());
        supplementVO.setPurchaseOrgName(contractVO.getPurchaseOrgName());
        supplementVO.setReplaceSignFlag(contractVO.getReplaceSignFlag());
        return supplementVO;
    }

    @Override
    public SupplementRecordVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        SupplementRecordVO recordVO = new SupplementRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setFinishFlag(contractEntity.getFinishFlag());
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SupplementEntity::getMainContractId, (Object)id);
        lambda.orderByDesc(SupplementEntity::getSignDate);
        List entities = super.list((Wrapper)lambda);
        recordVO.setDetailList(BeanMapper.mapList((Iterable)entities, SupplementRecordVO.class));
        Boolean editFlag = this.contractService.editFlag(id);
        recordVO.setEditFlag(editFlag);
        return recordVO;
    }

    @Override
    public SupplementVO insertOrUpdate(SupplementVO supplementVO) {
        LambdaQueryWrapper lambda;
        if (this.checkFinishContract(supplementVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        Object entity = null;
        List entities = null;
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(SupplementEntity::getMainContractId, (Object)supplementVO.getMainContractId());
        if (supplementVO.getId() != null && supplementVO.getId() > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)supplementVO.getId());
        }
        lambdaQuery.ne(SupplementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdaQuery);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(ChangeEntity::getContractId, (Object)supplementVO.getMainContractId());
        lambdachange.ne(ChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = this.changeService.count((Wrapper)lambdachange);
        if (changeNum > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)supplementVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SUB_SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                supplementVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (supplementVO.getId() != null && supplementVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(SupplementEntity::getBillCode, (Object)supplementVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)supplementVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(SupplementEntity::getBillCode, (Object)supplementVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        SupplementEntity supplementEntity = (SupplementEntity)((Object)BeanMapper.map((Object)supplementVO, SupplementEntity.class));
        List<SupplementDetailEntity> beforeDetails = supplementEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == supplementEntity.getId()) {
            for (SupplementDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate((Object)supplementEntity, false);
        List<SupplementDetailEntity> supplementDetailEntities = supplementEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(supplementDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SupplementDetailEntity cdEntity : supplementDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (SupplementDetailEntity cdEntity : supplementDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.supplementDetailService.saveOrUpdateBatch(supplementDetailEntities, supplementDetailEntities.size(), false);
        }
        this.contractService.updateContractIsSupplementFlag(supplementVO.getMainContractId());
        return this.queryDetail(supplementEntity.getId());
    }

    @Override
    public SupplementVO queryDetail(Long id) {
        SupplementEntity supplementEntity = (SupplementEntity)((Object)super.selectById((Serializable)id));
        SupplementVO supplementVO = (SupplementVO)BeanMapper.map((Object)((Object)supplementEntity), SupplementVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        List detailEntityList = this.supplementDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (SupplementDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, SupplementDetailVO.class);
            Collections.sort(resultMapList, new SupplementDetailComparatorVo());
            supplementVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
        }
        return supplementVO;
    }

    private Boolean checkFinishContract(SupplementVO supplementVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)supplementVO.getMainContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(ContractEntity::getFinishFlag, (Object)true);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }
}

