package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 分包完工结算其他表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_finish_other")
public class FinishOtherEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 完工结算ID
     */
    @TableField("finish_id")
    private Long finishId;

    /**
     * 费用类型
     */
    @TableField("type")
    private String type;

    /**
     * 结算金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 结算金额(含税)
     */
    @TableField("tax_money")
    private BigDecimal taxMoney;

    /**
     * 税率
     */
    @TableField("other_tax_rate")
    private BigDecimal otherTaxRate;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;

    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;

    /**
     * 核算对象主键
     */
    @TableField(value="accounting_id")
    private java.lang.Long accountingId; // 核算对象主键

    /**
     * 核算对象名称
     */
    @TableField(value="accounting_name")
    private java.lang.String accountingName; // 核算对象名称

    /**
     * 集团成本科目主键
     */
    @TableField(value="org_subject_id")
    private java.lang.Long orgSubjectId;

    /**
     * 集团核算对象主键
     */
    @TableField(value="org_accounting_id")
    private java.lang.Long orgAccountingId;

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getOtherTaxRate() {
        return otherTaxRate;
    }

    public void setOtherTaxRate(BigDecimal otherTaxRate) {
        this.otherTaxRate = otherTaxRate;
    }

    public Long getFinishId() {
        return finishId;
    }

    public void setFinishId(Long finishId) {
        this.finishId = finishId;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 成本科目主键
     */
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目主键
     */
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    /**
     * 核算对象主键
     */
    public Long getAccountingId() {
        return accountingId;
    }

    /**
     * 核算对象主键
     */
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    /**
     * 核算对象名称
     */
    public String getAccountingName() {
        return accountingName;
    }

    /**
     * 核算对象名称
     */
    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    /**
     * 集团成本科目主键
     */
    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    /**
     * 集团成本科目主键
     */
    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    /**
     * 集团核算对象主键
     */
    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    /**
     * 集团核算对象主键
     */
    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }
}
