package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
/**
 * 分包补充协议实体
 *
 * @author generator
 *
 */
 @TableName("ejc_sub_contract")
public class SupplementEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_type")
    private Long contractType; // 分包类型
    @TableField(value="contract_status")
    private String contractStatus; // 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="customer_id")
    private Long customerId; // 总包企业ID
    @TableField(value="customer_name")
    private String customerName; // 总包企业名称
    @TableField(value="supplier_id")
    private Long supplierId; // 分包企业ID
    @TableField(value="supplier_name")
    private String supplierName; // 分包企业名称
    @TableField(value="sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="base_tax_money")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @TableField(value="base_money")
    private BigDecimal baseMoney; // 初始版本金额
    @TableField(value="before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="pay_scale")
    private BigDecimal payScale; // 合同支付比例
    @TableField(value="purchase_type")
    private String purchaseType; // 采购类型 1-自采，2-集采
    @TableField(value="memo")
    private String memo; // 分包内容
    @TableField(value="finish_flag")
    private Integer finishFlag; // 是否竣工(1:是，0：否)
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="sum_settle_tax_mny")
    private BigDecimal sumSettleTaxMny; // 累计结算金额（含税）
    @TableField(value="sum_settle_mny")
    private BigDecimal sumSettleMny; // 累计结算金额
    @TableField(value="sum_oddjob_settle_tax_mny")
    private BigDecimal sumOddjobSettleTaxMny; // 累计零工结算金额（含税）
    @TableField(value="sum_oddjob_settle_mny")
    private BigDecimal sumOddjobSettleMny; // 累计零工结算金额
    @TableField(value="sum_oddjob_tax_mny")
    private BigDecimal sumOddjobTaxMny; // 累计零工金额（含税）
    @TableField(value="sum_oddjob_mny")
    private BigDecimal sumOddjobMny; // 累计零工金额
    @TableField(value="sum_other_tax_mny")
    private BigDecimal sumOtherTaxMny; // 累计其他结算金额（含税）
    @TableField(value="sum_other_mny")
    private BigDecimal sumOtherMny; // 累计其他结算金额
    @TableField(value="sum_invoice_mny")
    private BigDecimal sumInvoiceMny; // 累计收票金额(不含税)
    @TableField(value="sum_invoice_tax_mny")
    private BigDecimal sumInvoiceTaxMny; // 累计收票金额
    @TableField(value="sum_prepay_mny")
    private BigDecimal sumPrepayMny; // 累计预付款金额
    @TableField(value="sum_pay_mny")
    private BigDecimal sumPayMny; // 累计付款金额
    @TableField(value="sum_offset_mny")
    private BigDecimal sumOffsetMny; // 累计冲抵金额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="purchase_type_name")
    private String purchaseTypeName; // 集采/自采
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    /**
     * 所属组织(采购组织)
     */
    @TableField("purchase_org_id")
    private Long purchaseOrgId;

    /**
     * 所属组织名称(采购组织)
     */
    @TableField("purchase_org_name")
    private String purchaseOrgName;
    @TableField(value="replace_sign_flag")
    private Integer replaceSignFlag; // 是否代签：0-否，1-是

    @TableField(exist=false)
    @SubEntity(serviceName="supplementDetailService",pidName = "contractId")
    private List<SupplementDetailEntity> detailList; // 分包补充协议明细实体
    @TableField(exist=false)
    @SubEntity(serviceName="supplementClauseService",pidName = "contractId")
    private List<SupplementClauseEntity> clauseList; // 分包补充协议条款实体
    @TableField(exist=false)
    @SubEntity(serviceName="supplementStageService",pidName = "contractId")
    private List<SupplementStageEntity> stageList; // 分包补充协议阶段实体

    public Long getPurchaseOrgId() {
        return purchaseOrgId;
    }

    public void setPurchaseOrgId(Long purchaseOrgId) {
        this.purchaseOrgId = purchaseOrgId;
    }

    public String getPurchaseOrgName() {
        return purchaseOrgName;
    }

    public void setPurchaseOrgName(String purchaseOrgName) {
        this.purchaseOrgName = purchaseOrgName;
    }

    public Integer getReplaceSignFlag() {
        return replaceSignFlag;
    }

    public void setReplaceSignFlag(Integer replaceSignFlag) {
        this.replaceSignFlag = replaceSignFlag;
    }

    /**
     * 合同编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 合同编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 分包类型
     */
    public Long getContractType() {
        return contractType;
    }

    /**
     * 分包类型
     */
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 总包企业ID
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 总包企业ID
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 总包企业名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 总包企业名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 分包企业ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 分包企业ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 分包企业名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 分包企业名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 合同金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 税金
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 初始版本金额（含税）
     */
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更中金额（含税）
     */
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    /**
     * 变更中金额
     */
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同支付比例
     */
    public BigDecimal getPayScale() {
        return payScale;
    }

    /**
     * 合同支付比例
     */
    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    /**
     * 采购类型 1-自采，2-集采
     */
    public String getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购类型 1-自采，2-集采
     */
    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 分包内容
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 分包内容
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 是否竣工(1:是，0：否)
     */
    public Integer getFinishFlag() {
        return finishFlag;
    }

    /**
     * 是否竣工(1:是，0：否)
     */
    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 累计结算金额（含税）
     */
    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    /**
     * 累计结算金额（含税）
     */
    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    /**
     * 累计结算金额
     */
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    /**
     * 累计结算金额
     */
    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    /**
     * 累计零工结算金额（含税）
     */
    public BigDecimal getSumOddjobSettleTaxMny() {
        return sumOddjobSettleTaxMny;
    }

    /**
     * 累计零工结算金额（含税）
     */
    public void setSumOddjobSettleTaxMny(BigDecimal sumOddjobSettleTaxMny) {
        this.sumOddjobSettleTaxMny = sumOddjobSettleTaxMny;
    }
    /**
     * 累计零工结算金额
     */
    public BigDecimal getSumOddjobSettleMny() {
        return sumOddjobSettleMny;
    }

    /**
     * 累计零工结算金额
     */
    public void setSumOddjobSettleMny(BigDecimal sumOddjobSettleMny) {
        this.sumOddjobSettleMny = sumOddjobSettleMny;
    }
    /**
     * 累计零工金额（含税）
     */
    public BigDecimal getSumOddjobTaxMny() {
        return sumOddjobTaxMny;
    }

    /**
     * 累计零工金额（含税）
     */
    public void setSumOddjobTaxMny(BigDecimal sumOddjobTaxMny) {
        this.sumOddjobTaxMny = sumOddjobTaxMny;
    }
    /**
     * 累计零工金额
     */
    public BigDecimal getSumOddjobMny() {
        return sumOddjobMny;
    }

    /**
     * 累计零工金额
     */
    public void setSumOddjobMny(BigDecimal sumOddjobMny) {
        this.sumOddjobMny = sumOddjobMny;
    }
    /**
     * 累计其他结算金额（含税）
     */
    public BigDecimal getSumOtherTaxMny() {
        return sumOtherTaxMny;
    }

    /**
     * 累计其他结算金额（含税）
     */
    public void setSumOtherTaxMny(BigDecimal sumOtherTaxMny) {
        this.sumOtherTaxMny = sumOtherTaxMny;
    }
    /**
     * 累计其他结算金额
     */
    public BigDecimal getSumOtherMny() {
        return sumOtherMny;
    }

    /**
     * 累计其他结算金额
     */
    public void setSumOtherMny(BigDecimal sumOtherMny) {
        this.sumOtherMny = sumOtherMny;
    }
    /**
     * 累计收票金额(不含税)
     */
    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    /**
     * 累计收票金额(不含税)
     */
    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }
    /**
     * 累计收票金额
     */
    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    /**
     * 累计收票金额
     */
    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }
    /**
     * 累计预付款金额
     */
    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    /**
     * 累计预付款金额
     */
    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }
    /**
     * 累计付款金额
     */
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    /**
     * 累计付款金额
     */
    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    /**
     * 累计冲抵金额
     */
    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    /**
     * 累计冲抵金额
     */
    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 集采/自采
     */
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    /**
     * 集采/自采
     */
    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public List<SupplementDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SupplementDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<SupplementClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<SupplementClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public List<SupplementStageEntity> getStageList() {
        return stageList;
    }

    public void setStageList(List<SupplementStageEntity> stageList) {
        this.stageList = stageList;
    }
}
