package com.ejianc.business.sub.controller;


import com.ejianc.business.sub.service.ISettleReportService;
import com.ejianc.business.sub.vo.SettleReportDetailVO;
import com.ejianc.business.sub.vo.SettleReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 分包过程结算表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("settleReport")
public class SettleReportController implements Serializable {

    @Autowired
    private ISettleReportService settleReportService;


    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryReport 查询
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleReportVO>
     */
    @RequestMapping(value = "/queryReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleReportVO> queryReport(@RequestParam Long contractId, @RequestParam Long settleId, @RequestParam Integer showSum, @RequestParam Integer showThis) {
        return settleReportService.queryReport(contractId, settleId, showSum, showThis, true);
    }


    @RequestMapping(value = "/excelExport", method = RequestMethod.GET)
    @ResponseBody
    public void excelExport(@RequestParam Long contractId, @RequestParam Long settleId, @RequestParam Integer showSum, @RequestParam Integer showThis, HttpServletResponse response) {
        CommonResponse<SettleReportVO> commonResponse = settleReportService.queryReport(contractId, settleId, showSum, showThis, false);
        if(commonResponse.isSuccess() && commonResponse.getData() != null){
            Map<String, Object> beans = new HashMap<>();
            SettleReportVO settleReportVO = commonResponse.getData();
            if(CollectionUtils.isNotEmpty(settleReportVO.getSettleDetailList())){
                for(SettleReportDetailVO detailVO : settleReportVO.getSettleDetailList()){
                    detailVO.setSourceTypeName((detailVO.getSourceType() != null && detailVO.getSourceType() == 1) ? "合同内" : "合同外");
                }
            }
            List<SettleReportVO> list = new ArrayList<>();
            list.add(settleReportVO);
            beans.put("main", list);
            beans.put("detail", settleReportVO.getSettleDetailList());
            beans.put("oddjob", settleReportVO.getSettleOddjobList());
            beans.put("other", settleReportVO.getSettleOtherList());
            ExcelExport.getInstance().export("settle-report-export.xlsx", beans, response);
        }
    }
}
