package com.ejianc.business.sub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/api/sub/")
public class SubContractApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	IContractService contractService;

	@Autowired
	private ISupplierApi supplierApi;

	@Autowired
	private ICustomerApi customerApi;

	@Autowired
	private ISettleService settleService;

	@Autowired
	private IFinishService finishService;


	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 收票审批通过后更新设备采购合同开票金额等字段
	 * @Param contractId  合同id
	 * @Param invoiceMny、invoiceTaxMny  收票金额
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@PostMapping(value = "afterApproveInvoiceReceive")
	public CommonResponse<JSONObject> afterApproveInvoiceReceive(@RequestParam("contractId") Long contractId, @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny) {
		ContractEntity entity = contractService.selectById(contractId);
		if (null != entity) {
			BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
			BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();
			LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(ContractEntity::getId, contractId);
			updateWrapper.set(ContractEntity::getSumInvoiceMny, sumInvoiceMny.add(invoiceMny));
			updateWrapper.set(ContractEntity::getSumInvoiceTaxMny, sumInvoiceTaxMny.add(invoiceTaxMny));
			boolean flag = contractService.update(updateWrapper);
			if (flag) {
				return CommonResponse.success("更新成功");
			} else {
				return CommonResponse.error("更新异常");
			}
		} else {
			return CommonResponse.error("更新异常!未获取到单据信息");
		}

	}

	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 收票弃审通过后更新设备采购合同开票金额等字段
	 * @Param contractId  合同id
	 * @Param invoiceMny、invoiceTaxMny  收票金额
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@PostMapping(value = "afterRevocationInvoiceReceive")
	public CommonResponse<JSONObject> afterRevocationInvoiceReceive(@RequestParam("contractId") Long contractId, @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny) {
		ContractEntity entity = contractService.selectById(contractId);
		if (null != entity) {
			BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
			BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();

			LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(ContractEntity::getId, contractId);
			updateWrapper.set(ContractEntity::getSumInvoiceMny, sumInvoiceMny.subtract(invoiceMny));
			updateWrapper.set(ContractEntity::getSumInvoiceTaxMny, sumInvoiceTaxMny.subtract(invoiceTaxMny));
			boolean flag = contractService.update(updateWrapper);
			if (flag) {
				return CommonResponse.success("更新成功");
			} else {
				return CommonResponse.error("更新异常");
			}
		} else {
			return CommonResponse.error("更新异常!未获取到单据信息");
		}
	}

	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 合同跳转收票, 根据主键查询合同相关信心
	 * @Param contractId  合同id
	 */
	@GetMapping(value = "getSubContractById")
	public CommonResponse<ContractResVO> getRentContractById(@RequestParam("contractId") Long contractId) {
		ContractEntity ContractEntity = contractService.selectById(contractId);
        ContractResVO rentContractVO = BeanMapper.map(ContractEntity, ContractResVO.class);
		if (null != ContractEntity) {
			CommonResponse<SupplierVO> supplierVOCommonResponse = supplierApi.queryById(ContractEntity.getSupplierId());
			if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                rentContractVO.setSupplierCreditCode(supplierVOCommonResponse.getData().getSocialCreditCode());
			}
			CommonResponse<CustomerVO> customerVOCommonResponse = customerApi.detailById(ContractEntity.getCustomerId());
			if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                rentContractVO.setCustomerCreditCode(customerVOCommonResponse.getData().getSocialCreditCode());

			}
		} else {
			return CommonResponse.error("获取合同信息失败!");
		}

		return CommonResponse.success("获取合同信息成功",rentContractVO);
	}

	/**
	 * 查分包合同结算
	 *
	 * @param projectId
	 * @param lastDay
	 * @return
	 */
	@RequestMapping(value = "/getMonthSubMny", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<SubProjectReportVo>> getMonthSubMny(@RequestParam(value = "projectId") Long projectId,
																   @RequestParam(value = "lastDay") Integer lastDay) {
		return CommonResponse.success("查询列表数据成功！", contractService.getMonthSubMny(projectId, lastDay));
	}
	/**
	 * 查分包合同数量，金额，结算金额
	 *
	 * @param projectId
	 * @return
	 */
	@RequestMapping(value = "/getSubContract", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubProjectReportVo> getSubContract(@RequestParam(value = "projectId") Long projectId) {
		return CommonResponse.success("查询列表数据成功！", contractService.getSubContract(projectId));
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/5/13 根据 项目ids查询累计结算(含税)  包括过程结算和完工结算
	 * @Description querySubSettleMoneyByTypeAndProjectIds
	 * @Param [param]
	 * projectId 该类项目id集合
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
	 */
	@RequestMapping(value = "/querySubSettleMoneyByTypeAndProjectIds", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<BigDecimal> querySubSettleMoneyByTypeAndProjectIds(@RequestBody QueryParam param){
		List<FinishEntity> finishEntities = finishService.queryList(param,false);
		/** 项目不能为空  */
		if(param.getParams().get("projectId") == null){
			param.getParams().put("projectId",new Parameter(QueryParam.NE,null));
		}
		List<SettleEntity> settleEntityList = settleService.queryList(param,false);
		BigDecimal res = BigDecimal.ZERO;
		if(ListUtil.isNotEmpty(settleEntityList)){
			for (int i = 0; i < settleEntityList.size(); i++) {
				SettleEntity entity = settleEntityList.get(i);
				if(entity.getSettleTaxMny()!=null){
					res = res.add(entity.getSettleTaxMny());
				}
			}
		}
		if(ListUtil.isNotEmpty(finishEntities)){
			for (int i = 0; i < finishEntities.size(); i++) {
				FinishEntity entity = finishEntities.get(i);
				if(entity.getShouldPayTaxMny()!=null){
					res = res.add(entity.getShouldPayTaxMny());
				}
			}
		}
		logger.info("根据 项目ids查询累计结算(含税)  包括过程结算和完工结算 参数：{}，SettleEntity：{}，FinishEntity，{},res:{}",
				JSONObject.toJSONString(param),
				JSONObject.toJSONString(settleEntityList),
				JSONObject.toJSONString(finishEntities),
				JSONObject.toJSONString(res)
		);
		return CommonResponse.success(res);
	}
}


