package com.ejianc.business.sub.mapper;

import com.ejianc.business.sub.bean.SettleDetailEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * <p>
 * 分包过程结算明细表 Mapper 接口
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Mapper
public interface SettleDetailMapper extends BaseCrudMapper<SettleDetailEntity> {
	@Select("SELECT sum( sum_settle_num) AS sum_settle_num, sum( sum_settle_mny ) AS sum_settle_mny, sum( sum_settle_taxmny ) AS sum_settle_taxmny, sum( year_settle_num ) AS year_settle_num, sum( year_settle_mny ) AS year_settle_mny, sum( year_settle_tax_mny ) AS year_settle_tax_mny FROM( SELECT IFNULL( b.settle_num, 0 ) AS sum_settle_num, IFNULL( b.settle_mny, 0 ) AS sum_settle_mny, IFNULL( b.settle_tax_mny, 0 ) AS sum_settle_taxmny, IFNULL( CASE WHEN date_format( a.settle_date, '%Y' )= #{year} THEN b.settle_num ELSE 0 END, 0 ) AS year_settle_num, IFNULL( CASE WHEN date_format( a.settle_date, '%Y' )= #{year} THEN b.settle_mny ELSE 0 END, 0 ) AS year_settle_mny, IFNULL( CASE WHEN date_format( a.settle_date, '%Y' )= #{year} THEN b.settle_tax_mny ELSE 0 END, 0 ) AS year_settle_tax_mny FROM ejc_sub_settle a LEFT JOIN ejc_sub_settle_detail b ON a.id = b.settle_id WHERE a.dr = 0 AND a.bill_state IN ( '1', '3' ) AND a.contract_id = #{contractId} AND b.CODE = #{code} AND b.NAME = #{name} AND a.org_Id = #{orgId} AND a.tenant_Id = #{tenantId} and a.bill_Code != #{billCode} ) a" )
	SettleDetailEntity getSettleDetailEntityByContractYear(@Param("contractId")long contractId,@Param("year")String year,@Param("orgId")long orgId,@Param("tenantId")long tenantId,@Param("code")String code,@Param("name")String name ,@Param("billCode")String billCode);
}
