package com.ejianc.business.sub.service.impl;

import com.ejianc.business.sub.bean.SettleDetailEntity;
import com.ejianc.business.sub.mapper.SettleDetailMapper;
import com.ejianc.business.sub.service.ISettleDetailService;
import com.ejianc.business.sub.vo.SettleDetailVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 分包过程结算明细表 服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("SettleDetailServiceImpl")
public class SettleDetailServiceImpl extends BaseServiceImpl<SettleDetailMapper, SettleDetailEntity> implements ISettleDetailService {
	@Autowired
	private SettleDetailMapper settleDetailMapper;
	@Override
	public SettleDetailEntity getSettleDetailEntityByContractYear(SettleVO settleVO,SettleDetailVO settleDetailVO) {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
		 Calendar year = Calendar.getInstance();
		 year.setTime(settleVO.getSettleDate());
		 int yearVal = year.get(Calendar.YEAR);
		 year.clear();
		 year.set(Calendar.YEAR, yearVal);
		 String yearStr=simpleDateFormat.format(year.getTime());
		 Long tenantId = InvocationInfoProxy.getTenantid();
		 Long contractId=settleVO.getContractId();
		 SettleDetailEntity settleDetailEntity=settleDetailMapper.getSettleDetailEntityByContractYear(contractId,yearStr,settleVO.getOrgId(),tenantId,settleDetailVO.getCode(),settleDetailVO.getName(),settleVO.getBillCode());
		return settleDetailEntity;
	}

}
