package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 分包合同明细表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_contract_detail")
public class ContractDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 序号
     */
    @TableField("tree_index")
    private String treeIndex;

    /**
     * 清单编码
     */
    @TableField("code")
    private String code;

    /**
     * 清单名称
     */
    @TableField("name")
    private String name;

    /**
     * 计量单位
     */
    @TableField("unit")
    private String unit;

    /**
     * 工程量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 综合单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 合价
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 含税合价
     */
    @TableField("tax_money")
    private BigDecimal taxMoney;

    /**
     * 含税单价
     */
    @TableField("tax_price")
    private BigDecimal taxPrice;

    /**
     * 税率
     */
    @TableField("detail_tax_rate")
    private BigDecimal detailTaxRate;

    /**
     * 税额
     */
    @TableField("detail_tax")
    private BigDecimal detailTax;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 父ID
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 是否末级
     */
    @TableField("leaf_flag")
    private Boolean leafFlag;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更子表主键
     */
    @TableField("src_bid")
    private Long srcBid;

    /**
     * 变更类型
     */
    @TableField("change_type")
    private Integer changeType;
    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;


    /**
     * 核算对象主键
     */
    @TableField(value="accounting_id")
    private java.lang.Long accountingId; // 核算对象主键

    /**
     * 核算对象名称
     */
    @TableField(value="accounting_name")
    private java.lang.String accountingName; // 核算对象名称

    /**
     * 集团成本科目主键
     */
    @TableField(value="org_subject_id")
    private java.lang.Long orgSubjectId;

    /**
     * 集团核算对象主键
     */
    @TableField(value="org_accounting_id")
    private java.lang.Long orgAccountingId;

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    @TableField(value="src_supplement_flag")
    private Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private Long srcSupplementDetailId; // 来源补充协议明细ID
    
    
    public Long getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}

	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}

	public java.lang.Long getAccountingId() {
		return accountingId;
	}

	public void setAccountingId(java.lang.Long accountingId) {
		this.accountingId = accountingId;
	}

	public java.lang.String getAccountingName() {
		return accountingName;
	}

	public void setAccountingName(java.lang.String accountingName) {
		this.accountingName = accountingName;
	}

	public java.lang.Long getOrgSubjectId() {
		return orgSubjectId;
	}

	public void setOrgSubjectId(java.lang.Long orgSubjectId) {
		this.orgSubjectId = orgSubjectId;
	}

	public java.lang.Long getOrgAccountingId() {
		return orgAccountingId;
	}

	public void setOrgAccountingId(java.lang.Long orgAccountingId) {
		this.orgAccountingId = orgAccountingId;
	}

	public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }


    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getSrcBid() {
        return srcBid;
    }

    public void setSrcBid(Long srcBid) {
        this.srcBid = srcBid;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }
}
