package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.vo.RentContractPayVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.enums.PurchaseTypeEnum;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.IRecordService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.ContractDetailVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleDetailVO;
import com.ejianc.business.sub.vo.SettleRecordDetailVO;
import com.ejianc.business.sub.vo.SettleRecordVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author zhangwx
 * @Date 2020/5/27
 * @Description ContractController
 */

@Controller
@RequestMapping("contract")
public class ContractController implements Serializable {

    private static final long serialVersionUID = 1L;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    IContractService contractService;

    @Autowired
    IRecordService recordService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IInvoiceApi invoiceApi;

    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IFinishService finishService;


    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @param contractVO
     * @Return com.ejianc.framework.core.response.CommonResponse<ContractVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO contractVO) {
        ContractVO vo = contractService.insertOrUpdate(contractVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<ContractVO>
     */
    @RequestMapping(value = "/queryRecordDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryRecordDetail(Long id) {
        ContractVO vo = recordService.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<ContractVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = contractService.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * 根据主键ID查询收票记录详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryInvoiceDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRecordVO> queryInvoiceDetail(@RequestParam Long id) {
        ContractEntity entity = contractService.selectById(id);
        CommonResponse<InvoiceReceiveRecordVO>  res = invoiceApi.getInvoiceReceiveRecord(id);
        if(!res.isSuccess() || !res.isSuccess()) {
            throw new BusinessException("获取收票信息失败！");
        }
        InvoiceReceiveRecordVO vo = res.getData();
        if(null!=vo){
            vo.setContractTaxMny(entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny());
        }
        return CommonResponse.success(vo);
    }

    /**
     * 根据主键ID查询付款记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryPayDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractPayVO> queryPayDetail(@RequestParam Long id) {
        ContractEntity entity = contractService.selectById(id);
        RentContractPayVO rentContractPayVO = BeanMapper.map(entity, RentContractPayVO.class);
        CommonResponse<SumPayMnyVO> sumPayMnyVOList = payContractApi.getSumPayMnyVOList(id, null);
        if(!sumPayMnyVOList.isSuccess() || !sumPayMnyVOList.isSuccess()) {
            throw new BusinessException("获取付款信息失败！");
        }
        BigDecimal sumPayMny = sumPayMnyVOList.getData().getSumPayMny()==null?BigDecimal.ZERO:sumPayMnyVOList.getData().getSumPayMny();
        rentContractPayVO.setContractId(sumPayMnyVOList.getData().getContractId());
        rentContractPayVO.setSumPayMny(sumPayMny);
        rentContractPayVO.setContractVOList(sumPayMnyVOList.getData().getContractVOList());

        //获取累计结算
        BigDecimal sumSettlementTaxMny = null;
        if(entity.getFinishFlag()){//完工时，肯定为自采合同，直接取合同上得结算金额作为累计结算
            sumSettlementTaxMny = entity.getSumSettleTaxMny();
        }else{//未完工时，取过程结算上的结算金额汇总
            SettleRecordVO settlementRecordVO = settleService.queryDetailRecord(id);
            sumSettlementTaxMny = settlementRecordVO.getSumSettleTaxMny()==null?BigDecimal.ZERO:settlementRecordVO.getSumSettleTaxMny();
        }

        rentContractPayVO.setSumSettlementTaxMny(sumSettlementTaxMny);
        //获取累计收票
        CommonResponse<InvoiceReceiveRecordVO>  res = invoiceApi.getInvoiceReceiveRecord(id);
        if(!res.isSuccess() || !res.isSuccess()) {
            throw new BusinessException("获取收票信息失败！");
        }
        rentContractPayVO.setSumInvoiceTaxMny(res.getData().getInvoiceTaxMny());

        //累计未付
        rentContractPayVO.setSumUnPayMny(sumSettlementTaxMny.subtract(sumPayMny));
        return CommonResponse.success(rentContractPayVO);
    }
    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {
        return contractService.queryListVOs(param);
    }

    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("purchaseOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag",new Parameter("eq",0));

       /* ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            return CommonResponse.success("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> allOrgIds = new ArrayList<>();
        List<Long> parentOrgIds = new ArrayList<>();
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        allOrgIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        allOrgIds.remove(orgId);
        allOrgIds.addAll(parentOrgIds);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, allOrgIds));
        c1.getComplexParams().add(c2);

        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            List<Integer> billstate = new ArrayList<>();
            billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.公司集采.getCode()));
            c3.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
            c1.getComplexParams().add(c3);
        }*/
        param.getComplexParams().add(getPageQueryParam(null));
        IPage<ContractEntity> pageData= contractService.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = contractService.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }



    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> Ids) {
        return   contractService.deleteByIds(Ids);
    }

    /**
     * 查询指定组织本下的所有项目信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/contractRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> contractRef(
                @RequestParam(defaultValue = "1") Integer pageNumber,
                @RequestParam(defaultValue = "10") Integer pageSize,
                @RequestParam(value = "condition", required = false) String condition,
                @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("purchaseOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        queryParam.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("supplement_flag",new Parameter("eq",0));
        // 生效单据
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        Long orgId = null;
        String type = null;
        if(StringUtils.isNotBlank(condition)) {
            logger.debug("condition is " + condition);
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if(null != conditionMap.get("type")) {
                type = conditionMap.get("type").toString();
            }
            /** 根据项目过滤 */
            if(null != conditionMap.get("projectId")) {
                Long projectId =  Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        if(type != null && "pay".equals(type)){
            // 付款申请特供版
            queryParam.getComplexParams().add(getComplexParamForPay(orgId));
        } else {
            queryParam.getComplexParams().add(getPageQueryParam(null));
            List<Integer> billStateList = new ArrayList<>();
            logger.debug("type is " + type);
            if(type != null && "finish".equals(type)){
                // 完工结算特供版
                queryParam.getParams().put("purchase_type", new Parameter(QueryParam.NE, PurchaseTypeEnum.公司集采.getCode()));
            }

            if(type == null || !"receive".equals(type) && !"settleReport".equals(type)){
                queryParam.getParams().put("finish_flag", new Parameter(QueryParam.NE, Boolean.TRUE));
            }
        }
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<ContractEntity> pageData = contractService.queryPage(queryParam,false);
        IPage<ContractVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }



    /**
     * 合同状态修改
     *
     * @param contractVO
     * @return
     */
    @RequestMapping(value = "/changeState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ContractVO contractVO) {
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ContractEntity::getId,contractVO.getId());
        updateWrapper.set(ContractEntity::getContractStatus, contractVO.getContractStatus());
        contractService.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * 合同明细参照
     *
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/refContractDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractDetailVO>> refContractDetail(@RequestParam(value = "contractId")Long contractId) {
        return CommonResponse.success("查询清单参照成功！", contractService.refContractDetail(contractId));
    }

    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("purchaseOrgName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        queryParam.getParams().put("supplement_flag",new Parameter("eq",0));
        queryParam.getComplexParams().add(getPageQueryParam(null));
        IPage<ContractEntity> pageData= contractService.queryPage(queryParam,false);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<ContractVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&& CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), ContractVO.class);
        }
        list.forEach(vo -> {
            if("1".equals(vo.getContractStatus())){
                vo.setContractStatus("未签订");
            }else if("2".equals(vo.getContractStatus())){
                vo.setContractStatus("履约中");
            }else if("3".equals(vo.getContractStatus())){
                vo.setContractStatus("已封账");
            }
            vo.setPurchaseType(PurchaseTypeEnum.项目自采.getCode().equals(vo.getPurchaseType())?"自采":"集采");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", list);
        ExcelExport.getInstance().export("subContract-export.xlsx", beans, response);
    }
    /**
     * 导出清单结算明细
     *
     * @return
     */
    @PostMapping("/excelListDownload")
    public void settleListExcelDownload(HttpServletResponse response, @RequestBody ContractVO contractVO) {
        CommonResponse<SumPayMnyVO> sumPayMnyVOList = payContractApi.getSumPayMnyVOList(contractVO.getId(), null);
        if(!sumPayMnyVOList.isSuccess() || !sumPayMnyVOList.isSuccess()) {
            throw new BusinessException("获取付款信息失败！");
        };
        Map<String, Object> beans = new HashMap<>();
        List<PayContractVO> list=sumPayMnyVOList.getData().getContractVOList();
        list.forEach(vo->{
        	Long freeType=vo.getFeeType();
        	if(freeType==1) {
        		vo.setFeeTypeName("预付款");
        	}else if (freeType==2) {
        		vo.setFeeTypeName("进度款");
        	}else if (freeType==3) {
        		vo.setFeeTypeName("其他");
        	}
        	if(vo.getBillState()==3) {
        		vo.setBillStateName("审核通过");
        	}else if(vo.getBillState()==1) {
        		vo.setBillStateName("已提交");
        	}
        });
        beans.put("records",list );
        ExcelExport.getInstance().export("contract-pay-list-export.xlsx", beans, response);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if(null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("purchase_org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        if(CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.公司集采.getCode()));
            c3.getParams().put("purchase_org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            c1.getComplexParams().add(c3);
        }
        // 自采代签 上级已生效单据
        if(CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c4 = new ComplexParam();
            c4.setLogic(ComplexParam.OR);
            c4.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.项目自采.getCode()));
            c4.getParams().put("replace_sign_flag", new Parameter(QueryParam.EQ, 1));
            c4.getParams().put("purchase_org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c4.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            c1.getComplexParams().add(c4);
        }
        // 自采 本下单据
        if(CollectionUtils.isNotEmpty(childIds)) {
            ComplexParam c5 = new ComplexParam();
            c5.setLogic(ComplexParam.OR);
            c5.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.项目自采.getCode()));
            c5.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
            c1.getComplexParams().add(c5);
        }
        return c1;
    }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contract-detail-import.xlsx", "分包合同清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return contractService.excelImport(request,response);
    }

    /**
     * 根据分包供应商主键查询分包合同
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryListBySupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractEntity>> queryListBySupplierId(Long id) {
        QueryParam parm = new QueryParam();
        parm.getParams().put("supplement_flag",new Parameter("eq",0));
        parm.getParams().put("supplierId", new Parameter(QueryParam.EQ, id));
        List<ContractEntity> list = contractService.queryList(parm,false);
        return CommonResponse.success("查询详情数据成功！",list);
    }

    /**
     * 传入/登录组织本下自采合同 + 登录组织本上加本下集采合同
     * @param orgId     null默认登录组织
     * @return
     */
    public ComplexParam getComplexParamForPay(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        // 传入/登录组织本下自采合同
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("purchase_type", new Parameter(QueryParam.EQ, "1"));
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        c1.getComplexParams().add(c2);
        // 登录组织本上加本下集采合同
        List<Long> allOrgIds = this.getOrgUpToDownList();
        if(!allOrgIds.isEmpty()){
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, "2"));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, this.getOrgUpToDownList()));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

    /**
     * 获取当前登录组织本上加本下的所有组织ID的集合
     * @return
     */
    public List<Long> getOrgUpToDownList(){
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("查询组织本上加本下信息失败！");
        }
        List<Long> parentIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentIds.remove(orgId);
        childIds.addAll(parentIds);
        return childIds;
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/9/22  查询分包合同总金额和结算总金额
     * @Description getSubContractTotalAmount
     * @Param [projectIds]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @RequestMapping(value = "/getSubContractTotalAmount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getSubContractTotalAmount(@RequestBody Long orgId){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("supplement_flag",new Parameter("eq",0));
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));//租户隔离
//        queryParam.getParams().put("purchaseType",new Parameter(QueryParam.EQ,"1"));//属于项目
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));//单据状态已提交和审批通过
//        if(ListUtil.isNotEmpty(projectIds)){
//            queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
//        }
        queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<ContractEntity> contractEntities = contractService.queryList(queryParam,false);
        queryParam.getParams().remove("supplement_flag");
        List<SettleEntity> settleEntities = settleService.queryList(queryParam,false);
        queryParam.getParams().remove("purchaseType");
        List<FinishEntity> finishEntities = finishService.queryList(queryParam,false);

        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        if(ListUtil.isNotEmpty(contractEntities)){
            for (ContractEntity c:contractEntities ){
                if(c.getContractTaxMny()!=null){
                    contract = MathUtil.safeAdd(contract, c.getContractTaxMny());
                }
            }
        }
        if(ListUtil.isNotEmpty(settleEntities)){
            for (SettleEntity c:settleEntities ){
                if(c.getContractTaxMny()!=null){
                    settle = MathUtil.safeAdd(settle, c.getSettleTaxMny());
                }
            }
        }
        if(ListUtil.isNotEmpty(finishEntities)){
            for (int i = 0; i < finishEntities.size(); i++) {
                FinishEntity entity = finishEntities.get(i);
                if(entity.getShouldPayTaxMny()!=null){
                    settle = MathUtil.safeAdd(settle, entity.getSettleTaxMny());
                }
            }
        }
        JSONObject back = new JSONObject();
        back.put("contract",contract);
        back.put("settle",settle);
        return CommonResponse.success(back);
    }

    /**
     * 统计匹配条件的（属于项目的）物资合同含税现合同金额总值(单位：万元）
     *
     * @param param
     *      projectIds: 指定所属的项目的id列表
     * @return
     */
    @PostMapping(value = "/analysisContract")
    @ResponseBody
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        QueryParam queryParam = new QueryParam();
        //查询本租户下的
        queryParam.getParams().put("supplement_flag",new Parameter("eq",0));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        //属于项目
        queryParam.getParams().put("purchaseType", new Parameter(QueryParam.EQ, 1));
        //已审批生效的
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        //在指定项目范围内的
        if(null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((List<Long>)param.get("projectIds"))) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, param.get("projectIds")));
        }
        Map<String, Object> result = contractService.countContractAmount(queryParam);
        String dataStr = null != result.get("contractTaxMny") ? result.get("contractTaxMny").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);

        return CommonResponse.success(total.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP));
    }

    /**
     * 该合同是否可以编辑
     * @param id
     * @return
     */
    @RequestMapping(value = "/editFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> editFlag(Long id) {
        return CommonResponse.success("查询来源成功！",contractService.editFlag(id));
    }
}
