package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sub.utils.NCUtil;
import com.ejianc.business.sub.utils.NCVoucherAssidVO;
import com.ejianc.business.sub.utils.NCVoucherDetailVO;
import com.ejianc.business.sub.utils.NCVoucherVO;
import com.ejianc.business.sub.vo.nc.NCUtilVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *  NC接口直接调用，解决前端不能跨域的问题
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("ncUtil")
public class NCUtilController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private NCUtil ncUtil;

    /**
     * @param sourceId  记录生成的凭证主键
     * @Description 联查凭证
     */
    @RequestMapping(value = "/viewVoucher", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<NCVoucherVO>> viewVoucher(@RequestParam(value="sourceId", required=false) String sourceId) {
        List<NCVoucherVO> list = new ArrayList<>();
        if(StringUtils.isEmpty(sourceId)){
            list.add(new NCVoucherVO());
            return CommonResponse.success(list);
        }
        String[] split = sourceId.split(",");
        for (String pk_bill : split) {
            JSONObject param = new JSONObject();
            param.put("busitype", "queryVoucher");
            param.put("pk_bill", pk_bill);
            JSONObject jsonObject = ncUtil.postByJson2(param.toJSONString());
            NCVoucherVO vo = BeanMapper.map(jsonObject, NCVoucherVO.class);
            // 多个辅助核算项逗号拼接
            if(CollectionUtils.isNotEmpty(vo.getDetail())){
                List<NCVoucherDetailVO> detail = vo.getDetail();
                for(NCVoucherDetailVO data : detail){
                    if(CollectionUtils.isNotEmpty(data.getAssid())){
                        StringBuffer checkValue = new StringBuffer();
                        for(NCVoucherAssidVO assid : data.getAssid()){
                            if(checkValue.length() > 0) checkValue.append("，");
                            checkValue.append(assid.getChecktype() + "：" + assid.getCheckvalue());
                        }
                        data.setCheckvalue(String.valueOf(checkValue));
                    }
                }
            }
            list.add(vo);
        }
        return CommonResponse.success(list);
    }

    /**
     * NC撤回推送消息
     * @param vos
     * @return
     */
    @RequestMapping(value = "/notice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> notice(@RequestBody List<NCUtilVO> vos) {
        logger.info("--->> NC撤回推送消息{}" + JSONObject.toJSONString(vos));
        // 信息发送类型
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
//        messageType.add("weChat");
        for(NCUtilVO vo : vos){
            // 根据单据主键和单据类型查询对应单据
            if(StringUtils.isEmpty(vo.getDef12()) || StringUtils.isEmpty(vo.getDef21())){
                continue;
            }
            JSONObject json = ncUtil.queryBillDetail(vo.getDef12(), vo.getDef21());

            // 获取制单人主键
            String createUserId = null;
            if(json.containsKey("createUserCode")){
                createUserId = ncUtil.getCreateUserId(json.getString("createUserCode"));
            }
            if(StringUtils.isEmpty(createUserId)){
                continue;
            }
            List<String> sender = Arrays.asList(createUserId);

            String billTypeName = ncUtil.getBillTypeName(vo.getDef21());
            StringBuffer str = new StringBuffer();
            str.append("您的单据【");
            str.append(billTypeName);
            str.append("_");
            str.append(json.getString("billCode"));
            str.append("】已从财务撤回，请联系管理员弃审。");

            String subject = str.toString();
//            String formurl = baseHost+"sdbj-progress-frontend/#/queryProgress?orgId=" + year.getOrgId();
//            String mobileUrl = baseHost+"sdbj-progress-mobile/#/kanban?orgId=" + year.getOrgId() + "&userid={userid}";
            String content = null;
            if(StringUtils.isNotEmpty(vo.getDef20())){
                String url = vo.getDef20();
                url = url.substring(url.lastIndexOf("targeturl=") + 10, url.length());
                try {
                    url = URLDecoder.decode(url, "utf-8");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                content = subject + "<a href=" + '"' + url + '"' + ">前往点击</a>";
            }
            ncUtil.sendMsg(messageType, sender, "notice", subject, content, null);
        }
        return CommonResponse.success("消息发送成功", true);
    }

}
