package com.ejianc.business.sub.controller;


import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.ParamUtil;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.SettleDetailEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.ISettleDetailService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.NCUtil;
import com.ejianc.business.sub.vo.ContractDetailExportVo;
import com.ejianc.business.sub.vo.ContractDetailVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleDetailResultVO;
import com.ejianc.business.sub.vo.SettleDetailVO;
import com.ejianc.business.sub.vo.SettleRecordDetailVO;
import com.ejianc.business.sub.vo.SettleRecordVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.business.sub.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * <p>
 * 分包过程结算表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("settle")
public class SettleController implements Serializable {

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IFinishService finishService;

    @Autowired
    private IContractService contractService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ISettleDetailService settleDetailService;

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @param settleVO
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO settleVO) {
        SettleVO vo = settleService.insertOrUpdate(settleVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询变更记录详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleVO vo = settleService.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // 是否生成凭证
        NCUtil.voucherParam(param);
        IPage<SettleEntity> pageData= settleService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), SettleVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        return   settleService.deleteByIds(vos);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailRecord 查询记录
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleRecordVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleRecordVO> queryDetailRecord(Long id) {
        SettleRecordVO vo = settleService.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增查询合同转化为过程结算
     * @param contractId
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/queryDetailAdd", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetailAdd(Long contractId) {
        SettleVO vo = settleService.queryDetailAdd(contractId);
        return CommonResponse.success("新增查询合同转化为过程结算成功！",vo);
    }
    /**
     * 根据主键ID,orgId查询累计结算金额，累计冲抵金额,累计付款，累计预付款金额
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/querySumSettlementTaxMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> querySumSettlementTaxMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        SettleVO vo = new SettleVO();
        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(contractId,orgId);
        if(!sumPayMnyVO.isSuccess()) {
            return CommonResponse.success("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        vo.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        // 过程结算
        LambdaQueryWrapper<SettleEntity> lambdachange = Wrappers.<SettleEntity>lambdaQuery();
        lambdachange.eq(SettleEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(SettleEntity::getContractId,contractId);
        lambdachange.eq(SettleEntity::getOrgId,orgId);
        lambdachange.in(SettleEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettleEntity> list = settleService.list(lambdachange);
        // 累计结算金额未统计完工结算的结算差额bug
        BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] alreadySettleMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                alreadySettleMoney[0] = alreadySettleMoney[0].add(e.getSettleTaxMny()==null? BigDecimal.ZERO:e.getSettleTaxMny());
                alreadySettleMoney[1] = alreadySettleMoney[1].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
            });
            // 累计结算金额
            sumSettleTaxMny = alreadySettleMoney[0];
            //累计冲抵金额
            vo.setSumOffsetMny(alreadySettleMoney[1]);
        }
        // 完工结算
        LambdaQueryWrapper<FinishEntity> lambd = Wrappers.<FinishEntity>lambdaQuery();
        lambd.eq(FinishEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambd.eq(FinishEntity::getContractId,contractId);
        lambd.eq(FinishEntity::getOrgId,orgId);
        lambd.in(FinishEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        FinishEntity finish = finishService.getOne(lambd);
        if(finish != null){
            // 累计结算金额 + 完工结算的结算差额
            sumSettleTaxMny = sumSettleTaxMny.add(finish.getShouldPayTaxMny());
        }
        vo.setSumSettleTaxMny(sumSettleTaxMny);

        BigDecimal sumOffsetMnys = vo.getSumOffsetMny()==null?BigDecimal.ZERO:vo.getSumOffsetMny();
        if(vo.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        ContractVO contractVO = contractService.queryDetail(contractId, true);
        vo.setStageList(contractVO.getStageList());
        return CommonResponse.success(vo);
    }

    /**
     * @Author yqls
     * @Date 2020/7/9 分包结算参照
     * @Description purchaseSettlementRef
     * @Param [pageNumber, pageSize, condition, searchText]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.material.vo.PurchaseSettlementVO>>
     */
    @RequestMapping(value = "/subSettlementRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> subSettlementRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null == conditionMap.get("type") || !"settleReport".equals(conditionMap.get("type"))) {
                /** 剩余可申请金额不等于0  */
                ComplexParam c4 = ParamUtil.getOrParam("surplusApplyMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
                queryParam.getComplexParams().add(c4);
            }
        }

//        ComplexParam c5 = ParamUtil.getOrParam("shouldPayTaxMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
//        queryParam.getComplexParams().add(c5);
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        if(StringUtils.isNotBlank(condition)){
            JSONObject con = JSONObject.parseObject(condition);
            if(condition.contains("contractId")){
                queryParam.getParams().put("contractId",new Parameter(QueryParam.EQ,con.getLong("contractId")));
            }
            if(condition.contains("orgId")){
                queryParam.getParams().put("orgId",new Parameter(QueryParam.EQ,con.getLong("orgId")));
            }
            if(condition.contains("supplierId")){
                queryParam.getParams().put("supplierId",new Parameter(QueryParam.EQ,con.getLong("supplierId")));
            }
        }
        JSONObject page = settleService.querySubSettleVOList(queryParam,false);
        return CommonResponse.success("参照查询成功！", page);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        // 是否生成凭证
        NCUtil.voucherParam(param);
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<SettleEntity> pageData= settleService.queryPage(param,false);
        List<SettleVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), SettleVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    /**
     * @Author zhangwx
     * @Date 2020/12/24
     * @Description pushCost关联保存
     * @param settleVO
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO settleVO) {
        return settleService.pushCost(settleVO);
    }

    /*
     *
     * @description: 参数校验
     * @author: 曹鹏辉
     * @date: 2021/5/19 15:51
     * @param: purchaseType 采购类型
     * @param: contractTaxMny 分包合同金额
     * @param: sumSettleMentTaxMny 累计含本期结算金额 (合同已生效的结算金额+当前结算单金额)
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.ParamsCheckVO>
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType
            , @RequestParam(value = "sumSettleMentTaxMny") BigDecimal sumSettleMentTaxMny
            , @RequestParam(value = "contractTaxMny") BigDecimal contractTaxMny) {

        return CommonResponse.success("参数校验成功！", settleService.checkParams(purchaseType, sumSettleMentTaxMny, contractTaxMny));
    }

    /**
     * 导出清单结算明细
     *
     * @return
     */
    @PostMapping("/excelDownload")
    public void excelDownload(HttpServletResponse response, @RequestBody SettleDetailVO vo) {
        Map<String, Object> beans = new HashMap<>();
        List<SettleDetailVO> list = settleService.excelDownload(vo);
        beans.put("records", list);
        ExcelExport.getInstance().export("settle-detail-export.xlsx", beans, response);
    }
    
    /**
    * 导出清单结算明细
    *
    * @return
    */
   @PostMapping("/settleExcelDownload")
   public void settleExcelDownload(HttpServletResponse response, @RequestBody SettleDetailVO vo) {
       Map<String, Object> beans = new HashMap<>();
       List<SettleDetailVO> list = settleService.settleExcelDownload(vo);
       beans.put("records", list);
       ExcelExport.getInstance().export("contract-settle-detail-export.xlsx", beans, response);
   }
   
   /**
   * 导出清单结算明细
   *
   * @return
   */
  @PostMapping("/settleListExcelDownload")
  public void settleListExcelDownload(HttpServletResponse response, @RequestBody SettleDetailVO vo) {
      Map<String, Object> beans = new HashMap<>();
      SettleRecordVO settleRecordVO = settleService.queryDetailRecord(vo.getContractId());
      List<SettleRecordDetailVO> list=settleRecordVO.getDetailList();
      beans.put("records", list);
      ExcelExport.getInstance().export("contract-settle-list-export.xlsx", beans, response);
  }

    /**
     * 下载成本科目挂接说明
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDescription", method = RequestMethod.POST)
    @ResponseBody
    public void downloadDescription(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subject-description.xlsx", "成本科目挂接说明");
    }
    
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadContractDetail", method = RequestMethod.POST)
    @ResponseBody
    public void downloadNew(@RequestBody ContractDetailVO vomc, HttpServletResponse response) {
    	QueryParam queryParam = new QueryParam();
    	queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    	queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, vomc.getContractId()));
    	queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);

        List<ContractDetailEntity> listsub = contractDetailService.queryList(queryParam);
        /** 数据隔离 本下 */
        List<ContractDetailExportVo> exportVOS = new ArrayList<>();
        listsub.forEach(vo -> {
        	ContractDetailExportVo exportVO = BeanMapper.map(vo, ContractDetailExportVo.class);
        	exportVO.setSourceType("合同内");
            exportVOS.add(exportVO);
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        String fileName = "settle-import.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }
    
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(String contractId,String projectId,String orgId,HttpServletRequest request, HttpServletResponse response) {
    	//@RequestBody SettleVO settlevo ,
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<SettleDetailVO> successList = new ArrayList<>();
            List<SettleDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 12) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SettleDetailVO settleDetailVO = new SettleDetailVO();
                    String index = String.valueOf((i+1));
                    settleDetailVO.setTreeIndex(index);
//                    if (StringUtils.isBlank(datas.get(0))) {
//                        settleDetailVO.setErrorMessage("物资分类为必填项");
//                    } else if (datas.get(0).length() > 20) {
//                        settleDetailVO.setErrorMessage("物资分类填写长度为0~20字");
//                    } else {
//                        settleDetailVO.setMaterialCategoryName(datas.get(0));
//                    }
                    if (StringUtils.isNotBlank(datas.get(0))) {
                    	settleDetailVO.setCode(datas.get(0));
                    }
                    if (StringUtils.isBlank(datas.get(1))) {
                    	settleDetailVO.setErrorMessage("清单名称为必填项");
                    }else {
                    	settleDetailVO.setName(datas.get(1));
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
//                    	settleDetailVO.setErrorMessage("计量单位为必填项");
                    } else {
                    	settleDetailVO.setUnit(datas.get(2));
                    }
                    
                    if (StringUtils.isBlank(datas.get(3))) {
                    	settleDetailVO.setErrorMessage("税率为必填项");
                    } else if (datas.get(3).contains("%")) {
                    	settleDetailVO.setErrorMessage("税率字段无需添加%号，请重新输入税率！");
                    } else {
                    	try {
                    		settleDetailVO.setDetailTaxRate(new BigDecimal(datas.get(3)));
                    	}catch(Exception e) {
                    		settleDetailVO.setErrorMessage("税率必须为数字");
                    	}
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        try {
                        	settleDetailVO.setSettleNum(new BigDecimal(datas.get(4)));
                            if (settleDetailVO.getSettleNum().longValue() < 0) {
                            	settleDetailVO.setErrorMessage("本期结算量必须大于0");
                            }
                        } catch (Exception e) {
                        	settleDetailVO.setErrorMessage("本期结算量必须为数字");
                        }
                    } else {
                    	settleDetailVO.setErrorMessage("本期结算量为必填项");
                    }

                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                        	settleDetailVO.setTaxPrice(new BigDecimal(datas.get(5)));
//                            if (settleDetailVO.getTaxPrice().doubleValue() < 0) {
////                                settleDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	settleDetailVO.setErrorMessage("综合单价必须为数字");
                        }
                    } else {
                    	settleDetailVO.setTaxPrice(new BigDecimal(0));
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                        	settleDetailVO.setPrice(new BigDecimal(datas.get(6)));
//                            if (settleDetailVO.getPrice().doubleValue() < 0) {
////                                settleDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	settleDetailVO.setErrorMessage("综合单价（无税）必须为数字");
                        }
                    } else {
                    	settleDetailVO.setPrice(new BigDecimal(0));
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                        	settleDetailVO.setSettleMny(new BigDecimal(datas.get(7)));
//                            if (settleDetailVO.getSettleMny().doubleValue() < 0) {
////                                settleDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	settleDetailVO.setErrorMessage("本期结算金额（无税）必须为数字");
                        }
                    } else {
                    	settleDetailVO.setSettleMny(settleDetailVO.getPrice().multiply(settleDetailVO.getSettleNum()));
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                        	settleDetailVO.setSettleTaxMny(new BigDecimal(datas.get(8)));
//                            if (settleDetailVO.getSettleMny().doubleValue() < 0) {
////                                settleDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	settleDetailVO.setErrorMessage("本期结算金额必须为数字");
                        }
                    } else {
                    	settleDetailVO.setSettleTaxMny(settleDetailVO.getTaxPrice().multiply(settleDetailVO.getSettleNum()));
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                        	settleDetailVO.setDetailTax(new BigDecimal(datas.get(9)));
//                            if (settleDetailVO.getSettleMny().doubleValue() < 0) {
////                                settleDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	settleDetailVO.setErrorMessage("税额必须为数字");
                        }
                    } else {
                    	settleDetailVO.setDetailTax(settleDetailVO.getSettleTaxMny().subtract(settleDetailVO.getSettleMny()));
                    }
                    
                    if (StringUtils.isBlank(datas.get(10))) {
                    	settleDetailVO.setErrorMessage("来源类型为必填项");
                    } else if(datas.get(10).equals("合同内")){
                    	settleDetailVO.setSourceType(1);
                    } else if(datas.get(10).equals("合同外")){
                    	settleDetailVO.setSourceType(2);
                    } else {
                    	settleDetailVO.setErrorMessage("请输入正确的来源类型数据");
                    }
                    
//                    if (StringUtils.isBlank(datas.get(11))) {
//                    	settleDetailVO.setErrorMessage("核算对象为必填项");
//                    } else {
//                    	settleDetailVO.setAccountingName(datas.get(11));
//                    	
//                    	QueryParam queryParamcon = new QueryParam();
//                    	queryParamcon.getParams().put("accounting_name", new Parameter(QueryParam.EQ, settleDetailVO.getAccountingName()));
//                    	queryParamcon.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
//                    	queryParamcon.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
//                    	queryParamcon.setPageIndex(0);
//                    	queryParamcon.setPageSize(100000);
//
//                        ContractDetailEntity contractDetail = contractDetailService.queryList(queryParamcon).get(0);
//                    	
//                    	settleDetailVO.setAccountingId(contractDetail.getAccountingId());
//                    }
                    
//                    if (StringUtils.isBlank(datas.get(12))) {
//                    	settleDetailVO.setErrorMessage("成本科目为必填项");
//                    } else {
//                    	settleDetailVO.setSubjectName(datas.get(12));
//                    	
//                    	QueryParam queryParamcons = new QueryParam();
//                    	queryParamcons.getParams().put("subject_name", new Parameter(QueryParam.EQ, settleDetailVO.getSubjectName()));
//                    	queryParamcons.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
//                    	queryParamcons.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
//                    	queryParamcons.setPageIndex(0);
//                    	queryParamcons.setPageSize(100000);
//
//                        ContractDetailEntity contractDetail = contractDetailService.queryList(queryParamcons).get(0);
//                        
//                    	settleDetailVO.setSubjectId(contractDetail.getSubjectId());
//                    }
                    
                    if (StringUtils.isNotBlank(datas.get(11))) {
                    	settleDetailVO.setSubjectName(datas.get(11));
                    }
                    
                    QueryParam queryParamconlist = new QueryParam();
                    queryParamconlist.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
                    queryParamconlist.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
                    queryParamconlist.setPageIndex(0);
                    queryParamconlist.setPageSize(100000);

                    List<ContractDetailEntity> contractDetail = contractDetailService.queryList(queryParamconlist);
                    
                    for(ContractDetailEntity con:contractDetail) {
                    	DecimalFormat numtype = new DecimalFormat("#0.00");
                    	String findrate = numtype.format(con.getDetailTaxRate());
                    	String importrate = numtype.format(settleDetailVO.getDetailTaxRate());
                    	String findprice = numtype.format(con.getTaxPrice());
                    	String importprice = numtype.format(settleDetailVO.getTaxPrice());
                    	
                    	if(con.getCode().equals(settleDetailVO.getCode()) && con.getName().equals(settleDetailVO.getName()) &&
                    			findrate.equals(importrate) && findprice.equals(importprice)) {
                    		if(settleDetailVO.getSourceType().equals(1)) {
                            	settleDetailVO.setContractDetailId(con.getId());//合同明细id
                            }
                    		
//                    		QueryParam queryParamall = new QueryParam();
//                    		queryParamall.getParams().put("contract_id", new Parameter(QueryParam.EQ, con.getContractId()));
//                    		queryParamall.getParams().put("code", new Parameter(QueryParam.EQ, con.getCode()));
//            				queryParamall.getParams().put("name", new Parameter(QueryParam.EQ, con.getName()));
//    						queryParamall.getParams().put("tax_price", new Parameter(QueryParam.EQ, con.getTaxPrice()));
//							queryParamall.getParams().put("detail_tax_rate", new Parameter(QueryParam.EQ, con.getDetailTaxRate()));
//                    		queryParamall.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
//                    		queryParamall.setPageIndex(0);
//                    		queryParamall.setPageSize(100000);
//
//                            List<SettleDetailEntity> settlelist = settleDetailService.queryList(queryParamall);
//                    		
//                            BigDecimal all = new BigDecimal("0");
//                            
//                            for(SettleDetailEntity settle : settlelist) {
//                            	QueryParam queryParammu = new QueryParam();
//                            	queryParammu.getParams().put("id", new Parameter(QueryParam.EQ, settle.getContractId()));
//                            	queryParammu.getParams().put("bill_state",new Parameter(QueryParam.EQ, "3"));
//                            	queryParammu.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
//                            	queryParammu.setPageIndex(0);
//                            	queryParammu.setPageSize(100000);
//                            	
//                            	SettleEntity set = settleService.queryList(queryParammu).get(0);
//                            	if(set != null) {
//                            		all = all.add(settle.getSettleTaxMny());
//                            	}
//                            }
                    		//查询累计完成量
                    		
                    		//----------------------
                    		QueryWrapper<ContractDetailEntity> wrapper = new QueryWrapper<>();
                            wrapper.eq("contract_id", contractId);
//                            wrapper.orderBy(true, true, "tree_index");
                            List<ContractDetailEntity> detailEntityListDb = contractDetailService.list(wrapper);
                            List<ContractDetailEntity> entities = new ArrayList<>();
                            if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
                                detailEntityListDb.forEach(entity -> {
                                    if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                                        entity.setTid(entity.getId().toString());
                                        entity.setTpid(entity.getParentId() != null && entity.getParentId() > 0 ? entity.getParentId().toString() : "");
                                        entities.add(entity);
                                    }
                                });
                            }

                            List<ContractDetailVO> detailVos = BeanMapper.mapList(entities, ContractDetailVO.class);
                            // 排序
                            Collections.sort(detailVos, new ContractDetailComparatorVo());
                            //查询累计完成量
                            List<SettleDetailResultVO> details = settleService.querySettleDetail(Long.parseLong(contractId));
                            if(CollectionUtils.isNotEmpty(details) && CollectionUtils.isNotEmpty(detailVos)){
                                Map<Long, SettleDetailResultVO> map = details.stream().filter(c -> c.getSumFinishNum() != null).collect(Collectors.toMap(SettleDetailResultVO::getContractDetailId, x->x));
                                if(map != null && map.size() > 0){
                                    for (ContractDetailVO cdEntity : detailVos) {
                                        if(!map.containsKey(cdEntity.getId())){
                                            continue;
                                        }
                                        cdEntity.setSumFinishNum(map.get(cdEntity.getId()).getSumFinishNum());
                                        cdEntity.setSumSettleMny(map.get(cdEntity.getId()).getSumSettleMny());
                                        cdEntity.setSumSettleTaxMny(map.get(cdEntity.getId()).getSumSettleTaxMny());
                                    }
                                }
                            }
                            
                            if(detailVos.size()>0) {
                            	for(ContractDetailVO vo : detailVos) {
                            		if(vo.getId().equals(settleDetailVO.getContractDetailId())){
                            			settleDetailVO.setSumFinishNum(vo.getSumFinishNum());//累计完成量
                            		}
                            	}
                            }
                            
                            settleDetailVO.setNum(con.getNum());//工程量
                            settleDetailVO.setParentId(con.getParentId());//父id
                            settleDetailVO.setLeafFlag(con.getLeafFlag());//是否末级
                            settleDetailVO.setContractId(Long.valueOf(contractId));//合同id
                            settleDetailVO.setOrgAccountingId(con.getAccountingId());//集团核算对象主键
                            settleDetailVO.setOrgSubjectId(con.getOrgSubjectId());//集团成本科目主键
                    	}
                    }
                    if(settleDetailVO.getErrorMessage() != null && settleDetailVO.getErrorMessage().length()>1) {
                    	errorList.add(settleDetailVO);
                    }else {
                    	successList.add(settleDetailVO);
                    }
                    
//                    if (StringUtils.isNotBlank(datas.get(11)) && datas.get(11).length() > 50) {
////                        settleDetailVO.setErrorMessage("备注填写长度为0~50字");
//                    } else {
//                    	settleDetailVO.setRemark(datas.get(11));
//                    }
//                    settleDetailVO.setSourceType("import");
                   
//                    if (StringUtils.isNotBlank(datas.get(4))) {
//                    	settleDetailVO.setTaxDetailRate(new BigDecimal(datas.get(4)));
//                    	settleDetailVO.setTaxRate(new BigDecimal(datas.get(4)));
//                    }
//                    if (StringUtils.isNotBlank(datas.get(7))) {
//                    	settleDetailVO.setTaxUnitPrice(new BigDecimal(datas.get(7)));
//                    }
//                    if (StringUtils.isNotBlank(datas.get(8))) {
//                    	settleDetailVO.setTotalAmount(new BigDecimal(datas.get(8)));
//                    	settleDetailVO.setAmount(new BigDecimal(datas.get(8)));
//                    }else {
//                    	settleDetailVO.setTotalAmount(ContractDetailExportVo.getUnitPrice().multiply(ContractDetailExportVo.getInstoreNumber()));
//                    	settleDetailVO.setAmount(ContractDetailExportVo.getUnitPrice().multiply(ContractDetailExportVo.getInstoreNumber()));
//                    }
//                    if (StringUtils.isNotBlank(datas.get(9))) {
//                    	settleDetailVO.setTaxTotalAmount(new BigDecimal(datas.get(9)));
//                    	settleDetailVO.setTaxAmount(new BigDecimal(datas.get(9)));
//                    }else {
//                    	settleDetailVO.setTaxTotalAmount(ContractDetailExportVo.getTaxUnitPrice().multiply(ContractDetailExportVo.getInstoreNumber()));
//                    	settleDetailVO.setTaxAmount(ContractDetailExportVo.getTaxUnitPrice().multiply(ContractDetailExportVo.getInstoreNumber()));
//                    }
//                    if (StringUtils.isNotBlank(datas.get(10))) {
//                    	settleDetailVO.setTaxDetail(new BigDecimal(datas.get(10)));
//                    	settleDetailVO.setTax(new BigDecimal(datas.get(10)));
//                    }else {
//                    	settleDetailVO.setTaxDetail(ContractDetailExportVo.getTaxAmount().subtract(ContractDetailExportVo.getAmount()));
//                    	settleDetailVO.setTax(ContractDetailExportVo.getTaxAmount().subtract(ContractDetailExportVo.getAmount()));
//                    }
//                    if (ContractDetailExportVo.getInstoreNumber() != null && ContractDetailExportVo.getUnitPrice() != null) {
//                        BigDecimal amount = ContractDetailExportVo.getUnitPrice().multiply(ContractDetailExportVo.getInstoreNumber());
//                        ContractDetailExportVo.setAmount(amount);
//                    }


//                    if (StringUtils.isBlank(settleDetailVO.getErrorMessage())) {
//                        MaterialVO materialVO = new MaterialVO();
//                        materialVO.setName(settleDetailVO.getMaterialName());
//                        materialVO.setSpec(settleDetailVO.getMaterialSpec());
////                        materialVO.setUnitName(ContractDetailExportVo.getMaterialUnit());
////                        materialVO.setCategoryName(String.valueOf(datas.get(0)));
//                        CommonResponse<List<MaterialVO>> back = materialApi.queryMaterialFlag(materialVO);
//                        if (back.isSuccess()) {
//                            List<MaterialVO> backVOList = back.getData();
//                            if (backVOList != null && backVOList.size() > 0) {
//                                MaterialVO vo = backVOList.get(0);
//                                ContractDetailExportVo.setMaterialCategoryId(vo.getCategoryId());
//                                ContractDetailExportVo.setMaterialCategoryName(vo.getCategoryName());
//                                ContractDetailExportVo.setMaterialId(vo.getId());
//                                successList.add(ContractDetailExportVo);
//                                continue;
//                            } else {
//                                ContractDetailExportVo.setErrorMessage("未查询到该物料【" + ContractDetailExportVo.getMaterialName() + ContractDetailExportVo.getMaterialSpec() + "】");
//                            }
//                        } else {
//                            ContractDetailExportVo.setErrorMessage("物资档案校验失败");
//                        }
//                        /*
//                        //通过物料分类Code获取物料分类ID
//                        CommonResponse<MaterialCategoryVO> categoryResult = materialApi.queryCategoryByCode(String.valueOf(datas.get(0)));
//                        if (categoryResult.isSuccess()) {
//                            MaterialCategoryVO categoryVO = categoryResult.getData();
//                            if (categoryVO != null) {
//                                ContractDetailExportVo.setMaterialCategoryId(categoryVO.getId());
//                                ContractDetailExportVo.setMaterialCategoryName(categoryVO.getName());
//                                MaterialVO materialVO = new MaterialVO();
//                                materialVO.setName(ContractDetailExportVo.getMaterialName());
//                                materialVO.setSpec(ContractDetailExportVo.getMaterialSpec());
//                                materialVO.setUnitName(ContractDetailExportVo.getMaterialUnit());
//                                materialVO.setCategoryId(categoryVO.getId());
//                                CommonResponse<MaterialVO> back = materialApi.queryExitFlag(materialVO);
//                                if (back.isSuccess()) {
//                                    MaterialVO backVO = back.getData();
//                                    if (backVO != null) {
//                                        ContractDetailExportVo.setMaterialId(backVO.getId());
//                                        successList.add(ContractDetailExportVo);
//                                        continue;
//                                    } else {
//                                        ContractDetailExportVo.setErrorMessage("物资档案不存在");
//                                    }
//                                } else {
//                                    ContractDetailExportVo.setErrorMessage("物资档案校验失败");
//                                }
//                            } else {
//                                ContractDetailExportVo.setErrorMessage("物资分类不存在");
//                            }
//                        } else {
//                            ContractDetailExportVo.setErrorMessage("物资分类不存在");
//                        }
//                        */
//                        ContractDetailExportVo.setId((long) i);
//                        errorList.add(ContractDetailExportVo);
//                    } else {
//                        errorList.add(ContractDetailExportVo);
//                    }
                }
            }
            new TaxCalculateUtil<SettleDetailVO>().calculate(successList);
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}




