package com.ejianc.business.sub.controller.api;

import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName: BlocKanBanApi
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/9/6 15:46
 */
@RestController
@RequestMapping("/api/blocKanBan/")
public class SubBlocKanBanApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private IContractService contractService;

    /**
     * 集团看板查询分包合同总金额和外部供应商
     * @param orgId
     * @param yearFlag 0-今年(默认)，1-全年
     * @return
     */
    @GetMapping(value = "queryExternalSupplierAndMny")
    @ResponseBody
    public CommonResponse<Map<Long, ContractVO>> queryExternalSupplierAndMny(@RequestParam(value = "orgId", required = false) Long orgId
            , @RequestParam(value = "yearFlag") Integer yearFlag) {

        if (orgId == null) {
            Long tenantid = InvocationInfoProxy.getTenantid();
            CommonResponse<OrgVO> orgByTenantId = orgApi.findOrgByTenantId(tenantid);
            orgId = orgByTenantId.getData().getId();
        }

        // 本下组织
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        // 查询合同含税总金额
        List<ContractVO> contractVOS = contractService.queryExternalSupplierAndMny(orgIds, yearFlag);

        // 查询供应商
        List<Long> supplierIdList = contractVOS.stream().map(ContractVO::getSupplierId).collect(Collectors.toList());
        CommonResponse<List<SupplierVO>> response = supplierApi.querySupplierByIds(supplierIdList);
        List<SupplierVO> data = response.getData();
        // 过滤出来 外部供应商
        List<Long> ids = data.stream().filter(vo -> vo.getInsideOrgId() == null).map(SupplierVO::getId).collect(Collectors.toList());

        Map<Long, ContractVO> map = contractVOS.stream().filter(vo -> ids.contains(vo.getSupplierId())).collect(Collectors.toMap(ContractVO::getSupplierId, Function.identity()));

        return CommonResponse.success("查询集团看板分包合同总金额", map);
    }


}
