package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.ChangeDetailEntity;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.SupplementEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.mapper.ChangeMapper;
import com.ejianc.business.sub.service.IChangeDetailService;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISupplementService;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 分包变更表 服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("ChangeServiceImpl")
public class ChangeServiceImpl extends BaseServiceImpl<ChangeMapper, ChangeEntity> implements IChangeService {

    private static final String SUB_CHANGE_BILL_CODE = "SUB_CHANGE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IChangeDetailService changeDetailService;

    @Autowired
    private ISupplementService supplementService;

    @Override
    public ChangeVO insertOrUpdate(ChangeVO changeVO) {
        if(checkFinishContract(changeVO)){
            throw new BusinessException("该合同在相同组织下已经完工，不允许变更！");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ChangeEntity entity = null;
        List<ContractEntity> entitiesc = null;
        List<ChangeEntity> entities = null;

        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<ChangeEntity> lambdachange = Wrappers.<ChangeEntity>lambdaQuery();
        lambdachange.eq(ChangeEntity::getTenantId, tenantId);
        lambdachange.eq(ChangeEntity::getContractId,changeVO.getContractId());
        if(changeVO.getId() != null && changeVO.getId() > 0) {
            lambdachange.ne(ChangeEntity::getId,changeVO.getId());
        }
        lambdachange.ne(ChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<SupplementEntity> lambdaQuery = Wrappers.<SupplementEntity>lambdaQuery();
        lambdaQuery.eq(SupplementEntity::getTenantId, tenantId);
        lambdaQuery.eq(SupplementEntity::getMainContractId, changeVO.getContractId());
        lambdaQuery.ne(SupplementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int supnum = supplementService.count(lambdaQuery);
        if(supnum > 0){
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }

        if(StringUtils.isEmpty(changeVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUB_CHANGE_BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                changeVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(changeVO.getId() != null && changeVO.getId() > 0) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<ChangeEntity> lambda = Wrappers.<ChangeEntity>lambdaQuery();
            lambda.eq(ChangeEntity::getBillCode, changeVO.getBillCode());
            lambda.eq(ChangeEntity::getTenantId, tenantId);
            lambda.ne(ChangeEntity::getContractId,changeVO.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,changeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,changeVO.getContractId()));
            entitiesc = contractService.queryList(queryParam,false);

        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<ChangeEntity> lambda = Wrappers.<ChangeEntity>lambdaQuery();
            lambda.eq(ChangeEntity::getTenantId, tenantId);
            lambda.eq(ChangeEntity::getBillCode, changeVO.getBillCode());
            lambda.ne(ChangeEntity::getContractId,changeVO.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,changeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,changeVO.getContractId()));
            entitiesc = contractService.queryList(queryParam,false);
            //新增即点变更按钮穿透过来，此时ID为合同id
//            changeVO.setMakeTime(new Date());
        }

        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        ChangeEntity changeEntity = BeanMapper.map(changeVO, ChangeEntity.class);
        //保存前清空主键和父主键，重新生成
        List<ChangeDetailEntity> beforeDetails = changeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails) && null == changeEntity.getId()){
            for(ChangeDetailEntity cdEntity : beforeDetails){
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate(changeEntity, false);

        List<ChangeDetailEntity> changeDetailEntities = changeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailEntities)){
            Map<String,Long> idMap=new HashMap<>();
            for(ChangeDetailEntity cdEntity : changeDetailEntities){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(ChangeDetailEntity cdEntity : changeDetailEntities){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            changeDetailService.saveOrUpdateBatch(changeDetailEntities, changeDetailEntities.size(), false);
        }

        saveWriteContract(changeEntity);

        return queryDetail(changeEntity.getId());
    }

    private Boolean checkSameBillCode(ChangeVO changeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ChangeEntity::getBillCode, changeVO.getBillCode());
        lambda.eq(ChangeEntity::getTenantId, tenantId);
        if(null != changeVO.getId() && changeVO.getId() > 0){
            lambda.ne(ChangeEntity::getContractId,changeVO.getContractId());
        }
        Boolean changeCheckFlag = super.list(lambda).size() > 0;

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
        queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,changeVO.getBillCode()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, changeVO.getContractId()));
        Boolean contCheckFlag = contractService.queryList(queryParam,false).size() > 0;

        return changeCheckFlag || contCheckFlag;

    }

    /**
     * 保存回写合同
     * @param changeEntity
     */
    private void saveWriteContract(ChangeEntity changeEntity){
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(ContractEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(ContractEntity::getChangingMny, changeEntity.getContractMny());
        updateWrapper.set(ContractEntity::getChangingTaxMny, changeEntity.getContractTaxMny());
        updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());
        contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        ChangeEntity changeEntity = super.selectById(id);
        ChangeVO changeVO =  BeanMapper.map(changeEntity, ChangeVO.class);
        changeVO.setChangeMny(changeVO.getContractTaxMny().subtract(changeVO.getBeforeChangeTaxMny()));
        if(changeVO.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO)<=0) {
        	changeVO.setChangeMnyScale(BigDecimal.ZERO);
        }else {
        	changeVO.setChangeMnyScale(changeVO.getChangeMny().multiply(new BigDecimal(100)).divide(changeVO.getBeforeChangeTaxMny(),2,BigDecimal.ROUND_HALF_UP));
        }
        
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("changeId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<ChangeDetailEntity> detailEntityList = changeDetailService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(ChangeDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<ChangeDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ChangeDetailVO.class);
            changeVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ChangeVO> vos) {
        ChangeVO changeVo = vos.get(0);
        ChangeEntity entity = super.selectById(changeVo.getId());
        //合同变更只有详情页有删除
        ContractEntity pcentity = contractService.selectById(entity.getContractId());
        //会写合同表
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion()-1);
        pcentity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        pcentity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        contractService.update(pcentity, new QueryWrapper<ContractEntity>().eq("id",pcentity.getId()),false);
        super.removeByIds(vos.stream().map(ChangeVO::getId).collect(Collectors.toList()),false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<IPage<ChangeVO>> queryListVOs(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage<ChangeEntity> page = queryPage(param, false);
        List<ChangeVO> changeVOList = BeanMapper.mapList(page.getRecords(), ChangeVO.class);
        IPage<ChangeVO> changeVOIPage = new Page<>();
        changeVOIPage.setCurrent(page.getCurrent());
        changeVOIPage.setRecords(changeVOList);
        changeVOIPage.setSize(page.getSize());
        changeVOIPage.setTotal(page.getTotal());
        changeVOIPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", changeVOIPage);
    }

    @Override
    public ChangeVO addConvertByConId(Long contractId) {
        ContractVO contractVO = contractService.queryDetail(contractId, false);
        ChangeVO changeVO = BeanMapper.map(contractVO, ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeContractName(contractVO.getContractName());
        changeVO.setBeforeChangeMny(contractVO.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractVO.getContractTaxMny());
        changeVO.setContractId(changeVO.getId());
        changeVO.setChangeVersion(contractVO.getChangeVersion() == null ? 1 : contractVO.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setBaseMny(contractVO.getBaseMny());
        changeVO.setProfessionalScale(contractVO.getProfessionalScale());

        List<ChangeDetailVO> changeDetailList = changeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailVO ->{
                changeDetailVO.setSrcBid(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getPrice());
                changeDetailVO.setBeforeChangeMny(changeDetailVO.getMoney());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setChangeType(null);
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        List<ChangeClauseVO> changeClauseList = changeVO.getClauseList();
        if(CollectionUtils.isNotEmpty(changeClauseList)){
            changeClauseList.forEach(changeClauseVO ->{
                changeClauseVO.setRowState("add");
            });
        }
        List<ChangeStageVO> changeStageVOList = changeVO.getStageList();
        if(CollectionUtils.isNotEmpty(changeStageVOList)){
            changeStageVOList.forEach(changeStageVO ->{
                changeStageVO.setRowState("add");
            });
        }
        return changeVO;
    }

    @Override
    public ChangeRecordVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = contractService.selectById(id);
        ChangeRecordVO changeRecordVO = new ChangeRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        changeRecordVO.setContractId(id);
        changeRecordVO.setContractTaxMny(contractTaxMny);
        changeRecordVO.setBaseTaxMoney(baseTaxMny);
        changeRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        changeRecordVO.setSumChangeMny(contractTaxMny.subtract(baseTaxMny));
        BigDecimal sumChangeMny = changeRecordVO.getSumChangeMny() ==null ? BigDecimal.ZERO : changeRecordVO.getSumChangeMny();
        if(sumChangeMny.compareTo(BigDecimal.ZERO)!=0&&baseTaxMny.compareTo(BigDecimal.ZERO)!=0){
            BigDecimal sumScale = (sumChangeMny.divide(baseTaxMny, 8,ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
            changeRecordVO.setSumScale(sumScale);
        }
        if(null != contractEntity.getChangeVersion() && contractEntity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<ChangeEntity> lambda = Wrappers.<ChangeEntity>lambdaQuery();
            lambda.eq(ChangeEntity::getContractId,id);
            lambda.in(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            List<ChangeEntity> entities = super.list(lambda);
            List<ChangeRecordDetailVO> changeVoList=BeanMapper.mapList(entities, ChangeRecordDetailVO.class);
            for (ChangeRecordDetailVO changeRecordDetailVO : changeVoList) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(changeRecordDetailVO.getChangeDate());
                String historyBillCode = changeRecordDetailVO.getBeforeContractName() + "-" + changeTime + "-" + changeRecordDetailVO.getChangeVersion();
                changeRecordDetailVO.setHistoryBillCode(historyBillCode);
			}
//            entities.forEach(changevo -> {
//                        if(changevo.getChangeVersion()<10){
//                            changevo.setBillCode(changevo.getBillCode()+"-0"+changevo.getChangeVersion());
//                        }else{
//                            changevo.setBillCode(changevo.getBillCode()+"-"+changevo.getChangeVersion());
//                        }
//                    }
//            );
            changeRecordVO.setDetailList(changeVoList);
        }
        Boolean editFlag = contractService.editFlag(id);
        changeRecordVO.setEditFlag(editFlag);
        return changeRecordVO;
    }
    private Boolean checkFinishContract(ChangeVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getId, finishVO.getContractId());
        lambda.eq(ContractEntity::getTenantId, tenantId);
        lambda.eq(ContractEntity::getFinishFlag, true);
        return contractService.list(lambda).size() > 0;
    }
}
